/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.resourcefinder;

import amf.core.client.common.remote.Content;
import amf.core.client.platform.resource.ClientResourceLoader;
import amf.core.client.platform.resource.ResourceNotFound;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.mule.alsp.extensions.resourcefinder.IResourceFinder;
import org.mule.alsp.extensions.resourcefinder.ResourceFinderException;

public class ResourceFinderWrapper
implements ClientResourceLoader {
    private IResourceFinder finder;
    private static final Logger LOG = Logger.getLogger(ResourceFinderWrapper.class.getName());

    public ResourceFinderWrapper(IResourceFinder finder) {
        this.finder = finder;
    }

    public CompletableFuture<Content> fetch(String resource) {
        Optional<IStorage> findResource = this.finder.findResource(resource);
        if (!findResource.isPresent()) {
            return ResourceFinderWrapper.failedFinder(resource);
        }
        String api = "";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream resourceURI = findResource.get().getContents();){
                api = IOUtils.toString((InputStream)resourceURI, (Charset)Charset.defaultCharset());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            LOG.severe(e.getMessage());
            return ResourceFinderWrapper.failedFinder(resource);
        }
        Content content = new Content(api, resource);
        return CompletableFuture.completedFuture(content);
    }

    public boolean accepts(String resource) {
        return this.finder.applies(resource);
    }

    private static CompletableFuture<Content> failedFinder(String resource) {
        return CompletableFuture.supplyAsync(() -> {
            throw new ResourceFinderException((Throwable)new ResourceNotFound(resource));
        });
    }
}

