/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.resourcefinder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mule.alsp.extensions.resourcefinder.IResourceFinder;
import org.mule.alsp.extensions.resourcefinder.IResourceFinderManager;
import org.mule.alsp.extensions.resourcefinder.ResourceFinderException;

public class ResourceFinderManager
implements IResourceFinderManager {
    private static final String FAILED_LOADING_CONTAINER_BEHAVIORS_EXTENSION_POINTS = "Failed loading resource finder extension points";
    private static final String EXTENSION_ID_RESOURCE_FINDER_ID = "org.mule.alsp.resourceFinder";
    private static final String EXT_ATT_FINDER_ID = "class";
    private static ResourceFinderManager instance;
    private List<IResourceFinder> resourceFinders = new ArrayList<IResourceFinder>();

    public static ResourceFinderManager instance() {
        if (instance == null) {
            instance = new ResourceFinderManager();
        }
        return instance;
    }

    private ResourceFinderManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry == null) {
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(EXTENSION_ID_RESOURCE_FINDER_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                IResourceFinder behaviorImpl = ResourceFinderManager.instantiateBehavior(configurationElement);
                this.resourceFinders.add(behaviorImpl);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new ResourceFinderException(FAILED_LOADING_CONTAINER_BEHAVIORS_EXTENSION_POINTS, e);
        }
    }

    protected static IResourceFinder instantiateBehavior(IConfigurationElement configurationElement) throws CoreException {
        return (IResourceFinder)IResourceFinder.class.cast(configurationElement.createExecutableExtension(EXT_ATT_FINDER_ID));
    }

    @Override
    public List<IResourceFinder> getResourceFinders() {
        return this.resourceFinders;
    }
}

