/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.modelchange;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.extensions.modelchange.APIModelChangeEvent;
import org.mule.alsp.extensions.modelchange.IAPIModelChangeListener;

public class APIModelChangeListenerManager {
    private static final String EXTENSION_PROPERTY_NAME = "class";
    private static final String API_MODEL_EXTENSION_ID = "org.mule.alsp.apiModel";
    private static final String LOADING_EXTENSION_POINT_CONTRIBUTION_ERROR = "Could not load the API model extension point contribution";
    private static APIModelChangeListenerManager instance;
    private List<IAPIModelChangeListener> apiModelChangeListener = this.searchListeners();

    public static APIModelChangeListenerManager instance() {
        if (instance == null) {
            instance = new APIModelChangeListenerManager();
        }
        return instance;
    }

    private APIModelChangeListenerManager() {
    }

    private List<IAPIModelChangeListener> searchListeners() {
        ArrayList<IAPIModelChangeListener> listeners = new ArrayList<IAPIModelChangeListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(API_MODEL_EXTENSION_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    IAPIModelChangeListener behaviorImpl = (IAPIModelChangeListener)IAPIModelChangeListener.class.cast(configurationElement.createExecutableExtension(EXTENSION_PROPERTY_NAME));
                    listeners.add(behaviorImpl);
                }
                catch (CoreException e) {
                    ALSPlugin.logError(LOADING_EXTENSION_POINT_CONTRIBUTION_ERROR, e);
                }
                ++n2;
            }
        }
        return listeners;
    }

    public void notifyModelChangesToRegisteredListeners(APIModelChangeEvent changeEvent) {
        this.apiModelChangeListener.forEach(listener -> listener.onModelChange(changeEvent));
    }
}

