/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.directoryresolver;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.mule.alsp.extensions.directoryresolver.IDirectoryResolver;
import org.mule.alsp.helpers.LSUtils;

public class FileSystemDirectoryResolver
implements IDirectoryResolver {
    private static final String HIDDEN_PREFIX = ".";
    private static final String EXCHANGE_JSON = "exchange.json";

    @Override
    public boolean exists(String path) {
        IPath resourcePath = LSUtils.getResourcePathFromString(path);
        File file = resourcePath.toFile();
        return file.exists();
    }

    @Override
    public boolean isDirectory(String path) {
        IPath resourcePath = LSUtils.getResourcePathFromString(path);
        return resourcePath.toFile().isDirectory();
    }

    @Override
    public List<String> readDir(String path) {
        IPath resourcePath = LSUtils.getResourcePathFromString(path);
        String[] list = resourcePath.toFile().list((directory, name) -> !this.isHidden(directory, name) && !EXCHANGE_JSON.equals(name));
        return list != null ? Arrays.asList(list) : Collections.emptyList();
    }

    private boolean isHidden(File directory, String name) {
        return new File(directory, name).isHidden() || name.startsWith(HIDDEN_PREFIX);
    }
}

