/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.directoryresolver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mule.alsp.extensions.directoryresolver.DirectoryResolverException;
import org.mule.alsp.extensions.directoryresolver.IDirectoryResolver;
import org.mule.alsp.extensions.directoryresolver.IDirectoryResolverManager;

public class DirectoryResolverManager
implements IDirectoryResolverManager {
    private static final String FAILED_LOADING_CONTAINER_BEHAVIORS_EXTENSION_POINTS = "Failed loading directory resolver extension points";
    private static final String EXTENSION_ID_RESOURCE_FINDER_ID = "org.mule.alsp.directoryResolver";
    private static final String EXT_ATT_FINDER_ID = "class";
    private static DirectoryResolverManager instance;
    private List<IDirectoryResolver> directoryResolvers = new ArrayList<IDirectoryResolver>();

    public static DirectoryResolverManager instance() {
        if (instance == null) {
            instance = new DirectoryResolverManager();
        }
        return instance;
    }

    private DirectoryResolverManager() {
        this.initialize();
    }

    private void initialize() {
        try {
            IConfigurationElement[] configurationElements;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry == null) {
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(EXTENSION_ID_RESOURCE_FINDER_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                IDirectoryResolver behaviorImpl = DirectoryResolverManager.instantiateBehavior(configurationElement);
                this.directoryResolvers.add(behaviorImpl);
                ++n2;
            }
        }
        catch (CoreException e) {
            throw new DirectoryResolverException(FAILED_LOADING_CONTAINER_BEHAVIORS_EXTENSION_POINTS, e);
        }
    }

    protected static IDirectoryResolver instantiateBehavior(IConfigurationElement configurationElement) throws CoreException {
        return (IDirectoryResolver)IDirectoryResolver.class.cast(configurationElement.createExecutableExtension(EXT_ATT_FINDER_ID));
    }

    @Override
    public List<IDirectoryResolver> getDirectoryResolvers() {
        return this.directoryResolvers;
    }
}

