/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.extensions.directoryresolver;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.mule.alsp.extensions.directoryresolver.IDirectoryResolverManager;
import org.mulesoft.als.configuration.ClientDirectoryResolver;

public class ComposableDirectoryResolver
implements ClientDirectoryResolver {
    private IDirectoryResolverManager directoryResolverManager;

    public ComposableDirectoryResolver(IDirectoryResolverManager directoryResolverManager) {
        this.directoryResolverManager = directoryResolverManager;
    }

    public CompletableFuture<Object> exists(String path) {
        return CompletableFuture.completedFuture(this.directoryResolverManager.getDirectoryResolvers().stream().anyMatch(directoryResolver -> directoryResolver.exists(path)));
    }

    public CompletableFuture<Object> isDirectory(String path) {
        return CompletableFuture.completedFuture(this.directoryResolverManager.getDirectoryResolvers().stream().anyMatch(directoryResolver -> directoryResolver.isDirectory(path)));
    }

    public CompletableFuture<List<String>> readDir(String path) {
        return CompletableFuture.completedFuture(this.directoryResolverManager.getDirectoryResolvers().stream().map(directoryResolver -> directoryResolver.readDir(path)).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }
}

