/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.mule.alsp.exception.IllegalCreationException;

public class WidgetUtils {
    private static final String CONTENT_ASSIST = "content.assist";

    private WidgetUtils() {
        throw new IllegalCreationException();
    }

    public static void addEditionCapabilities(TextViewer textViewer) {
        TextViewerUndoManager undoManager = new TextViewerUndoManager(30);
        WidgetUtils.addEditionCapabilities(textViewer, (IUndoManager)undoManager);
    }

    private static void addEditionCapabilities(TextViewer textViewer, IUndoManager undoManager) {
        textViewer.setUndoManager(undoManager);
        undoManager.connect((ITextViewer)textViewer);
        StyledText textWidget = textViewer.getTextWidget();
        HashMap<String, IAction> actions = new HashMap<String, IAction>();
        WidgetUtils.createUndoAndRedoActions((ITextViewer)textViewer, actions);
        WidgetUtils.createEditActions((ITextViewer)textViewer, actions);
        WidgetUtils.createContentAssistAction((ITextViewer)textViewer, actions);
        WidgetUtils.createContextMenu((Control)textWidget, actions);
        KeyListener keyListener = WidgetUtils.createKeyListener(actions);
        textWidget.addKeyListener(keyListener);
        textWidget.addDisposeListener(event -> {
            if (textWidget != null) {
                textWidget.removeKeyListener(keyListener);
                textWidget.getMenu().dispose();
            }
        });
    }

    private static void createUndoAndRedoActions(ITextViewer textViewer, Map<String, IAction> actions) {
        TextViewerAction action = new TextViewerAction(textViewer, 1);
        action.setText("&Undo");
        actions.put(ITextEditorActionConstants.UNDO, (IAction)action);
        action = new TextViewerAction(textViewer, 2);
        action.setText("&Redo");
        actions.put(ITextEditorActionConstants.REDO, (IAction)action);
    }

    private static void createEditActions(ITextViewer textViewer, Map<String, IAction> actions) {
        TextViewerAction action = new TextViewerAction(textViewer, 4);
        action.setText("&Copy");
        actions.put(ITextEditorActionConstants.COPY, (IAction)action);
        action = new TextViewerAction(textViewer, 3);
        action.setText("Cu&t");
        actions.put(ITextEditorActionConstants.CUT, (IAction)action);
        action = new TextViewerAction(textViewer, 5);
        action.setText("&Paste");
        actions.put(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new TextViewerAction(textViewer, 7);
        action.setText("Select &All");
        actions.put(ITextEditorActionConstants.SELECT_ALL, (IAction)action);
    }

    private static void createContentAssistAction(ITextViewer textViewer, Map<String, IAction> actions) {
        TextViewerAction action = new TextViewerAction(textViewer, 13);
        action.setText("Content Assist Proposals");
        actions.put(CONTENT_ASSIST, (IAction)action);
    }

    private static void createContextMenu(Control control, Map<String, IAction> actions) {
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(menuManager -> {
            WidgetUtils.updateActions(actions);
            WidgetUtils.fillContextMenu(menuManager, actions);
        });
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        control.addDisposeListener(event -> manager.dispose());
    }

    private static void fillContextMenu(IMenuManager menu, Map<String, IAction> actions) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", actions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", actions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", actions.get(ITextEditorActionConstants.SELECT_ALL));
    }

    private static void updateActions(Map<String, IAction> actions) {
        for (IAction action : actions.values()) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    private static KeyListener createKeyListener(final Map<String, IAction> actions) {
        final boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                WidgetUtils.updateActions(actions);
                if (this.isUndoKeyPress(e)) {
                    this.runAction(ITextEditorActionConstants.UNDO, actions);
                } else if (this.isRedoKeyPress(e)) {
                    this.runAction(ITextEditorActionConstants.REDO, actions);
                } else if (this.isContentAssistKeyPress(e)) {
                    this.runAction(WidgetUtils.CONTENT_ASSIST, actions);
                }
            }

            private void runAction(String actionID, Map<String, IAction> actions2) {
                IAction action = actions2.get(actionID);
                if (action.isEnabled()) {
                    action.run();
                }
                WidgetUtils.updateActions(actions2);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                if (!isMac) {
                    return (e.stateMask & SWT.MOD1) > 0 && (e.keyCode == 121 || e.keyCode == 89);
                }
                return e.keyCode == 122 && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & 0x20000) != 0;
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                if (!isMac) {
                    return (e.stateMask & SWT.MOD1) > 0 && (e.keyCode == 122 || e.keyCode == 90);
                }
                return e.keyCode == 122 && (e.stateMask & SWT.MOD1) != 0 && (e.stateMask & 0x20000) == 0;
            }

            private boolean isContentAssistKeyPress(KeyEvent e) {
                return e.keyCode == 32 && (e.stateMask & 0x40000) != 0;
            }
        };
    }
}

