/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationAutoEditStrategy;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.genericeditor.AutoEditStrategyRegistry;
import org.eclipse.ui.internal.genericeditor.CompositeQuickAssistProcessor;
import org.eclipse.ui.internal.genericeditor.CompositeReconciler;
import org.eclipse.ui.internal.genericeditor.CompositeReconcilerStrategy;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.DefaultContentAssistProcessor;
import org.eclipse.ui.internal.genericeditor.DefaultWordHighlightReconciler;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.PresentationReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.ReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.hover.CompositeTextHover;
import org.eclipse.ui.internal.genericeditor.markers.MarkerResoltionQuickAssistProcessor;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.alsp.ALSPlugin;

public class EmbeddedApiEditorViewerConfiguration
extends TextSourceViewerConfiguration
implements IDocumentPartitioningListener {
    private Set<IContentType> contentTypes;
    private IDocument document;
    private ContentAssistant contentAssistant;
    private List<IContentAssistProcessor> processors;
    private String contentTypeId;

    public EmbeddedApiEditorViewerConfiguration(String contentTypeId, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.contentTypeId = contentTypeId;
    }

    Set<IContentType> getContentTypes(ISourceViewer viewer) {
        if (this.contentTypes == null) {
            this.contentTypes = new LinkedHashSet<IContentType>();
            LinkedList<IContentType> types = new LinkedList<IContentType>(Arrays.asList(Platform.getContentTypeManager().getContentType(this.contentTypeId)));
            while (!types.isEmpty()) {
                IContentType type = (IContentType)types.poll();
                this.contentTypes.add(type);
                IContentType parent = type.getBaseType();
                if (parent == null) continue;
                types.add(parent);
            }
        }
        return this.contentTypes;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        List hovers = GenericEditorPlugin.getDefault().getHoverRegistry().getAvailableHovers(sourceViewer, null, this.getContentTypes(sourceViewer));
        if (hovers == null || hovers.isEmpty()) {
            return null;
        }
        if (hovers.size() == 1) {
            return (ITextHover)hovers.get(0);
        }
        return new CompositeTextHover(hovers);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistProcessorRegistry registry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
        this.contentAssistant = new ContentAssistant(true);
        this.contentAssistant.setContextInformationPopupOrientation(21);
        this.contentAssistant.setProposalPopupOrientation(11);
        this.contentAssistant.setAutoActivationDelay(0);
        this.contentAssistant.enableColoredLabels(true);
        this.contentAssistant.enableAutoActivation(true);
        this.processors = registry.getContentAssistProcessors(sourceViewer, null, this.getContentTypes(sourceViewer));
        if (this.processors.isEmpty()) {
            this.processors.add((IContentAssistProcessor)new DefaultContentAssistProcessor());
        }
        for (IContentAssistProcessor processor : this.processors) {
            this.contentAssistant.addContentAssistProcessor(processor, "__dftl_partition_content_type");
        }
        if (this.document != null) {
            this.associateTokenContentTypes(this.document);
        }
        this.contentAssistant.setInformationControlCreator((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        this.watchDocument(sourceViewer.getDocument());
        return this.contentAssistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconcilerRegistry registry = GenericEditorPlugin.getDefault().getPresentationReconcilerRegistry();
        List reconciliers = registry.getPresentationReconcilers(sourceViewer, null, this.getContentTypes(sourceViewer));
        if (!reconciliers.isEmpty()) {
            return (IPresentationReconciler)reconciliers.get(0);
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    void watchDocument(IDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
        if (document != null) {
            this.document = document;
            this.associateTokenContentTypes(document);
            document.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
    }

    public void documentPartitioningChanged(IDocument document) {
        this.associateTokenContentTypes(document);
    }

    private void associateTokenContentTypes(IDocument document) {
        if (this.contentAssistant == null || this.processors == null) {
            return;
        }
        String[] stringArray = document.getLegalContentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String legalTokenContentType = stringArray[n2];
            for (IContentAssistProcessor processor : this.processors) {
                this.contentAssistant.addContentAssistProcessor(processor, legalTokenContentType);
            }
            ++n2;
        }
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssistAssistant = new QuickAssistAssistant();
        ArrayList<MarkerResoltionQuickAssistProcessor> quickAssistProcessors = new ArrayList<MarkerResoltionQuickAssistProcessor>();
        quickAssistProcessors.add(new MarkerResoltionQuickAssistProcessor());
        quickAssistProcessors.addAll(GenericEditorPlugin.getDefault().getQuickAssistProcessorRegistry().getQuickAssistProcessors(sourceViewer, null, this.getContentTypes(sourceViewer)));
        CompositeQuickAssistProcessor compQuickAssistProcessor = new CompositeQuickAssistProcessor(quickAssistProcessors);
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)compQuickAssistProcessor);
        quickAssistAssistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        quickAssistAssistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString()));
        return quickAssistAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        NullEditor editor = new NullEditor();
        ReconcilerRegistry registry = GenericEditorPlugin.getDefault().getReconcilerRegistry();
        ArrayList reconcilingStrategies = new ArrayList();
        List reconcilers = registry.getReconcilers(sourceViewer, null, reconcilingStrategies, this.getContentTypes(sourceViewer));
        ArrayList highlightReconcilingStrategies = new ArrayList();
        List highlightReconcilers = registry.getHighlightReconcilers(sourceViewer, (ITextEditor)editor, highlightReconcilingStrategies, this.getContentTypes(sourceViewer));
        if (!highlightReconcilers.isEmpty()) {
            reconcilers.addAll(highlightReconcilers);
        } else if (highlightReconcilingStrategies.isEmpty()) {
            reconcilers.add(new DefaultWordHighlightReconciler());
        }
        reconcilingStrategies.addAll(highlightReconcilingStrategies);
        ArrayList foldingReconcilingStrategies = new ArrayList();
        List foldingReconcilers = registry.getFoldingReconcilers(sourceViewer, (ITextEditor)editor, foldingReconcilingStrategies, this.getContentTypes(sourceViewer));
        if (!foldingReconcilers.isEmpty()) {
            reconcilers.addAll(foldingReconcilers);
        }
        reconcilingStrategies.addAll(foldingReconcilingStrategies);
        if (!reconcilingStrategies.isEmpty()) {
            Reconciler reconciler = new Reconciler();
            reconciler.setReconcilingStrategy((IReconcilingStrategy)new CompositeReconcilerStrategy(reconcilingStrategies), "__dftl_partition_content_type");
            reconcilers.add(0, reconciler);
        }
        if (!reconcilers.isEmpty()) {
            return new CompositeReconciler(reconcilers);
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        AutoEditStrategyRegistry registry = GenericEditorPlugin.getDefault().getAutoEditStrategyRegistry();
        List editStrategies = registry.getAutoEditStrategies(sourceViewer, null, this.getContentTypes(sourceViewer));
        this.injectSourceViewerToTM4E(editStrategies, sourceViewer);
        if (!editStrategies.isEmpty()) {
            return editStrategies.toArray(new IAutoEditStrategy[editStrategies.size()]);
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        return super.getHyperlinkDetectorTargets(sourceViewer);
    }

    private void injectSourceViewerToTM4E(List<IAutoEditStrategy> editStrategies, ISourceViewer sourceViewer) {
        for (IAutoEditStrategy iAutoEditStrategy : editStrategies) {
            if (!(iAutoEditStrategy instanceof LanguageConfigurationAutoEditStrategy)) continue;
            try {
                Field viewerField = LanguageConfigurationAutoEditStrategy.class.getDeclaredField("viewer");
                viewerField.setAccessible(true);
                viewerField.set(iAutoEditStrategy, sourceViewer);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                ALSPlugin.logWarning("Failed to inject viewer to TM4E", e);
            }
        }
    }

    private static class NullEditor
    extends AbstractTextEditor {
        private IEditorInput input = new NullEditorInput();

        public IEditorInput getEditorInput() {
            return this.input;
        }
    }
}

