/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.editor;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.VirtualFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.lsp4e.ConnectDocumentToLanguageServerSetupParticipant;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.editor.EmbeddedApiEditorViewerConfiguration;
import org.mule.alsp.editor.WidgetUtils;

public class EmbeddedApiEditor {
    private static final int VERTICAL_RULER_WIDTH = 12;
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.error";
    private static final String ANNOTATION_TEXT_KEY = "errorIndication";
    private static final String ANNOTATION_COLOR_KEY = "errorIndicationColor";
    private static final String ANNOTATION_HIGHLIGHT_KEY = "errorIndicationHighlighting";
    private static final String ANNOTATION_VERTICAL_RULER_KEY = "errorIndicationInVerticalRuler";
    private static final String ANNOTATION_OVERVIEW_RULER_KEY = "errorIndicationInOverviewRuler";
    private static final Color DARK_BACKGROUND_COLOR = new Color((Device)Display.getCurrent(), new RGB(34, 34, 34));
    private static final Color DARK_FOREGROUND_COLOR = new Color((Device)Display.getCurrent(), new RGB(223, 223, 223));
    private IDocument document;
    private IAnnotationModel annotationModel;
    private StyledText styledText;
    private SupportedContentTypes contentType;
    private boolean isDarkMode = false;
    private IFileStore fileStore;
    private SourceViewerDecorationSupport sourceViewerDecorationSupport;

    public EmbeddedApiEditor(SupportedContentTypes contentType) {
        this.contentType = contentType;
    }

    public EmbeddedApiEditor(SupportedContentTypes contentType, boolean isDarkMode) {
        this.contentType = contentType;
        this.isDarkMode = isDarkMode;
    }

    public Composite createApiEditor(Composite parent) throws CoreException {
        Composite wrapper = new Composite(parent, 0);
        SourceViewer sourceViewer = this.createSourceViewer(wrapper);
        this.document = sourceViewer.getDocument();
        this.annotationModel = sourceViewer.getAnnotationModel();
        this.styledText = sourceViewer.getTextWidget();
        this.setupInLanguageServer(this.document);
        this.styledText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.styledText);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(sourceViewer.getControl());
        return wrapper;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    public void dispose() {
        this.sourceViewerDecorationSupport.dispose();
        try {
            ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
            textFileBufferManager.disconnectFileStore(this.fileStore, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ALSPlugin.logError("Could not dispose Embedded API Editor", e);
        }
    }

    private SourceViewer createSourceViewer(Composite parent) throws CoreException {
        ITextFileBuffer fileBuffer = this.createFileBuffer();
        IDocument embeddedDocument = fileBuffer.getDocument();
        AnnotationModel embeddedAnnotationModel = (AnnotationModel)fileBuffer.getAnnotationModel();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        IVerticalRuler ruler = this.createVerticalRuler((IAnnotationModel)embeddedAnnotationModel, (IAnnotationAccess)annotationAccess);
        embeddedAnnotationModel.connect(embeddedDocument);
        int styles = 68418;
        ProjectionViewer sourceViewer = new ProjectionViewer(parent, ruler, null, true, styles);
        sourceViewer.setDocument(embeddedDocument, (IAnnotationModel)embeddedAnnotationModel);
        sourceViewer.configure((SourceViewerConfiguration)new EmbeddedApiEditorViewerConfiguration(this.contentType.getId(), EditorsPlugin.getDefault().getPreferenceStore()));
        this.setupDecorationSupport((ISourceViewer)sourceViewer, (IAnnotationAccess)annotationAccess);
        WidgetUtils.addEditionCapabilities((TextViewer)sourceViewer);
        return sourceViewer;
    }

    private ITextFileBuffer createFileBuffer() throws CoreException {
        this.fileStore = this.createVirtualFileStore();
        ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
        textFileBufferManager.connectFileStore(this.fileStore, (IProgressMonitor)new NullProgressMonitor());
        return textFileBufferManager.getFileStoreTextFileBuffer(this.fileStore);
    }

    private IFileStore createVirtualFileStore() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProjects()[0];
        IFile file = project.getFile("embedded-api-editor-" + System.currentTimeMillis() + "." + this.contentType.getExtensions().get(0));
        return new VirtualFileStore(file.getLocationURI()){

            public String getName() {
                return this.toURI().toString();
            }
        };
    }

    private IVerticalRuler createVerticalRuler(IAnnotationModel annotationModel, IAnnotationAccess annotationAccess) {
        AnnotationRulerColumn annotationRulerColumn = new AnnotationRulerColumn(annotationModel, 12, annotationAccess);
        annotationRulerColumn.addAnnotationType((Object)ANNOTATION_TYPE);
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)annotationRulerColumn);
        LineNumberRulerColumn lineNumberRulerColumn = new LineNumberRulerColumn();
        if (this.isDarkMode) {
            lineNumberRulerColumn.setBackground(DARK_BACKGROUND_COLOR);
            lineNumberRulerColumn.setForeground(DARK_FOREGROUND_COLOR);
        }
        ruler.addDecorator(1, (IVerticalRulerColumn)lineNumberRulerColumn);
        return ruler;
    }

    private AnnotationPreference createAnnotationPreference() {
        AnnotationPreference annotationPreference = new AnnotationPreference();
        annotationPreference.setAnnotationType((Object)ANNOTATION_TYPE);
        annotationPreference.setOverviewRulerPreferenceKey(ANNOTATION_OVERVIEW_RULER_KEY);
        annotationPreference.setColorPreferenceKey(ANNOTATION_COLOR_KEY);
        annotationPreference.setTextPreferenceKey(ANNOTATION_TEXT_KEY);
        annotationPreference.setVerticalRulerPreferenceKey(ANNOTATION_VERTICAL_RULER_KEY);
        annotationPreference.setHighlightPreferenceKey(ANNOTATION_HIGHLIGHT_KEY);
        return annotationPreference;
    }

    private void setupDecorationSupport(ISourceViewer sourceViewer, IAnnotationAccess annotationAccess) {
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        AnnotationPreference annotationPreference = this.createAnnotationPreference();
        this.sourceViewerDecorationSupport = new SourceViewerDecorationSupport(sourceViewer, null, annotationAccess, sharedColors);
        this.sourceViewerDecorationSupport.setAnnotationPreference(annotationPreference);
        this.sourceViewerDecorationSupport.install(EditorsPlugin.getDefault().getPreferenceStore());
    }

    private void setupInLanguageServer(IDocument document) {
        ConnectDocumentToLanguageServerSetupParticipant lsSetupParticipant = new ConnectDocumentToLanguageServerSetupParticipant();
        lsSetupParticipant.setup(document);
    }
}

