/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.editor;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.api.AlspUtils;

public class ActiveEditorListener
implements IPartListener2 {
    private static final Integer DID_FOCUS_VERSION = 1;
    public static final String DID_FOCUS_CHANGE_COMMAND = "didFocusChange";
    private IContextActivation activateContext;
    private static final String EDITOR_CONTEXT = "org.mule.tooling.contexts.apiEditor";

    public void partActivated(IWorkbenchPartReference partRef) {
        if (!ALSPlugin.getDefault().isAlsInitialized()) {
            return;
        }
        if (!(partRef instanceof IEditorReference)) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IPathEditorInput)) {
            return;
        }
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null) {
            IContextService contextService = (IContextService)part.getSite().getService(IContextService.class);
            this.activateContext = contextService.activateContext(EDITOR_CONTEXT);
        }
        IPathEditorInput input = (IPathEditorInput)editor.getEditorInput();
        ArrayList<DidFocusParams> args = new ArrayList<DidFocusParams>();
        DidFocusParams didFocusParams = new DidFocusParams();
        didFocusParams.setUri(input.getPath().toFile().toURI().toString());
        didFocusParams.setVersion(DID_FOCUS_VERSION);
        args.add(didFocusParams);
        Command command = new Command("File focus change", DID_FOCUS_CHANGE_COMMAND, args);
        ExecuteCommandParams params = new ExecuteCommandParams();
        params.setCommand(command.getCommand());
        params.setArguments(command.getArguments());
        Consumer<LanguageServer> languageServerConsumer = server -> {
            CompletableFuture completableFuture = server.getWorkspaceService().executeCommand(params);
        };
        Predicate<ServerCapabilities> serverCapabilities = capabilities -> {
            ExecuteCommandOptions provider = capabilities.getExecuteCommandProvider();
            return provider != null && provider.getCommands().contains(command.getCommand());
        };
        AlspUtils.executeCommand(input, serverCapabilities, languageServerConsumer);
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        IContextService contextService;
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && (contextService = (IContextService)part.getSite().getService(IContextService.class)).getActiveContextIds().contains(EDITOR_CONTEXT)) {
            contextService.deactivateContext(this.activateContext);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public ITextEditor getTextEditor() {
        return ActiveEditorListener.getActiveTextEditor();
    }

    public static ITextEditor getActiveTextEditor() {
        MultiPageEditorPart multiPageEditorPart;
        Object page;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        if (editorPart instanceof MultiPageEditorPart && (page = (multiPageEditorPart = (MultiPageEditorPart)editorPart).getSelectedPage()) instanceof ITextEditor) {
            return (ITextEditor)page;
        }
        return null;
    }

    public IFile getResource(IPathEditorInput input) {
        return (IFile)ResourceUtil.getResource((IEditorInput)input);
    }

    public static class DidFocusParams {
        private String uri;
        private Integer version;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }
    }
}

