/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.mule.alsp.ALSPlugin;

public class SocketServerLauncher {
    private static final Logger LOG = Logger.getLogger(SocketServerLauncher.class.getName());
    private int serverPort;
    private boolean stopServer = false;
    private ServerSocket serverSocket = null;

    public void start() {
        if (this.serverSocket != null) {
            return;
        }
        try {
            LOG.info("Starting socket server");
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
            this.serverPort = this.serverSocket.getLocalPort();
            LOG.info("Started socket server");
        }
        catch (IOException e1) {
            this.serverPort = 0;
            LOG.severe(e1.getMessage());
            ALSPlugin.logError(e1);
        }
    }

    public void close() {
        this.stopServer = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
                ALSPlugin.logError(e);
            }
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public CompletableFuture<Socket> connect() {
        if (this.stopServer) {
            CompletableFuture<Socket> future = new CompletableFuture<Socket>();
            future.complete(null);
            return future;
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                LOG.info("Incoming connection request");
                Socket socket = this.serverSocket.accept();
                LOG.info("Connection accepted");
                return socket;
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
                ALSPlugin.logError(e);
                return null;
            }
        });
    }
}

