/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.connection;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.Future;
import java.util.logging.Logger;

class ClientAsync
extends Thread {
    private static final Logger LOG = Logger.getLogger(ClientAsync.class.getName());
    private AsynchronousSocketChannel client;
    private Future<Void> connectFuture;

    public ClientAsync(SocketAddress server) throws IOException {
        LOG.info("Open client channel");
        this.client = AsynchronousSocketChannel.open();
        LOG.info("Connect to server");
        this.connectFuture = this.client.connect(server);
    }

    @Override
    public void run() {
        if (!this.connectFuture.isDone()) {
            this.connectFuture.cancel(true);
        }
    }

    public void close() throws IOException {
        this.client.close();
    }

    public AsynchronousSocketChannel getClientChannel() {
        return this.client;
    }
}

