/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class ALSPSocketOutputStream
extends OutputStream {
    private static final String SOCKET_CLOSED = "Socket closed";
    private OutputStream os;

    public ALSPSocketOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public int hashCode() {
        return this.os.hashCode();
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.os.write(b);
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (SOCKET_CLOSED.equals(msg)) {
                return;
            }
            throw ex;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.os.write(b, off, len);
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (SOCKET_CLOSED.equals(msg)) {
                return;
            }
            throw ex;
        }
    }

    public boolean equals(Object obj) {
        return this.os.equals(obj);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.os.flush();
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (SOCKET_CLOSED.equals(msg)) {
                return;
            }
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.os.close();
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (SOCKET_CLOSED.equals(msg)) {
                return;
            }
            throw ex;
        }
    }

    public String toString() {
        return this.os.toString();
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.os.write(b);
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (SOCKET_CLOSED.equals(msg)) {
                return;
            }
            throw ex;
        }
    }
}

