/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.connection;

import amf.core.client.platform.resource.ClientResourceLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.connection.ALSPSocketInputStream;
import org.mule.alsp.connection.ALSPSocketOutputStream;
import org.mule.alsp.extensions.directoryresolver.ComposableDirectoryResolver;
import org.mule.alsp.extensions.directoryresolver.DirectoryResolverManager;
import org.mule.alsp.extensions.resourcefinder.ResourceFinderManager;
import org.mule.alsp.extensions.resourcefinder.ResourceFinderWrapper;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.protocol.client.ALSPLanguageClientDecorator;
import org.mule.alsp.protocol.client.apb.ExchangeModulesDependencyFetcher;
import org.mule.alsp.protocol.server.ALSPLanguageServerWrapper;
import org.mulesoft.als.configuration.ClientDirectoryResolver;
import org.mulesoft.als.logger.EmptyLogger;
import org.mulesoft.als.logger.Logger;
import org.mulesoft.als.logger.PrintLnLogger;
import org.mulesoft.als.logger.PrintLnLogger$;
import org.mulesoft.als.server.JvmSerializationProps;
import org.mulesoft.als.server.SerializationProps;
import org.mulesoft.als.server.client.platform.AlsClientNotifier;
import org.mulesoft.als.server.client.platform.ClientNotifier;
import org.mulesoft.als.server.lsp4j.LanguageClientWrapper;
import org.mulesoft.als.server.lsp4j.LanguageServerImpl;
import org.mulesoft.als.server.lsp4j.extension.ExtendedLanguageServer;
import org.mulesoft.als.server.lsp4j.internal.GsonConsumerBuilder;
import org.mulesoft.als.server.modules.diagnostic.DiagnosticNotificationsKind;
import org.mulesoft.anypoint.server.platform.AnypointClientConnection;
import org.mulesoft.anypoint.server.platform.AnypointLanguageServerFactory;
import org.mulesoft.apb.project.client.platform.environment.DependencyFetcher;
import org.mulesoft.lsp.client.LspLanguageClient;

public class ALSPSocketConnectionProvider
implements StreamConnectionProvider,
AutoCloseable {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(ALSPSocketConnectionProvider.class.getName());
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream errorStream;
    private InputStream serverInputStream;
    private OutputStream serverOutputStream;
    private WorkspaceService workspace;
    private TextDocumentService textDocumentService;
    private Launcher<LanguageClient> launcher;
    private ExtendedLanguageServer server;
    private LanguageClient client;
    private Boolean verbose = null;
    private Socket socketClient = null;
    private Socket openedSocket = null;

    public ALSPSocketConnectionProvider() {
        LOG.info("Initializing ALSPSocketConnectionProvider");
        ALSPlugin.getSocketServerLauncher().start();
    }

    public void start() throws IOException {
        LOG.info("ALSPSocketConnectionProvider - prepare to connect");
        CompletableFuture<Socket> serverSocketComplete = ALSPlugin.getSocketServerLauncher().connect();
        try {
            LOG.info("ALSPSocketConnectionProvider - attempting to connect");
            this.socketClient = new Socket("localhost", ALSPlugin.getSocketServerLauncher().getServerPort());
            LOG.fine("ALSPSocketConnectionProvider - waiting to accept");
            this.openedSocket = serverSocketComplete.get(5L, TimeUnit.SECONDS);
            this.initializeLS(serverSocketComplete);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            ALSPlugin.logError(e);
            serverSocketComplete.cancel(true);
        }
    }

    private void initializeLS(CompletableFuture<Socket> serverSocketComplete) {
        try {
            LOG.fine("ALSPSocketConnectionProvider - getting streams");
            this.serverInputStream = new ALSPSocketInputStream(new BufferedInputStream(this.openedSocket.getInputStream()));
            this.serverOutputStream = new ALSPSocketOutputStream(new BufferedOutputStream(this.openedSocket.getOutputStream()));
            this.inputStream = new ALSPSocketInputStream(new BufferedInputStream(this.socketClient.getInputStream()));
            this.outputStream = new ALSPSocketOutputStream(new BufferedOutputStream(this.socketClient.getOutputStream()));
            this.errorStream = new ByteArrayInputStream("Error output on console".getBytes(StandardCharsets.UTF_8));
            PrintLnLogger$ alsLogger = this.isVerbose() ? PrintLnLogger.withSettings(null) : EmptyLogger.withSettings(null);
            AnypointClientConnection clientConnection = new AnypointClientConnection();
            ExchangeModulesDependencyFetcher dependencyFetcher = new ExchangeModulesDependencyFetcher("");
            LanguageServerImpl alsserver = new LanguageServerImpl(new AnypointLanguageServerFactory((ClientNotifier)clientConnection, (DependencyFetcher)dependencyFetcher).withLogger((Logger)alsLogger).withSerializationProps((SerializationProps)new JvmSerializationProps((AlsClientNotifier)clientConnection)).withNotificationKind(DiagnosticNotificationsKind.allTogether()).withDirectoryResolver((ClientDirectoryResolver)new ComposableDirectoryResolver(DirectoryResolverManager.instance())).withAdditionalResourceLoaders(ALSPSocketConnectionProvider.buildResourceLoaders()).withGovernanceMode(false).build());
            this.server = new ALSPLanguageServerWrapper(alsserver);
            Launcher.Builder builder = new Launcher.Builder().configureGson((Consumer)new GsonConsumerBuilder()).setLocalService((Object)this.server).setRemoteInterface(LanguageClient.class).setInput(this.serverInputStream).setOutput(this.serverOutputStream);
            if (this.isVerbose()) {
                builder.traceMessages(new PrintWriter(System.out));
            }
            this.launcher = builder.create();
            this.client = new ALSPLanguageClientDecorator((LanguageClient)this.launcher.getRemoteProxy());
            LanguageClientWrapper clientWrapper = new LanguageClientWrapper(this.client);
            clientConnection.connect((LspLanguageClient)clientWrapper);
            this.textDocumentService = this.server.getTextDocumentService();
            this.workspace = this.server.getWorkspaceService();
            this.launcher.startListening();
            LOG.info("ALSPSocketConnectionProvider - Listening");
        }
        catch (IOException exc) {
            Thread.currentThread().interrupt();
            ALSPlugin.logError(exc);
            serverSocketComplete.cancel(true);
        }
    }

    private static List<ClientResourceLoader> buildResourceLoaders() {
        List<ClientResourceLoader> clientResourceLoaders = ResourceFinderManager.instance().getResourceFinders().stream().map(ResourceFinderWrapper::new).collect(Collectors.toList());
        return clientResourceLoaders;
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootURI) {
        if (message instanceof NotificationMessage) {
            NotificationMessage notifyMsg = (NotificationMessage)message;
            Object params = notifyMsg.getParams();
            LSUtils.fixParams(params);
        }
        super.handleMessage(message, languageServer, rootURI);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void stop() {
        LOG.info("Stopping ALSPSocketConnectionProvider");
        ALSPlugin.getDefault().setAlsInitialized(false);
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
            if (this.serverInputStream != null) {
                this.serverInputStream.close();
                this.serverInputStream = null;
            }
            if (this.serverOutputStream != null) {
                this.serverOutputStream.close();
                this.serverOutputStream = null;
            }
            if (this.socketClient != null) {
                this.socketClient.close();
                this.socketClient = null;
            }
            if (this.openedSocket != null) {
                this.openedSocket.close();
                this.openedSocket = null;
            }
        }
        catch (IOException ex) {
            ALSPlugin.logError(ex);
        }
    }

    public @Nullable InputStream getErrorStream() {
        return this.errorStream;
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ALSPSocketConnectionProvider that = (ALSPSocketConnectionProvider)object;
        return this.inputStream != null && this.inputStream.equals(that.inputStream) && this.outputStream.equals(that.outputStream);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputStream, this.outputStream, this.errorStream, this.serverInputStream, this.serverOutputStream, this.workspace, this.textDocumentService, this.launcher, this.server, this.client);
    }

    @Override
    public void close() {
        this.stop();
    }

    public boolean isVerbose() {
        if (this.verbose != null) {
            return this.verbose;
        }
        if (LanguageServerPlugin.getDefault() == null) {
            return false;
        }
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        if (store == null) {
            return false;
        }
        return store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId((String)ALSPlugin.getDefault().getServerId()));
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

