/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.ResourceUtil;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.SupportedContentTypes;
import org.mule.alsp.exception.IllegalCreationException;

public class AlspUtils {
    private static final String SLASH = "/";
    private static final String THERE_WAS_AN_ISSUE_GETTING_THE_CONTENTS_OF_A_FILE = "There was an issue getting the contents of a file";
    private static final String THERE_WAS_AN_ISSUE_WHILE_TRAVERSING_THE_PROJECTS_RESOURCES = "There was an issue while traversing the projects resources";

    private AlspUtils() {
        throw new IllegalCreationException();
    }

    public static Optional<LanguageServers.LanguageServerDocumentExecutor> getLanguageServersList(IFile file, Predicate<ServerCapabilities> predicate) {
        try {
            IDocument document;
            TextFileDocumentProvider provider = new TextFileDocumentProvider();
            try {
                provider.connect((Object)file);
                document = provider.getDocument((Object)file);
            }
            finally {
                provider.disconnect((Object)file);
            }
            LanguageServers.LanguageServerDocumentExecutor lsDocExecutor = LanguageServers.forDocument((IDocument)document);
            return Optional.ofNullable(lsDocExecutor);
        }
        catch (CoreException e) {
            ALSPlugin.logError(e);
            return Optional.empty();
        }
    }

    public static void executeCommand(IPathEditorInput editorInput, Predicate<ServerCapabilities> serverCapabilities, Consumer<LanguageServer> languageServerConsumer) {
        AlspUtils.executeCommand((IFile)ResourceUtil.getResource((IEditorInput)editorInput), serverCapabilities, languageServerConsumer);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void executeCommand(IFile file, Predicate<ServerCapabilities> serverCapabilities, final Consumer<LanguageServer> languageServerConsumer) {
        Optional<LanguageServers.LanguageServerDocumentExecutor> lsDocExecutor = AlspUtils.getLanguageServersList(file, serverCapabilities);
        if (lsDocExecutor.isEmpty()) {
            ALSPlugin.logWarning("No document executor found to execute command over file: " + String.valueOf(file.getLocationURI()), null);
            return;
        }
        Function<LanguageServer, @NonNull CompletableFuture<?>> f = new Function<LanguageServer, CompletableFuture<?>>(){

            @Override
            public CompletableFuture<?> apply(LanguageServer t) {
                languageServerConsumer.accept(t);
                CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
                completableFuture.complete(null);
                return completableFuture;
            }
        };
        lsDocExecutor.get().collectAll(t -> (CompletableFuture)f.apply((LanguageServer)t));
    }

    public static void reloadProjectDependendencies(IProject project) {
        if (!project.isAccessible() || !ALSPlugin.getDefault().isAlsInitialized()) {
            return;
        }
        try {
            FileCollectorVisitor visitor = new FileCollectorVisitor();
            project.accept((IResourceVisitor)visitor);
            visitor.getFiles().parallelStream().forEach(AlspUtils::fireDidChangeNotification);
        }
        catch (CoreException e) {
            ALSPlugin.logError(THERE_WAS_AN_ISSUE_WHILE_TRAVERSING_THE_PROJECTS_RESOURCES, e);
        }
    }

    private static String toUri(IFile file) {
        Object normalizedURI = file.getRawLocation().toFile().getAbsolutePath().replace(File.separatorChar, '/');
        normalizedURI = ((String)normalizedURI).startsWith(SLASH) ? normalizedURI : SLASH + (String)normalizedURI;
        return "file://" + (String)normalizedURI;
    }

    private static Optional<String> getTextContent(IFile file) {
        String text = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = file.getContents();){
                text = IOUtils.toString((InputStream)contents, (Charset)Charset.defaultCharset());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ALSPlugin.logError(THERE_WAS_AN_ISSUE_GETTING_THE_CONTENTS_OF_A_FILE, e);
        }
        return Optional.ofNullable(text);
    }

    private static DidChangeTextDocumentParams buildDidChangeParams(String uri, String textContent) {
        VersionedTextDocumentIdentifier docId = new VersionedTextDocumentIdentifier(uri, null);
        TextDocumentContentChangeEvent textDoc = new TextDocumentContentChangeEvent();
        textDoc.setText(textContent);
        DidChangeTextDocumentParams params = new DidChangeTextDocumentParams();
        params.setTextDocument(docId);
        params.setContentChanges(Arrays.asList(textDoc));
        return params;
    }

    private static void fireDidChangeNotification(IFile file) {
        String uri = AlspUtils.toUri(file);
        Optional<String> textContent = AlspUtils.getTextContent(file);
        if (!textContent.isPresent()) {
            return;
        }
        DidChangeTextDocumentParams params = AlspUtils.buildDidChangeParams(uri, textContent.get());
        Consumer<LanguageServer> serverConsumer = languageServer -> languageServer.getTextDocumentService().didChange(params);
        AlspUtils.executeCommand(file, (ServerCapabilities capabilities) -> true, serverConsumer);
    }

    private static final class FileCollectorVisitor
    implements IResourceVisitor {
        private static final List<String> VALID_EXTENSIONS = SupportedContentTypes.RAML.getExtensions();
        private ArrayList<IFile> files = new ArrayList();

        public boolean visit(IResource resource) throws CoreException {
            IProject project;
            IFolder folder;
            boolean visit = false;
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null && file.isAccessible() && this.isFileExtensionSupported(file)) {
                this.files.add(file);
            }
            if ((folder = (IFolder)resource.getAdapter(IFolder.class)) != null) {
                visit = true;
            }
            if ((project = (IProject)resource.getAdapter(IProject.class)) != null) {
                visit = true;
            }
            return visit;
        }

        public List<IFile> getFiles() {
            return this.files;
        }

        private boolean isFileExtensionSupported(IFile file) {
            return file.getFileExtension() != null && VALID_EXTENSIONS.contains(file.getFileExtension().toLowerCase());
        }
    }
}

