/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.content.IContentType;

public enum SupportedContentTypes {
    RAML("org.mule.raml", "raml", "yaml", "yml"),
    YAML("org.apieditor.syaml", "raml", "yaml", "yml"),
    JSON("org.apieditor.sjson", "json"),
    UNSUPPORTED("", new String[0]);

    private final String id;
    private final List<String> extensions;

    private SupportedContentTypes(String id, String ... extensions) {
        this.id = id;
        this.extensions = Arrays.asList(extensions);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public String getId() {
        return this.id;
    }

    public static SupportedContentTypes fromContentTypeId(String id) {
        return switch (id) {
            case "org.mule.raml" -> RAML;
            case "org.apieditor.syaml" -> YAML;
            case "org.apieditor.sjson" -> JSON;
            default -> UNSUPPORTED;
        };
    }

    public static boolean isSupported(IContentType contentType) {
        return contentType != null && (contentType.getId().equals(RAML.getId()) || contentType.getId().equals(YAML.getId()) || contentType.getId().equals(JSON.getId()));
    }

    public static SupportedContentTypes fromExtension(String extension) {
        if (JSON.getExtensions().contains(extension)) {
            return JSON;
        }
        if (RAML.getExtensions().contains(extension)) {
            return RAML;
        }
        if (YAML.getExtensions().contains(extension)) {
            return YAML;
        }
        return UNSUPPORTED;
    }
}

