/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.alsp.connection.SocketServerLauncher;
import org.osgi.framework.BundleContext;

public class ALSPlugin
extends AbstractUIPlugin {
    private static final String ID_TAG = "id";
    private static final String SERVER_TAG = "server";
    public static final String PLUGIN_ID = "org.mule.alsp";
    public static final String LSP4E_SERVER_EXTENSION = "org.eclipse.lsp4e.languageServer";
    public static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.mule.alsp/debug"));
    private final SocketServerLauncher socketServerLauncher = new SocketServerLauncher();
    public static final String RAML_CONTENTTYPE_ID = "org.mule.raml";
    public static final String YAML_CONTENTTYPE_ID = "org.apieditor.syaml";
    public static final String JSON_CONTENTTYPE_ID = "org.apieditor.sjson";
    private static ALSPlugin plugin;
    private boolean telemetryEnabled = true;
    private boolean alsTelemetryEnabled = true;
    private boolean alsInitialized = false;
    public final String serverId;

    public ALSPlugin() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IConfigurationElement[] configElements;
            IConfigurationElement[] iConfigurationElementArray = configElements = registry.getConfigurationElementsFor(LSP4E_SERVER_EXTENSION);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                if (PLUGIN_ID.equals(iConfigurationElement.getNamespaceIdentifier()) && SERVER_TAG.equals(iConfigurationElement.getName())) {
                    this.serverId = iConfigurationElement.getAttribute(ID_TAG);
                    return;
                }
                ++n2;
            }
        }
        this.serverId = "org.mule.alsp.server";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ALSPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable thr) {
        if (ALSPlugin.getDefault() == null) {
            return;
        }
        ALSPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, thr.getMessage(), thr));
    }

    public static void logError(String message, Throwable thr) {
        if (ALSPlugin.getDefault() == null) {
            return;
        }
        ALSPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, thr));
    }

    public static void logInfo(String message) {
        if (ALSPlugin.getDefault() == null) {
            return;
        }
        ALSPlugin.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
    }

    public static void logWarning(String message, Throwable thr) {
        if (ALSPlugin.getDefault() == null) {
            return;
        }
        ALSPlugin.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, message, thr));
    }

    public static SocketServerLauncher getSocketServerLauncher() {
        return ALSPlugin.getDefault().socketServerLauncher;
    }

    public static boolean isTelemetryEnabled() {
        return ALSPlugin.getDefault().telemetryEnabled;
    }

    public static boolean isALSTelemetryEnabled() {
        return ALSPlugin.getDefault().alsTelemetryEnabled;
    }

    public String getServerId() {
        return this.serverId;
    }

    public boolean isAlsInitialized() {
        return this.alsInitialized;
    }

    public void setAlsInitialized(boolean alsInitialized) {
        this.alsInitialized = alsInitialized;
    }

    public int getTabReplacementRatio() {
        int ratio = EditorsUI.getPreferenceStore().getInt("tabWidth");
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("apieditor.yaml.override_general_preferences")) {
            ratio = store.getInt("apieditor.yaml.tab_width");
        }
        return ratio;
    }
}

