/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.jeeeyul.swtend.internal.StringUtil;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.internal.Palette;

public class UserHomePalette
implements Palette {
    private File file;
    private ArrayList<HSB> data = new ArrayList();

    public UserHomePalette(String name) {
        String userDir = System.getProperty("user.home");
        this.file = new File(userDir, name);
        if (this.file.exists()) {
            try {
                String[] segmemts;
                FileInputStream fis = new FileInputStream(this.file);
                String content = StringUtil.read(fis, "UTF-8");
                String[] stringArray = segmemts = content.split("\\s*[\r\n]+\\s*");
                int n = segmemts.length;
                int n2 = 0;
                while (n2 < n) {
                    String each = stringArray[n2];
                    if ((each = each.trim()).length() != 0) {
                        this.data.add(HSB.deserialize(each));
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<HSB> getColors() {
        return this.data;
    }

    @Override
    public void save() {
        try {
            PrintWriter writer = new PrintWriter(this.file, "UTF-8");
            for (HSB each : this.data) {
                writer.println(each.serialize());
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

