/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Function1;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.ResourceRegistry;
import net.jeeeyul.swtend.ui.internal.SystemColor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SystemColorLabelProvider
extends LabelProvider {
    private static final SWTExtensions swtExt = SWTExtensions.INSTANCE;
    private ResourceRegistry<SystemColor, Image> imageReg = new ResourceRegistry();

    public SystemColorLabelProvider() {
        this.imageReg.setResourceFactory(new Function1<SystemColor, Image>(){

            @Override
            public Image apply(SystemColor t) {
                RGB fillRGB = Display.getDefault().getSystemColor(t.key).getRGB();
                RGB borderRGB = new HSB(fillRGB).getBrightnessScaled(0.7f).toRGB();
                PaletteData palette = new PaletteData(new RGB[]{fillRGB, borderRGB, new RGB(0, 0, 0)});
                ImageData imageData = new ImageData(16, 16, 2, palette);
                imageData.transparentPixel = 2;
                Rectangle fillArea = swtExt.getShrinked(new Rectangle(0, 0, 16, 16), 2, 2, 3, 3);
                int x = 0;
                while (x < 16) {
                    int y = 0;
                    while (y < 16) {
                        if (swtExt.intersects(fillArea, x, y)) {
                            imageData.setPixel(x, y, 1);
                        } else if (fillArea.contains(x, y)) {
                            imageData.setPixel(x, y, 0);
                        } else {
                            imageData.setPixel(x, y, 2);
                        }
                        ++y;
                    }
                    ++x;
                }
                return new Image((Device)Display.getDefault(), imageData);
            }
        });
    }

    public Image getImage(Object element) {
        return this.imageReg.get((SystemColor)element);
    }

    public String getText(Object element) {
        return ((SystemColor)element).name;
    }

    public void dispose() {
        super.dispose();
        this.imageReg.dispose();
    }
}

