/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class SharedImages {
    public static final String PALETTE = "icons/palette.gif";
    public static final String PIPETTE_MASK = "icons/pipette-mask.png";
    public static final String PIPETTE = "icons/pipette.png";
    private static final ImageRegistry REGISTRY = new ImageRegistry(Display.getDefault());

    public static synchronized Image getImage(String key) {
        Image result = REGISTRY.get(key);
        if (result == null) {
            ImageDescriptor descriptor = SharedImages.loadImageDescriptor(key);
            result = descriptor.createImage();
            REGISTRY.put(key, result);
        }
        return result;
    }

    public static synchronized ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor result = REGISTRY.getDescriptor(key);
        if (result == null) {
            result = SharedImages.loadImageDescriptor(key);
            REGISTRY.put(key, result);
        }
        return result;
    }

    private static ImageDescriptor loadImageDescriptor(String key) {
        try {
            Bundle bundle = Platform.getBundle((String)"net.jeeeyul.swtend");
            URL resource = null;
            resource = bundle != null ? Platform.getBundle((String)"net.jeeeyul.swtend").getResource(key) : new File(key).toURI().toURL();
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)resource);
            return descriptor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
        }
    }
}

