/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import java.util.ArrayList;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class PipetteTool {
    private ArrayList<Shell> pipetteShells = new ArrayList();
    private boolean loopExpired = false;
    private HSB result;
    private ImageData pipetteColorMask;
    private Shell parentShell;

    public PipetteTool(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public HSB open() {
        Display display = Display.getCurrent();
        this.pipetteColorMask = new ImageData(this.getClass().getResourceAsStream("pipette-mask.png"));
        Monitor[] monitorArray = display.getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Shell eachPipetteShell = this.createPipetteShell(monitor);
            this.pipetteShells.add(eachPipetteShell);
            ++n2;
        }
        for (Shell each : this.pipetteShells) {
            each.setVisible(true);
        }
        while (!this.loopExpired) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.disposeAllShells();
        return this.result;
    }

    private Shell createPipetteShell(Monitor monitor) {
        Display display = Display.getCurrent();
        Rectangle monitorArea = monitor.getBounds();
        final Image image = new Image((Device)display, monitorArea.width, monitorArea.height);
        GC gc = new GC((Drawable)display);
        gc.copyArea(image, monitorArea.x, monitorArea.y);
        gc.dispose();
        final Shell shell = new Shell(this.parentShell, 536887304);
        shell.setBounds(monitorArea);
        shell.setBackgroundImage(image);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                image.dispose();
            }
        });
        shell.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ImageData imageData = image.getImageData();
                int pixel = imageData.getPixel(event.x, event.y);
                RGB rgb = imageData.palette.getRGB(pixel);
                PipetteTool.this.handleSelection(rgb);
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    PipetteTool.this.cancel();
                }
            }
        });
        shell.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                ImageData imageData = image.getImageData();
                int pixel = imageData.getPixel(event.x, event.y);
                RGB rgb = imageData.palette.getRGB(pixel);
                ImageData cursorData = PipetteTool.this.upmix(new ImageData(this.getClass().getResourceAsStream("pipette.png")));
                int x = 0;
                while (x < ((PipetteTool)PipetteTool.this).pipetteColorMask.width) {
                    int y = 0;
                    while (y < ((PipetteTool)PipetteTool.this).pipetteColorMask.height) {
                        boolean override;
                        boolean bl = override = PipetteTool.this.pipetteColorMask.getAlpha(x, y) != 0;
                        if (override) {
                            cursorData.setPixel(x, y, cursorData.palette.getPixel(rgb));
                        }
                        ++y;
                    }
                    ++x;
                }
                if (shell.getCursor() != null) {
                    shell.getCursor().dispose();
                }
                Cursor newCursor = new Cursor((Device)shell.getDisplay(), cursorData, 1, 14);
                shell.setCursor(newCursor);
                shell.redraw(event.x - 100, event.y - 100, 200, 200, false);
            }
        });
        return shell;
    }

    private ImageData upmix(ImageData imageData) {
        if (imageData.palette.redMask == 0xFF0000 && imageData.palette.greenMask == 65280) {
            return imageData;
        }
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData result = new ImageData(imageData.width, imageData.height, 32, paletteData);
        int x = 0;
        while (x < imageData.width) {
            int y = 0;
            while (y < imageData.height) {
                RGB rgb = imageData.palette.getRGB(imageData.getPixel(x, y));
                result.setPixel(x, y, paletteData.getPixel(rgb));
                result.setAlpha(x, y, imageData.getAlpha(x, y));
                ++y;
            }
            ++x;
        }
        return result;
    }

    protected void cancel() {
        this.loopExpired = true;
    }

    private void disposeAllShells() {
        for (Shell each : this.pipetteShells) {
            if (each.isDisposed()) continue;
            if (each.getCursor() != null) {
                each.getCursor().dispose();
            }
            each.dispose();
        }
    }

    protected void handleSelection(RGB rgb) {
        this.result = new HSB(rgb);
        this.loopExpired = true;
    }

    public static void main(String[] args) {
        Display.getDefault();
        HSB result = new PipetteTool(null).open();
        System.out.println(result);
    }
}

