/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class HueScale
extends Canvas {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_HOVER = 1;
    private static final int STATE_DRAGGING = 2;
    private Image hueImage;
    private float selection;
    private int state;
    private float saturation = 1.0f;
    private float brightness = 1.0f;

    private static Rectangle expand(Rectangle original, int dx, int dy) {
        return new Rectangle(original.x - dx, original.y - dy, original.width + dx * 2, original.height + dy * 2);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        HueScale hueScale = new HueScale((Composite)shell, 0);
        hueScale.setSelection(180.0f);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public HueScale(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.onPaint(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.onMouseMove(event);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.onMouseDown(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.onMouseUp(event);
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.redraw();
            }
        });
        this.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                HueScale.this.redraw();
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(150, 30);
    }

    private void drawGradient(GC gc) {
        Rectangle gradientArea = this.getGradientArea();
        gc.drawImage(this.getHueImage(), 0, 0, 360, 1, gradientArea.x, gradientArea.y, gradientArea.width, gradientArea.height);
        gc.setForeground(this.getDisplay().getSystemColor(2));
        gc.setAlpha(127);
        gc.drawLine(gradientArea.x, gradientArea.y, gradientArea.x + gradientArea.width, gradientArea.y);
        gc.drawLine(gradientArea.x, gradientArea.y, gradientArea.x, gradientArea.y + gradientArea.height);
        gc.setForeground(this.getDisplay().getSystemColor(1));
        gc.drawLine(gradientArea.x, gradientArea.y + gradientArea.height, gradientArea.x + gradientArea.width, gradientArea.y + gradientArea.height);
        gc.drawLine(gradientArea.x + gradientArea.width, gradientArea.y + gradientArea.height, gradientArea.x + gradientArea.width, gradientArea.y);
    }

    private void drawSelection(GC gc) {
        gc.setAlpha(255);
        Rectangle selectionBox = this.getSelctionArea();
        Rectangle outline = HueScale.expand(selectionBox, 4, 4);
        if (this.isEnabled()) {
            gc.setForeground(this.getDisplay().getSystemColor(23));
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(15));
        }
        if (this.state == 0) {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(26));
        }
        gc.fillRoundRectangle(outline.x, outline.y, outline.width, outline.height, 5, 5);
        gc.drawRoundRectangle(outline.x, outline.y, outline.width, outline.height, 5, 5);
        Color color = new Color((Device)this.getDisplay(), new RGB(this.selection, this.saturation, this.brightness));
        gc.setBackground(color);
        gc.fillRectangle(selectionBox);
        gc.drawRectangle(selectionBox);
        color.dispose();
    }

    public float getBrightness() {
        return this.brightness;
    }

    private Rectangle getGradientArea() {
        int horizontalMargin = 10;
        int gradientHeight = 10;
        Rectangle clientArea = this.getClientArea();
        Rectangle gradientArea = this.getClientArea();
        gradientArea.height = gradientHeight;
        gradientArea.y = (clientArea.height - gradientArea.height) / 2;
        gradientArea.width -= horizontalMargin * 2;
        gradientArea.x = (clientArea.width - gradientArea.width) / 2;
        return gradientArea;
    }

    public Image getHueImage() {
        if (this.hueImage == null) {
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            ImageData data = new ImageData(360, 1, 32, palette);
            int x = 0;
            while (x < 360) {
                data.setPixel(x, 0, palette.getPixel(new RGB((float)x, this.saturation, this.brightness)));
                ++x;
            }
            this.hueImage = new Image((Device)this.getDisplay(), data);
            this.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    HueScale.this.hueImage.dispose();
                }
            });
        }
        return this.hueImage;
    }

    public float getSaturation() {
        return this.saturation;
    }

    private Rectangle getSelctionArea() {
        Rectangle gradientArea = this.getGradientArea();
        int selectionOffset = (int)((float)gradientArea.width / 360.0f * this.selection + (float)gradientArea.x);
        Rectangle selectionBox = new Rectangle(selectionOffset - 5, gradientArea.y - 5, 10, gradientArea.height + 10);
        return selectionBox;
    }

    public float getSelection() {
        return this.selection;
    }

    protected void onMouseDown(Event event) {
        this.setFocus();
        switch (this.state) {
            case 1: {
                this.setState(2);
                break;
            }
            default: {
                int offset = event.x - this.getGradientArea().x;
                float newSelection = (float)offset / (float)this.getGradientArea().width * 360.0f;
                newSelection = Math.min(Math.max(0.0f, newSelection), 360.0f);
                this.setSelection(newSelection);
                this.setState(2);
            }
        }
    }

    protected void onMouseMove(Event event) {
        switch (this.state) {
            case 0: {
                if (!this.getSelctionArea().contains(event.x, event.y)) break;
                this.setState(1);
                break;
            }
            case 1: {
                if (this.getSelctionArea().contains(event.x, event.y)) break;
                this.setState(0);
                break;
            }
            case 2: {
                int offset = event.x - this.getGradientArea().x;
                float newSelection = (float)offset / (float)this.getGradientArea().width * 360.0f;
                newSelection = Math.min(Math.max(0.0f, newSelection), 360.0f);
                this.setSelection(newSelection);
            }
        }
    }

    protected void onMouseUp(Event event) {
        switch (this.state) {
            case 2: {
                if (this.getSelctionArea().contains(event.x, event.y)) {
                    this.setState(1);
                    break;
                }
                this.setState(0);
                break;
            }
            default: {
                this.setState(0);
            }
        }
    }

    protected void onPaint(Event event) {
        GC gc = event.gc;
        gc.setAntialias(1);
        this.drawGradient(gc);
        this.drawSelection(gc);
    }

    public void setBrightness(float brightness) {
        if (brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (this.brightness == brightness) {
            return;
        }
        this.brightness = brightness;
        this.invalidateHueImage();
        this.redraw();
    }

    private void invalidateHueImage() {
        if (this.hueImage != null && !this.hueImage.isDisposed()) {
            this.hueImage.dispose();
        }
        this.hueImage = null;
    }

    public void setSaturation(float saturation) {
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException();
        }
        if (this.saturation == saturation) {
            return;
        }
        this.saturation = saturation;
        this.invalidateHueImage();
        this.redraw();
    }

    public void setSelection(float selection) {
        if (this.selection == selection) {
            return;
        }
        this.selection = selection;
        this.redraw();
        Event event = new Event();
        event.widget = this;
        event.display = this.getDisplay();
        this.notifyListeners(13, event);
    }

    private void setState(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.redraw();
    }
}

