/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class HueCanvas
extends Canvas {
    private static final int STATE_NONE = 0;
    private static final int STATE_DRAGGING = 1;
    private Image hueImage;
    private float hue;
    private float saturation = 0.5f;
    private float brightness = 0.5f;
    private int padding = 5;
    private int state = 0;
    private int selectionRadius = 4;
    private Runnable notifySelection = new Runnable(){

        @Override
        public void run() {
            HueCanvas.this.doNotifySelection();
        }
    };

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        HueCanvas canvas = new HueCanvas((Composite)shell, 0);
        canvas.setHue(160.0f);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public HueCanvas(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.handleDispose();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.onPaint(event);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.invalidate();
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.onMouseDown(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.onMouseMove(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.onMouseUp(event);
            }
        });
        Listener repainter = new Listener(){

            public void handleEvent(Event event) {
                HueCanvas.this.redraw();
            }
        };
        this.addListener(15, repainter);
        this.addListener(16, repainter);
        this.setCursor(this.getDisplay().getSystemCursor(2));
    }

    private void computeNewSelection(Event event) {
        Rectangle clientArea = this.getClientArea();
        float newSaturation = this.limit((float)(event.x - clientArea.x) / (float)clientArea.width, 0.0f, 1.0f);
        float newBrightness = this.limit(1.0f - (float)(event.y - clientArea.y) / (float)clientArea.height, 0.0f, 1.0f);
        this.setSaturation(newSaturation);
        this.setBrightness(newBrightness);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(200, 200);
    }

    private void doNotifySelection() {
        if (this.isDisposed()) {
            return;
        }
        Event e = new Event();
        e.widget = this;
        this.notifyListeners(13, e);
        this.setData("notify-selection", null);
    }

    public float getBrightness() {
        return this.brightness;
    }

    public Rectangle getClientArea() {
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.padding;
        clientArea.y += this.padding;
        clientArea.width -= this.padding * 2;
        clientArea.height -= this.padding * 2;
        return clientArea;
    }

    public float getHue() {
        return this.hue;
    }

    public Image getHueImage() {
        if (this.hueImage == null || this.hueImage.isDisposed()) {
            Rectangle clientArea = this.getClientArea();
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData(clientArea.width, clientArea.height, 32, palette);
            int x = 0;
            while (x < imageData.width) {
                float sat = (float)x / ((float)imageData.width - 1.0f);
                int y = 0;
                while (y < imageData.height) {
                    float bri = 1.0f - (float)y / ((float)imageData.height - 1.0f);
                    imageData.setPixel(x, y, palette.getPixel(new RGB(this.hue, sat, bri)));
                    ++y;
                }
                ++x;
            }
            this.hueImage = new Image((Device)this.getDisplay(), imageData);
        }
        return this.hueImage;
    }

    public int getPadding() {
        return this.padding;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public HSB getSelection() {
        return new HSB(this.hue, this.saturation, this.brightness);
    }

    private void handleDispose() {
        if (this.hueImage != null && !this.hueImage.isDisposed()) {
            this.hueImage.dispose();
        }
    }

    private void invalidate() {
        if (this.hueImage != null && !this.hueImage.isDisposed()) {
            this.hueImage.dispose();
        }
        this.redraw();
    }

    private float limit(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    private void onMouseDown(Event event) {
        this.setFocus();
        this.computeNewSelection(event);
        if (event.button == 1) {
            this.state = 1;
        }
    }

    private void onMouseMove(Event event) {
        if (this.state == 1) {
            this.computeNewSelection(event);
        }
    }

    private void onMouseUp(Event event) {
        if (event.button == 1) {
            this.state = 0;
        }
    }

    private void onPaint(Event event) {
        Rectangle clientArea = this.getClientArea();
        GC gc = event.gc;
        gc.drawRectangle(clientArea.x - 1, clientArea.y - 1, clientArea.width + 1, clientArea.height + 1);
        gc.drawImage(this.getHueImage(), clientArea.x, clientArea.y);
        int selectionX = (int)((float)clientArea.width * this.saturation + (float)clientArea.x);
        int selectionY = (int)((float)clientArea.height * (1.0f - this.brightness) + (float)clientArea.y);
        RGB rgb = new RGB(this.hue, this.saturation, this.brightness);
        Color selectionColor = new Color((Device)this.getDisplay(), rgb);
        gc.setAntialias(1);
        gc.setBackground(selectionColor);
        gc.fillOval(selectionX - this.selectionRadius, selectionY - this.selectionRadius, this.selectionRadius * 2 + 1, this.selectionRadius * 2 + 1);
        gc.setForeground(this.getDisplay().getSystemColor(1));
        gc.drawOval(selectionX - this.selectionRadius, selectionY - this.selectionRadius, this.selectionRadius * 2, this.selectionRadius * 2);
        gc.setForeground(this.getDisplay().getSystemColor(2));
        gc.drawOval(selectionX - this.selectionRadius - 1, selectionY - this.selectionRadius - 1, this.selectionRadius * 2 + 2, this.selectionRadius * 2 + 2);
        selectionColor.dispose();
        if (this.isFocusControl()) {
            Point size = this.getSize();
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    private void scheduleNotifySelection() {
        if (this.getData("notify-selection") != null) {
            return;
        }
        this.setData("notify-selection", true);
        this.getDisplay().asyncExec(this.notifySelection);
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.invalidate();
        this.scheduleNotifySelection();
    }

    public void setHue(float hue) {
        this.hue = hue;
        this.invalidate();
        this.scheduleNotifySelection();
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.invalidate();
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        this.invalidate();
        this.scheduleNotifySelection();
    }

    public void setSelection(float[] selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(float[] selection, boolean notify) {
        this.hue = selection[0];
        this.saturation = selection[1];
        this.brightness = selection[2];
        this.invalidate();
        if (notify) {
            this.scheduleNotifySelection();
        }
    }
}

