/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui.internal;

import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Function1;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.internal.FloatRange;
import net.jeeeyul.swtend.ui.internal.IntRange;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColorFieldSet {
    private boolean ignoreModify;
    private HSB fSelection = new HSB();
    private Text redField;
    private Text greenField;
    private Text blueField;
    private Text hueField;
    private Text saturationField;
    private Text brightnessField;
    private Text htmlField;
    private Composite control;
    private Procedure1<HSB> selectionHandler;

    public Procedure1<HSB> getSelectionHandler() {
        return this.selectionHandler;
    }

    public void setSelectionHandler(Procedure1<HSB> selectionHandler) {
        this.selectionHandler = selectionHandler;
    }

    public Control getControl() {
        return this.control;
    }

    public ColorFieldSet(Composite parent) {
        this.create(parent);
        this.updateField(null);
    }

    private void create(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        new Label(this.control, 0).setText("Red");
        this.redField = new Text(this.control, 2048);
        this.setValidRange(this.redField, new IntRange(0, 255));
        this.redField.setData("kind", (Object)"rgb");
        new Label(this.control, 0).setText("Green");
        this.greenField = new Text(this.control, 2048);
        this.setValidRange(this.greenField, new IntRange(0, 255));
        this.greenField.setData("kind", (Object)"rgb");
        new Label(this.control, 0).setText("Blue");
        this.blueField = new Text(this.control, 2048);
        this.setValidRange(this.blueField, new IntRange(0, 255));
        this.blueField.setData("kind", (Object)"rgb");
        SWTExtensions.INSTANCE.newHorizontalSeparator(this.control, null);
        new Label(this.control, 0).setText("Hue");
        this.hueField = new Text(this.control, 2048);
        this.setValidRange(this.hueField, new FloatRange(0.0f, 360.0f));
        this.hueField.setData("kind", (Object)"hsb");
        new Label(this.control, 0).setText("Saturation");
        this.saturationField = new Text(this.control, 2048);
        this.setValidRange(this.saturationField, new FloatRange(0.0f, 1.0f));
        this.saturationField.setData("kind", (Object)"hsb");
        new Label(this.control, 0).setText("Brightness");
        this.brightnessField = new Text(this.control, 2048);
        this.setValidRange(this.brightnessField, new FloatRange(0.0f, 1.0f));
        this.brightnessField.setData("kind", (Object)"hsb");
        SWTExtensions.INSTANCE.newHorizontalSeparator(this.control, null);
        new Label(this.control, 0).setText("HTML Code");
        this.htmlField = new Text(this.control, 2048);
        this.htmlField.setData("kind", (Object)"html");
        this.setValidExpression(this.htmlField, "#?[0-9a-fA-F]{0,6}");
        this.htmlField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                ColorFieldSet.this.ignoreModify = true;
                ColorFieldSet.this.updateHTMLField();
                ColorFieldSet.this.ignoreModify = false;
            }
        });
        Control[] controlArray = this.control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control each = controlArray[n2];
            if (each instanceof Text) {
                GridData gridData = new GridData(768);
                gridData.widthHint = 100;
                each.setLayoutData((Object)gridData);
                each.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        ColorFieldSet.this.handleModify(event);
                    }
                });
            }
            ++n2;
        }
    }

    private void updateField(String excludeKind) {
        this.ignoreModify = true;
        if (excludeKind == null || !excludeKind.equals("hsb")) {
            this.hueField.setText(Float.toString(this.fSelection.hue));
            this.saturationField.setText(Float.toString(this.fSelection.saturation));
            this.brightnessField.setText(Float.toString(this.fSelection.brightness));
        }
        if (excludeKind == null || !excludeKind.equals("rgb")) {
            this.redField.setText(Integer.toString(this.fSelection.toRGB().red));
            this.greenField.setText(Integer.toString(this.fSelection.toRGB().green));
            this.blueField.setText(Integer.toString(this.fSelection.toRGB().blue));
        }
        if (excludeKind == null || !excludeKind.equals("html")) {
            this.updateHTMLField();
        }
        this.ignoreModify = false;
    }

    private void updateHTMLField() {
        String code = String.format("#%02x%02x%02x", this.fSelection.toRGB().red, this.fSelection.toRGB().green, this.fSelection.toRGB().blue);
        this.htmlField.setText(code);
    }

    private void handleModify(Event event) {
        if (this.ignoreModify) {
            return;
        }
        Text field = (Text)event.widget;
        String kind = (String)field.getData("kind");
        HSB newHSB = null;
        if (kind.equals("hsb")) {
            newHSB = new HSB(this.floatValue(this.hueField), this.floatValue(this.saturationField), this.floatValue(this.brightnessField));
        } else if (kind.equals("rgb")) {
            newHSB = new HSB(this.intValue(this.redField), this.intValue(this.greenField), this.intValue(this.blueField));
            if (newHSB.saturation == 0.0f) {
                newHSB.hue = this.fSelection.hue;
            }
        } else if (kind.equals("html")) {
            String code = this.htmlField.getText().trim();
            int offset = -1;
            int length = -1;
            Function1<String, Integer> converter = null;
            if (code.matches("#[0-9a-fA-F]{6}")) {
                offset = 1;
                length = 2;
                converter = new Function1<String, Integer>(){

                    @Override
                    public Integer apply(String t) {
                        return Integer.parseInt(t, 16);
                    }
                };
            } else if (code.matches("[0-9a-fA-F]{6}")) {
                offset = 0;
                length = 2;
                converter = new Function1<String, Integer>(){

                    @Override
                    public Integer apply(String t) {
                        return Integer.parseInt(t, 16);
                    }
                };
            } else if (code.matches("#[0-9a-fA-F]{3}")) {
                offset = 1;
                length = 1;
                converter = new Function1<String, Integer>(){

                    @Override
                    public Integer apply(String t) {
                        return Integer.parseInt(String.valueOf(t) + t, 16);
                    }
                };
            } else if (code.matches("[0-9a-fA-F]{3}")) {
                offset = 0;
                length = 1;
                converter = new Function1<String, Integer>(){

                    @Override
                    public Integer apply(String t) {
                        return Integer.parseInt(String.valueOf(t) + t, 16);
                    }
                };
            } else {
                return;
            }
            String redString = code.substring(offset, offset + length);
            String greenString = code.substring(offset + length, offset + length * 2);
            String blueString = code.substring(offset + length * 2, offset + length * 3);
            newHSB = new HSB(converter.apply(redString), converter.apply(greenString), converter.apply(blueString));
            if (newHSB.saturation == 0.0f) {
                newHSB.hue = this.fSelection.hue;
            }
        }
        this.fSelection = newHSB;
        this.updateField(kind);
        this.notifySelection();
    }

    private void notifySelection() {
        if (this.selectionHandler != null) {
            this.selectionHandler.apply(this.fSelection);
        }
    }

    public void setSelection(HSB selection) {
        if (this.fSelection == selection || this.fSelection.equals(selection)) {
            return;
        }
        this.fSelection = selection;
        this.updateField(null);
    }

    private void setValidRange(final Text text, final IntRange range) {
        text.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                if (ColorFieldSet.this.ignoreModify) {
                    return;
                }
                String before = text.getText();
                String after = before.subSequence(0, text.getSelection().x) + event.text + before.substring(text.getSelection().y);
                String evaluate = after.trim();
                if (evaluate.isEmpty()) {
                    evaluate = "";
                }
                if (!evaluate.matches("[0-9]*")) {
                    event.doit = false;
                    return;
                }
                int value = Integer.parseInt(evaluate);
                event.doit = range.min <= value && value <= range.max;
            }
        });
    }

    private void setValidRange(final Text text, final FloatRange range) {
        text.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                float value;
                if (ColorFieldSet.this.ignoreModify) {
                    return;
                }
                String before = text.getText();
                String after = before.subSequence(0, text.getSelection().x) + event.text + before.substring(text.getSelection().y);
                String evaluate = after.trim();
                if (evaluate.isEmpty()) {
                    evaluate = "";
                }
                if (!evaluate.matches("[0-9]*(\\.[0-9]*)?")) {
                    event.doit = false;
                    return;
                }
                if (evaluate.equals(".")) {
                    evaluate = "0";
                }
                event.doit = range.min <= (value = Float.parseFloat(evaluate)) && value <= range.max;
            }
        });
    }

    private void setValidExpression(final Text text, final String regexp) {
        text.addListener(25, new Listener(){

            public void handleEvent(Event event) {
                if (ColorFieldSet.this.ignoreModify) {
                    return;
                }
                String before = text.getText();
                String after = before.subSequence(0, text.getSelection().x) + event.text + before.substring(text.getSelection().y);
                String evaluate = after.trim();
                event.doit = evaluate.matches(regexp);
            }
        });
    }

    private float floatValue(Text text) {
        String eval = text.getText().trim();
        if (eval.isEmpty()) {
            eval = "0";
        }
        if (eval == ".") {
            return 0.0f;
        }
        return Float.parseFloat(eval);
    }

    private int intValue(Text text) {
        String eval = text.getText().trim();
        if (eval.isEmpty()) {
            eval = "0";
        }
        return Integer.parseInt(eval);
    }

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setLayout((Layout)new FillLayout());
        new ColorFieldSet((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
        }
    }
}

