/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.util.HashMap;
import java.util.Map;
import net.jeeeyul.swtend.sam.Function1;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Resource;

public class ResourceRegistry<K, T extends Resource> {
    private Map<K, T> data = new HashMap<K, T>();
    private Function1<K, T> resourceFactory;

    public ResourceRegistry() {
    }

    public ResourceRegistry(Function1<K, T> factory) {
        this.resourceFactory = factory;
    }

    private T create(K key) {
        Assert.isNotNull(this.resourceFactory, (String)"Resource factory was not set.");
        return (T)((Resource)this.resourceFactory.apply(key));
    }

    public void dispose() {
        for (Resource each : this.data.values()) {
            if (each == null || each.isDisposed()) continue;
            each.dispose();
        }
        this.data.clear();
    }

    public T get(K key) {
        Object result = (Resource)this.data.get(key);
        if (result == null || result.isDisposed()) {
            result = this.create(key);
            this.data.put(key, result);
        }
        return (T)result;
    }

    public Function1<K, T> getResourceFactory() {
        return this.resourceFactory;
    }

    public void setResourceFactory(Function1<K, T> resourceFactory) {
        this.resourceFactory = resourceFactory;
    }
}

