/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import net.jeeeyul.swtend.SWTExtensions;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class NinePatch
extends Resource {
    private Rectangle centerArea;
    private Rectangle imageBounds;
    private Image[] patches;
    private boolean isDisposed = false;
    private boolean fShouldRenderCenterArea = true;

    public NinePatch(ImageData source, Rectangle centerArea) {
        this(source, centerArea, true);
    }

    public NinePatch(ImageData source, Rectangle centerArea, boolean renderCenter) {
        this.centerArea = centerArea;
        this.fShouldRenderCenterArea = renderCenter;
        this.imageBounds = new Rectangle(0, 0, source.width, source.height);
        this.buildPatches(source);
    }

    private void buildPatches(ImageData source) {
        ImageData[] patcheDatas = new ImageData[9];
        patcheDatas[0] = new ImageData(this.centerArea.x, this.centerArea.y, source.depth, source.palette);
        this.copy(source, patcheDatas[0], 0, 0);
        patcheDatas[1] = new ImageData(this.centerArea.width, this.centerArea.y, source.depth, source.palette);
        this.copy(source, patcheDatas[1], this.centerArea.x, 0);
        patcheDatas[2] = new ImageData(source.width - this.centerArea.x - this.centerArea.width, this.centerArea.y, source.depth, source.palette);
        this.copy(source, patcheDatas[2], this.centerArea.x + this.centerArea.width, 0);
        patcheDatas[3] = new ImageData(this.centerArea.x, this.centerArea.height, source.depth, source.palette);
        this.copy(source, patcheDatas[3], 0, this.centerArea.y);
        patcheDatas[4] = new ImageData(this.centerArea.width, this.centerArea.height, source.depth, source.palette);
        this.copy(source, patcheDatas[4], this.centerArea.x, this.centerArea.y);
        patcheDatas[5] = new ImageData(source.width - this.centerArea.x - this.centerArea.width, this.centerArea.height, source.depth, source.palette);
        this.copy(source, patcheDatas[5], this.centerArea.x + this.centerArea.width, this.centerArea.y);
        patcheDatas[6] = new ImageData(this.centerArea.x, source.height - this.centerArea.height - this.centerArea.y, source.depth, source.palette);
        this.copy(source, patcheDatas[6], 0, this.centerArea.y + this.centerArea.height);
        patcheDatas[7] = new ImageData(this.centerArea.width, source.height - this.centerArea.height - this.centerArea.y, source.depth, source.palette);
        this.copy(source, patcheDatas[7], this.centerArea.x, this.centerArea.y + this.centerArea.height);
        patcheDatas[8] = new ImageData(source.width - this.centerArea.x - this.centerArea.width, source.height - this.centerArea.y - this.centerArea.height, source.depth, source.palette);
        this.copy(source, patcheDatas[8], this.centerArea.x + this.centerArea.width, this.centerArea.y + this.centerArea.height);
        this.patches = new Image[9];
        int i = 0;
        while (i < this.patches.length) {
            this.patches[i] = new Image((Device)Display.getDefault(), patcheDatas[i]);
            ++i;
        }
    }

    private void copy(ImageData from, ImageData to, int fromX, int fromY) {
        int x = 0;
        while (x < to.width) {
            int y = 0;
            while (y < to.height) {
                int sx = x + fromX;
                int sy = y + fromY;
                int pixel = from.getPixel(sx, sy);
                int alpha = from.getAlpha(sx, sy);
                to.setPixel(x, y, pixel);
                to.setAlpha(x, y, alpha);
                ++y;
            }
            ++x;
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        SWTExtensions.INSTANCE.safeDispose(this.patches);
        super.dispose();
        this.isDisposed = true;
    }

    private int getPatchIndex(int vertical, int horizontal) {
        int index = 0;
        switch (vertical) {
            case 0x1000000: {
                index += 3;
                break;
            }
            case 1024: {
                index += 6;
            }
        }
        switch (horizontal) {
            case 0x1000000: {
                ++index;
                break;
            }
            case 131072: {
                index += 2;
            }
        }
        return index;
    }

    private void drawPart(GC gc, int patchIndex, Rectangle dest) {
        if (this.isPositiveArea(dest)) {
            Rectangle src = this.patches[patchIndex].getBounds();
            gc.drawImage(this.patches[patchIndex], src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
        }
    }

    public void fill(GC gc, Rectangle dest) {
        this.drawPart(gc, this.getPatchIndex(128, 16384), this.getCorner(dest, 128, 16384));
        this.drawPart(gc, this.getPatchIndex(128, 0x1000000), this.getCorner(dest, 128, 0x1000000));
        this.drawPart(gc, this.getPatchIndex(128, 131072), this.getCorner(dest, 128, 131072));
        this.drawPart(gc, this.getPatchIndex(0x1000000, 16384), this.getCorner(dest, 0x1000000, 16384));
        if (this.fShouldRenderCenterArea) {
            this.drawPart(gc, this.getPatchIndex(0x1000000, 0x1000000), this.getCorner(dest, 0x1000000, 0x1000000));
        }
        this.drawPart(gc, this.getPatchIndex(0x1000000, 131072), this.getCorner(dest, 0x1000000, 131072));
        this.drawPart(gc, this.getPatchIndex(1024, 16384), this.getCorner(dest, 1024, 16384));
        this.drawPart(gc, this.getPatchIndex(1024, 0x1000000), this.getCorner(dest, 1024, 0x1000000));
        this.drawPart(gc, this.getPatchIndex(1024, 131072), this.getCorner(dest, 1024, 131072));
    }

    private Rectangle getCorner(Rectangle offset, int vFlag, int hFlag) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        if ((hFlag & 0x4000) != 0) {
            r.x = offset.x;
            r.width = this.centerArea.x;
        } else if ((hFlag & 0x1000000) != 0) {
            r.x = offset.x + this.centerArea.x;
            r.width = offset.width - (this.imageBounds.width - this.centerArea.width);
        } else if ((hFlag & 0x20000) != 0) {
            r.x = offset.x + offset.width - (this.imageBounds.width - this.centerArea.x - this.centerArea.width);
            r.width = this.imageBounds.width - this.centerArea.x - this.centerArea.width;
        }
        if ((vFlag & 0x80) != 0) {
            r.y = offset.y;
            r.height = this.centerArea.y;
        } else if ((vFlag & 0x1000000) != 0) {
            r.y = offset.y + this.centerArea.y;
            r.height = offset.height - this.centerArea.y - (this.imageBounds.height - this.centerArea.y - this.centerArea.height);
        } else if ((vFlag & 0x400) != 0) {
            r.y = offset.y + offset.height - (this.imageBounds.height - this.centerArea.y - this.centerArea.height);
            r.height = this.imageBounds.height - this.centerArea.y - this.centerArea.height;
        }
        return r;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    private boolean isPositiveArea(Rectangle rect) {
        return rect.width > 0 && rect.height > 0;
    }
}

