/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.util.Locale;
import java.util.Scanner;
import net.jeeeyul.swtend.ui.LightWeightResource;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HSB
extends LightWeightResource {
    public static final HSB BLACK = new HSB(Display.getDefault().getSystemColor(2).getRGB());
    public static final HSB BLUE = new HSB(Display.getDefault().getSystemColor(9).getRGB());
    public static final HSB CYAN = new HSB(Display.getDefault().getSystemColor(13).getRGB());
    public static final HSB DARK_BLUE = new HSB(Display.getDefault().getSystemColor(10).getRGB());
    public static final HSB DARK_GRAY = new HSB(Display.getDefault().getSystemColor(16).getRGB());
    public static final HSB DARK_GREEN = new HSB(Display.getDefault().getSystemColor(6).getRGB());
    public static final HSB DARK_MAGENTA = new HSB(Display.getDefault().getSystemColor(12).getRGB());
    public static final HSB DARK_RED = new HSB(Display.getDefault().getSystemColor(4).getRGB());
    public static final HSB DARK_YELLOW = new HSB(Display.getDefault().getSystemColor(8).getRGB());
    public static final HSB GRAY = new HSB(Display.getDefault().getSystemColor(15).getRGB());
    public static final HSB GREEN = new HSB(Display.getDefault().getSystemColor(5).getRGB());
    public static final HSB MAGENTA = new HSB(Display.getDefault().getSystemColor(11).getRGB());
    public static final HSB RED = new HSB(Display.getDefault().getSystemColor(3).getRGB());
    public static final HSB WHITE = new HSB(Display.getDefault().getSystemColor(1).getRGB());
    public static final HSB YELLOW = new HSB(Display.getDefault().getSystemColor(7).getRGB());
    public static final HSB WIDGET_DARK_SHADOW = new HSB(Display.getDefault().getSystemColor(17).getRGB());
    public static final HSB WIDGET_NORMAL_SHADOW = new HSB(Display.getDefault().getSystemColor(18).getRGB());
    public static final HSB WIDGET_LIGHT_SHADOW = new HSB(Display.getDefault().getSystemColor(19).getRGB());
    public static final HSB WIDGET_HIGHLIGHT_SHADOW = new HSB(Display.getDefault().getSystemColor(20).getRGB());
    public static final HSB WIDGET_FOREGROUND = new HSB(Display.getDefault().getSystemColor(21).getRGB());
    public static final HSB WIDGET_BACKGROUND = new HSB(Display.getDefault().getSystemColor(22).getRGB());
    public static final HSB WIDGET_BORDER = new HSB(Display.getDefault().getSystemColor(23).getRGB());
    public static final HSB LIST_FOREGROUND = new HSB(Display.getDefault().getSystemColor(24).getRGB());
    public static final HSB LIST_BACKGROUND = new HSB(Display.getDefault().getSystemColor(25).getRGB());
    public static final HSB LIST_SELECTION = new HSB(Display.getDefault().getSystemColor(26).getRGB());
    public static final HSB LIST_SELECTION_TEXT = new HSB(Display.getDefault().getSystemColor(27).getRGB());
    public static final HSB INFO_FOREGROUND = new HSB(Display.getDefault().getSystemColor(28).getRGB());
    public static final HSB INFO_BACKGROUND = new HSB(Display.getDefault().getSystemColor(29).getRGB());
    public static final HSB TITLE_FOREGROUND = new HSB(Display.getDefault().getSystemColor(30).getRGB());
    public static final HSB TITLE_BACKGROUND = new HSB(Display.getDefault().getSystemColor(31).getRGB());
    public static final HSB TITLE_BACKGROUND_GRADIENT = new HSB(Display.getDefault().getSystemColor(32).getRGB());
    public static final HSB TITLE_INACTIVE_FOREGROUND = new HSB(Display.getDefault().getSystemColor(33).getRGB());
    public static final HSB TITLE_INACTIVE_BACKGROUND = new HSB(Display.getDefault().getSystemColor(34).getRGB());
    public static final HSB TITLE_INACTIVE_BACKGROUND_GRADIENT = new HSB(Display.getDefault().getSystemColor(35).getRGB());
    public float hue;
    public float saturation;
    public float brightness;

    public static HSB deserialize(String literal) {
        HSB result = new HSB();
        Scanner scanner = null;
        try {
            try {
                scanner = new Scanner(literal);
                scanner.useDelimiter("\\s*,\\s*");
                scanner.useLocale(Locale.US);
                result.hue = scanner.nextFloat();
                result.saturation = scanner.nextFloat();
                result.brightness = scanner.nextFloat();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = new HSB(0.0f, 1.0f, 1.0f);
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        HSB hsb = new HSB(0.0f, 1.0f, 1.0f);
        System.out.println(hsb.shiftHue(380.0f));
    }

    public HSB() {
    }

    public HSB(float hue, float saturation, float brightness) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }

    public HSB(float[] hsb) {
        if (hsb == null || hsb.length < 3) {
            throw new IllegalArgumentException();
        }
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public HSB(int red, int green, int blue) {
        this(new RGB(red, green, blue).getHSB());
    }

    public HSB(RGB rgb) {
        this(rgb.getHSB());
    }

    public HSB(String htmlCode) {
        if (htmlCode.startsWith("#")) {
            htmlCode = htmlCode.substring(1);
        }
        RGB rgb = new RGB(0, 0, 0);
        if (htmlCode.matches("[0-9a-fA-F]{6}")) {
            rgb.red = Integer.parseInt(htmlCode.substring(0, 2), 16);
            rgb.green = Integer.parseInt(htmlCode.substring(2, 4), 16);
            rgb.blue = Integer.parseInt(htmlCode.substring(4, 6), 16);
        } else if (htmlCode.matches("[0-9a-fA-F]{3}")) {
            rgb.red = Integer.parseInt(String.valueOf(htmlCode.substring(0, 1)) + htmlCode.substring(0, 1), 16);
            rgb.green = Integer.parseInt(String.valueOf(htmlCode.substring(1, 2)) + htmlCode.substring(1, 2), 16);
            rgb.blue = Integer.parseInt(String.valueOf(htmlCode.substring(2, 3)) + htmlCode.substring(2, 3), 16);
        } else {
            throw new UnsupportedOperationException(String.valueOf(htmlCode) + " is not supported color code.");
        }
        float[] hsb = rgb.getHSB();
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public HSB(int systemColorKey) {
        this(Display.getDefault().getSystemColor(systemColorKey).getRGB());
    }

    public HSB ampBrightness(float amp) {
        return new HSB(this.hue, this.saturation, this.limit(this.brightness * amp, 0.0f, 1.0f));
    }

    public HSB ampSaturation(float amp) {
        return new HSB(this.hue, this.limit(this.saturation * amp, 0.0f, 1.0f), this.brightness);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HSB) {
            HSB other = (HSB)obj;
            return this.hue == other.hue && this.saturation == other.saturation && this.brightness == other.brightness;
        }
        return super.equals(obj);
    }

    public HSB getBrightnessScaled(float amp) {
        return this.getCopy().scaleBrightness(amp);
    }

    @Override
    public HSB getCopy() {
        return new HSB(this.hue, this.saturation, this.brightness);
    }

    public HSB getMixedWith(HSB color, float strength) {
        return this.getCopy().mixWith(color, strength);
    }

    public HSB getSaturationScaled(float amp) {
        return this.getCopy().scaleSaturation(amp);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private float limit(float original, float min, float max) {
        return Math.min(Math.max(original, min), max);
    }

    public HSB mixWith(HSB color, float strength) {
        if (color == null || strength < 0.0f || strength > 1.0f) {
            throw new IllegalArgumentException();
        }
        RGB thisRGB = this.toRGB();
        RGB otherRGB = color.toRGB();
        RGB newRGB = new RGB(0, 0, 0);
        newRGB.red = (int)((float)thisRGB.red * (1.0f - strength) + (float)otherRGB.red * strength);
        newRGB.green = (int)((float)thisRGB.green * (1.0f - strength) + (float)otherRGB.green * strength);
        newRGB.blue = (int)((float)thisRGB.blue * (1.0f - strength) + (float)otherRGB.blue * strength);
        float[] hsb = newRGB.getHSB();
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        return this;
    }

    public HSB shiftHue(float amount) {
        this.hue = (this.hue + amount) % 360.0f;
        while (this.hue < 0.0f) {
            this.hue += 360.0f;
        }
        return this;
    }

    public HSB getHueShifted(float amount) {
        return this.getCopy().shiftHue(amount);
    }

    public HSB rewriteHue(float newHue) {
        return new HSB(newHue, this.saturation, this.brightness);
    }

    public HSB scaleBrightness(float amp) {
        this.brightness = this.limit(this.brightness * amp, 0.0f, 1.0f);
        return this;
    }

    public HSB scaleSaturation(float amp) {
        this.saturation = this.limit(this.saturation * amp, 0.0f, 1.0f);
        return this;
    }

    public String serialize() {
        return String.format(Locale.ENGLISH, "%f, %f, %f", Float.valueOf(this.hue), Float.valueOf(this.saturation), Float.valueOf(this.brightness));
    }

    public float[] toArray() {
        return new float[]{this.hue, this.saturation, this.brightness};
    }

    public String toHTMLCode() {
        RGB rgb = this.toRGB();
        return String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    public RGB toRGB() {
        return new RGB(this.hue, this.saturation, this.brightness);
    }

    public String toString() {
        return "HSB [hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + "]";
    }
}

