/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.awt.Point;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.GradientEdit;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GradientEditItem
extends Item {
    static final Point SIZE = new Point(10, 20);
    private GradientEdit parent;
    int state = 0;
    Rectangle bounds = new Rectangle(0, 0, 20, 20);

    public GradientEditItem(GradientEdit parent) {
        super((Widget)parent, 0);
        this.parent = parent;
        parent.items.add(this);
    }

    public void dispose() {
        this.parent.items.remove((Object)this);
        super.dispose();
    }

    void draw(GC gc) {
        ColorStop colorStop = (ColorStop)this.getData();
        Color color = new Color((Device)this.getDisplay(), colorStop.color.toRGB());
        Path innerOutline = this.createPath(2);
        Path innerFill = this.createFillPath(2);
        Path path = this.createPath(0);
        switch (this.state) {
            case 32: {
                gc.setBackground(this.getDisplay().getSystemColor(26));
                break;
            }
            case 2: 
            case 34: {
                gc.setBackground(this.getDisplay().getSystemColor(26));
                break;
            }
            default: {
                gc.setBackground(this.getDisplay().getSystemColor(1));
            }
        }
        gc.setAlpha(255);
        gc.fillPath(path);
        gc.setAlpha(255);
        gc.setBackground(color);
        gc.fillPath(innerFill);
        gc.setForeground(this.getDisplay().getSystemColor(23));
        gc.setAlpha(255);
        gc.drawPath(path);
        gc.setAlpha(100);
        gc.drawPath(innerOutline);
        path.dispose();
        innerOutline.dispose();
        innerFill.dispose();
        color.dispose();
    }

    protected Path createPath(int inset) {
        Path path = new Path((Device)this.getDisplay());
        Rectangle box = SWTExtensions.INSTANCE.getShrinked(this.bounds, inset);
        path.moveTo((float)box.x, (float)box.y);
        path.lineTo((float)(box.x + box.width), (float)box.y);
        path.lineTo((float)(box.x + box.width), (float)(box.y + box.height - 5));
        path.lineTo((float)(box.x + box.width / 2), (float)(box.y + box.height - inset));
        path.lineTo((float)box.x, (float)(box.y + box.height - 5));
        path.close();
        return path;
    }

    protected Path createFillPath(int inset) {
        Path path = new Path((Device)this.getDisplay());
        Rectangle box = SWTExtensions.INSTANCE.getShrinked(this.bounds, inset, inset, inset - 1, inset - 1);
        path.moveTo((float)box.x, (float)box.y);
        path.lineTo((float)(box.x + box.width), (float)box.y);
        path.lineTo((float)(box.x + box.width), (float)(box.y + box.height - 5));
        path.lineTo((float)(box.x + box.width / 2), (float)(box.y + box.height - (inset + 1)));
        path.lineTo((float)box.x, (float)(box.y + box.height - 5));
        path.close();
        return path;
    }
}

