/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorPicker;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.GradientEditItem;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.internal.HueScale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class GradientEdit
extends Canvas {
    private static Gradient clipboard;
    private Point preferredSize = new Point(100, 25);
    private Gradient selection;
    private boolean itemsInvaldate = false;
    private Point dragBegin = null;
    private boolean lockOrder = false;
    private int state = 0;
    private GradientEditItem selectedItem = null;
    private GradientEditItem hotItem = null;
    private Rectangle dragBeginBounds = null;
    List<GradientEditItem> items = new ArrayList<GradientEditItem>();
    private MenuItem addMenuItem;
    private MenuItem removeMenuItem;
    private Point menuLocation;
    private MenuItem editMenuItem;
    private MenuItem copyMenu;
    private MenuItem pasteMenu;
    private boolean dispatchModifyEventScheduled = false;
    private UIJob editItemJob;

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        new GradientEdit((Composite)shell);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public GradientEdit(Composite parent) {
        super(parent, 0x20000000);
        this.createMenu();
        this.hook();
        Gradient gradient = new Gradient(new HSB(255, 255, 255), new HSB(255, 0, 0));
        gradient.add(1, new ColorStop(new HSB(255, 255, 0), 50));
        this.setSelection(gradient, false);
        this.updateMenuEnabilities();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(Math.max(this.preferredSize.x, wHint), Math.max(this.preferredSize.y, hHint));
    }

    private void createMenu() {
        Menu menu = new Menu((Control)this);
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.menuLocation = GradientEdit.this.toControl(GradientEdit.this.getDisplay().getCursorLocation());
            }
        });
        this.setMenu(menu);
        this.addMenuItem = new MenuItem(menu, 8);
        this.addMenuItem.setText("Add");
        this.addMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.insertNewColorStop(((GradientEdit)GradientEdit.this).menuLocation.x);
            }
        });
        this.removeMenuItem = new MenuItem(menu, 8);
        this.removeMenuItem.setText("Remove");
        this.removeMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.removeSelectedItem();
            }
        });
        new MenuItem(menu, 2);
        this.editMenuItem = new MenuItem(menu, 8);
        this.editMenuItem.setText("Edit...");
        this.editMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.editItem(GradientEdit.this.selectedItem);
            }
        });
        new MenuItem(menu, 2);
        this.copyMenu = new MenuItem(menu, 8);
        this.copyMenu.setText("Copy Gradient");
        this.copyMenu.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                clipboard = GradientEdit.this.selection.getCopy();
            }
        });
        this.pasteMenu = new MenuItem(menu, 8);
        this.pasteMenu.setText("Paste Gradient");
        this.pasteMenu.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.setSelection(clipboard.getCopy(), true);
            }
        });
        menu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.updateMenuEnabilities();
            }
        });
        new MenuItem(menu, 2);
        MenuItem batchMenuItem = new MenuItem(menu, 64);
        batchMenuItem.setText("Batch Tasks");
        Menu batchMenu = new Menu(batchMenuItem);
        batchMenuItem.setMenu(batchMenu);
        MenuItem rewriteHueMenuItem = new MenuItem(batchMenu, 8);
        rewriteHueMenuItem.setText("Rewrite Hue");
        rewriteHueMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.rewriteHue();
            }
        });
        MenuItem shiftHueMenuItem = new MenuItem(batchMenu, 8);
        shiftHueMenuItem.setText("Shift Hue");
        shiftHueMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.shiftHue();
            }
        });
        MenuItem scaleBrightnessMenuItem = new MenuItem(batchMenu, 8);
        scaleBrightnessMenuItem.setText("Amp Brightness");
        scaleBrightnessMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.ampBrightness();
            }
        });
        MenuItem scaleSaturationMenuItem = new MenuItem(batchMenu, 8);
        scaleSaturationMenuItem.setText("Amp Saturation");
        scaleSaturationMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.ampSaturation();
            }
        });
    }

    private void dispathModifyEvent() {
        if (this.dispatchModifyEventScheduled) {
            return;
        }
        this.dispatchModifyEventScheduled = true;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GradientEdit.this.dispatchModifyEventScheduled = false;
                if (GradientEdit.this.isDisposed()) {
                    return;
                }
                GradientEdit.this.notifyListeners(24, new Event());
            }
        });
    }

    private void draw(GC gc) {
        if (this.itemsInvaldate) {
            this.rebuildItems();
        }
        this.drawBar(gc);
        for (GradientEditItem item : this.items) {
            item.draw(gc);
        }
    }

    private void drawBar(GC gc) {
        gc.setAlpha(255);
        Rectangle barArea = this.getBarArea();
        SWTExtensions.INSTANCE.fillGradientRectangle(gc, barArea, this.selection, false);
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawLine(barArea.x, barArea.y, barArea.x + barArea.width, barArea.y);
        gc.drawLine(barArea.x, barArea.y, barArea.x, barArea.y + barArea.height);
        gc.setForeground(this.getDisplay().getSystemColor(20));
        gc.drawLine(barArea.x, barArea.y + barArea.height, barArea.x + barArea.width, barArea.y + barArea.height);
        gc.drawLine(barArea.x + barArea.width, barArea.y, barArea.x + barArea.width, barArea.y + barArea.height);
    }

    protected void editItem(GradientEditItem item) {
        final ColorStop colorStop = (ColorStop)item.getData();
        HSB original = colorStop.color;
        final ColorPicker picker = new ColorPicker(this.getShell());
        picker.setSelection(colorStop.color);
        picker.setContinuosSelectionHandler(new Procedure1<HSB>(){

            @Override
            public void apply(HSB t) {
                colorStop.color = picker.getSelection();
                GradientEdit.this.redraw();
                GradientEdit.this.dispathModifyEvent();
            }
        });
        colorStop.color = picker.open() == 0 ? picker.getSelection() : original;
        this.redraw();
        this.dispathModifyEvent();
    }

    private Rectangle getBarArea() {
        return SWTExtensions.INSTANCE.shrink(this.getClientArea(), 0, 15, 0, 0);
    }

    public Rectangle getClientArea() {
        Point size = this.getSize();
        return SWTExtensions.INSTANCE.shrink(new Rectangle(0, 0, size.x, size.y), GradientEditItem.SIZE.x / 2, 0, GradientEditItem.SIZE.x / 2 + 1, 1);
    }

    private UIJob getEditItemJob() {
        if (this.editItemJob == null) {
            this.editItemJob = new UIJob(this.getDisplay(), "Edit Item"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (GradientEdit.this.isDisposed() || GradientEdit.this.selectedItem == null) {
                        return Status.OK_STATUS;
                    }
                    GradientEdit.this.editItem(GradientEdit.this.selectedItem);
                    return Status.OK_STATUS;
                }
            };
            this.editItemJob.setSystem(true);
            this.editItemJob.setUser(false);
        }
        return this.editItemJob;
    }

    private GradientEditItem getItemAt(Event event) {
        return this.getItemAt(event.x, event.y);
    }

    private GradientEditItem getItemAt(int x, int y) {
        GradientEditItem target = null;
        ArrayList<GradientEditItem> reverseOrder = new ArrayList<GradientEditItem>(this.items);
        Collections.reverse(reverseOrder);
        for (GradientEditItem each : reverseOrder) {
            if (!SWTExtensions.INSTANCE.contains(each.bounds, x, y)) continue;
            target = each;
            break;
        }
        return target;
    }

    private GradientEditItem getItemFor(ColorStop stop) {
        for (GradientEditItem each : this.items) {
            if (each.getData() != stop) continue;
            return each;
        }
        return null;
    }

    public Gradient getSelection() {
        return this.selection;
    }

    private void handleDoubleClick(Event event) {
        GradientEditItem item = this.getItemAt(event);
        if (item != null) {
            this.state = 0;
            this.getEditItemJob().schedule();
        } else {
            this.insertNewColorStop(event.x);
        }
    }

    private void handleMouseDown(Event event) {
        GradientEditItem target = this.getItemAt(event);
        this.setSelectedItem(target);
        if (this.state == 0 && event.button == 1 && target != null) {
            this.dragBegin = new Point(event.x, event.y);
            this.dragBeginBounds = new Rectangle(target.bounds.x, target.bounds.y, target.bounds.width, target.bounds.height);
            this.state = 1;
        }
    }

    private void handleMouseMove(Event event) {
        if (this.state == 1) {
            Point delta = new Point(this.dragBegin.x - event.x, this.dragBegin.y - event.y);
            Rectangle newBounds = SWTExtensions.INSTANCE.getTranslated(this.dragBeginBounds, -delta.x, 0);
            newBounds.x = Math.max(this.getBarArea().x - GradientEditItem.SIZE.x / 2, newBounds.x);
            newBounds.x = Math.min(this.getBarArea().x - GradientEditItem.SIZE.x / 2 + this.getBarArea().width, newBounds.x);
            this.selectedItem.bounds = newBounds;
            ColorStop colorStop = (ColorStop)this.selectedItem.getData();
            colorStop.percent = (int)((double)(newBounds.x - this.getBarArea().x + GradientEditItem.SIZE.x / 2) / (double)this.getBarArea().width * 100.0 + 0.5);
            if (this.lockOrder) {
                int index = this.selection.indexOf(colorStop);
                if (index > 0) {
                    GradientEditItem prevItem = this.getItemFor(this.selection.get(index - 1));
                    ColorStop prevStop = (ColorStop)prevItem.getData();
                    newBounds.x = Math.max(prevItem.bounds.x, newBounds.x);
                    colorStop.percent = Math.max(prevStop.percent, colorStop.percent);
                }
                if (index < this.items.size() - 1) {
                    GradientEditItem nextItem = this.getItemFor(this.selection.get(index + 1));
                    ColorStop nextStop = (ColorStop)nextItem.getData();
                    newBounds.x = Math.min(nextItem.bounds.x, newBounds.x);
                    colorStop.percent = Math.min(nextStop.percent, colorStop.percent);
                }
            }
            if (!this.lockOrder) {
                this.sort();
            }
            this.redraw();
            this.dispathModifyEvent();
        } else if (this.state == 0) {
            GradientEditItem target = this.getItemAt(event);
            this.setHotItem(target);
        }
    }

    private void handleMouseUp(Event event) {
        if (this.state == 1) {
            this.dragBegin = null;
            this.dragBeginBounds = null;
            this.state = 0;
            this.layoutItems();
            this.dispathModifyEvent();
        }
    }

    private void hook() {
        this.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.redraw();
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.redraw();
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\u007f' || event.character == '\b') {
                    GradientEdit.this.removeSelectedItem();
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.draw(event.gc);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.layoutItems();
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.handleMouseDown(event);
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.handleMouseMove(event);
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.handleMouseUp(event);
            }
        });
        this.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                GradientEdit.this.handleDoubleClick(event);
            }
        });
    }

    private void insertNewColorStop(int x) {
        ColorStop each;
        int percent = this.toPercent(x);
        ColorStop from = this.selection.get(0);
        ColorStop to = null;
        int i = 0;
        while (i < this.selection.size()) {
            each = this.selection.get(i);
            if (each.percent > percent) break;
            from = each;
            ++i;
        }
        i = this.selection.size() - 1;
        while (i >= 0) {
            each = this.selection.get(i);
            if (each.percent < percent) break;
            to = each;
            --i;
        }
        int insertIndex = 0;
        if (to != null) {
            insertIndex = this.selection.indexOf(to);
        } else {
            to = this.selection.get(this.selection.size() - 1);
            insertIndex = this.selection.size();
        }
        HSB newHSB = from.color.getCopy();
        ColorStop model = new ColorStop(newHSB.mixWith(to.color, 0.5f), percent);
        this.selection.add(insertIndex, model);
        GradientEditItem newItem = new GradientEditItem(this);
        newItem.setData(model);
        this.setSelectedItem(newItem);
        this.layoutItems();
        this.dispathModifyEvent();
    }

    public boolean isFocusControl() {
        return super.isFocusControl();
    }

    public boolean isLockOrder() {
        return this.lockOrder;
    }

    void layoutItems() {
        for (GradientEditItem each : this.items) {
            ColorStop colorStop = (ColorStop)each.getData();
            Rectangle barArea = this.getBarArea();
            int x = barArea.x + (int)((double)barArea.width * ((double)colorStop.percent / 100.0)) - GradientEditItem.SIZE.x / 2;
            each.bounds = new Rectangle(x, barArea.y - 15, GradientEditItem.SIZE.x, GradientEditItem.SIZE.y);
        }
        this.redraw();
    }

    private void rebuildItems() {
        GradientEditItem[] itemArray;
        GradientEditItem[] gradientEditItemArray = itemArray = this.items.toArray(new GradientEditItem[this.items.size()]);
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GradientEditItem eachItem = gradientEditItemArray[n2];
            eachItem.dispose();
            ++n2;
        }
        if (this.selection != null) {
            for (ColorStop each : this.selection) {
                GradientEditItem newItem = new GradientEditItem(this);
                newItem.setData(each);
            }
        }
        this.layoutItems();
    }

    private void removeSelectedItem() {
        if (this.selectedItem != null && this.items.size() > 2) {
            this.selection.remove(this.selectedItem.getData());
            this.rebuildItems();
            this.dispathModifyEvent();
        }
    }

    public boolean setFocus() {
        return this.forceFocus();
    }

    private void setHotItem(GradientEditItem target) {
        if (target == this.hotItem) {
            return;
        }
        if (this.hotItem != null) {
            this.hotItem.state ^= 0x20;
        }
        this.hotItem = target;
        if (this.hotItem != null) {
            this.hotItem.state |= 0x20;
        }
        this.redraw();
    }

    public void setLockOrder(boolean lockOrder) {
        this.lockOrder = lockOrder;
    }

    private void setSelectedItem(GradientEditItem item) {
        if (this.selectedItem == item) {
            return;
        }
        if (this.selectedItem != null) {
            this.selectedItem.state ^= 2;
        }
        this.selectedItem = item;
        if (this.selectedItem != null) {
            this.selectedItem.state |= 2;
            this.items.remove((Object)this.selectedItem);
            this.items.add(this.selectedItem);
        }
        this.redraw();
    }

    public void setSelection(Gradient selection) {
        this.setSelection(selection, false);
    }

    public void setSelection(Gradient selection, boolean notify) {
        if (this.selection == selection) {
            return;
        }
        this.selection = selection;
        this.rebuildItems();
        if (notify) {
            this.dispathModifyEvent();
        }
    }

    private void sort() {
        Collections.sort(this.selection, new Comparator<ColorStop>(){

            @Override
            public int compare(ColorStop a, ColorStop b) {
                return a.percent - b.percent;
            }
        });
        this.redraw();
    }

    private int toPercent(int x) {
        Rectangle barArea = this.getBarArea();
        int result = (int)((double)(x - barArea.x) / (double)barArea.width * 100.0 + 0.5);
        result = Math.max(result, 0);
        result = Math.min(result, 100);
        return result;
    }

    private void updateMenuEnabilities() {
        this.addMenuItem.setEnabled(this.selectedItem == null);
        this.removeMenuItem.setEnabled(this.selectedItem != null && this.items.size() > 2);
        this.editMenuItem.setEnabled(this.selectedItem != null);
        this.pasteMenu.setEnabled(clipboard != null);
    }

    private void rewriteHue() {
        final Gradient backup = this.getSelection().getCopy();
        final Shell shell = new Shell(this.getShell(), 0);
        shell.setLayout((Layout)new FillLayout());
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        final HueScale hueScale = new HueScale((Composite)shell, 0);
        hueScale.setSelection(this.getSelection().get((int)0).color.hue);
        hueScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                float selection = hueScale.getSelection();
                Gradient gradient = GradientEdit.this.getSelection();
                for (ColorStop each : gradient) {
                    each.color.hue = selection;
                }
                GradientEdit.this.redraw();
                GradientEdit.this.dispathModifyEvent();
            }
        });
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    GradientEdit.this.setSelection(backup, true);
                }
                shell.dispose();
            }
        });
        shell.pack();
        Point location = this.toDisplay(0, this.getSize().y);
        shell.setSize(this.getSize().x, 35);
        shell.setLocation(location);
        shell.open();
    }

    private void shiftHue() {
        final Gradient backup = this.getSelection().getCopy();
        final Shell shell = new Shell(this.getShell(), 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        shell.setLayout((Layout)layout);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        final Scale shiftScale = new Scale((Composite)shell, 0);
        shiftScale.setMinimum(0);
        shiftScale.setMaximum(720);
        shiftScale.setSelection(360);
        shiftScale.setPageIncrement(30);
        shiftScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                float amp = (float)shiftScale.getSelection() - 360.0f;
                Gradient current = GradientEdit.this.getSelection();
                int i = 0;
                while (i < current.size()) {
                    current.get((int)i).color.hue = backup.get((int)i).color.getHueShifted((float)amp).hue;
                    ++i;
                }
                GradientEdit.this.redraw();
                GradientEdit.this.dispathModifyEvent();
            }
        });
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    GradientEdit.this.setSelection(backup, true);
                }
                shell.dispose();
            }
        });
        shell.pack();
        Point location = this.toDisplay(0, this.getSize().y);
        shell.setSize(this.getSize().x, 35);
        shell.setLocation(location);
        shell.open();
    }

    private void ampBrightness() {
        final Gradient backup = this.getSelection().getCopy();
        final Shell shell = new Shell(this.getShell(), 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        shell.setLayout((Layout)layout);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        final Scale brightnessScale = new Scale((Composite)shell, 0);
        brightnessScale.setMinimum(0);
        brightnessScale.setMaximum(200);
        brightnessScale.setSelection(100);
        brightnessScale.setPageIncrement(20);
        brightnessScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                float amp = (float)brightnessScale.getSelection() / 100.0f;
                Gradient current = GradientEdit.this.getSelection();
                int i = 0;
                while (i < current.size()) {
                    current.get((int)i).color.brightness = backup.get((int)i).color.getBrightnessScaled((float)amp).brightness;
                    ++i;
                }
                GradientEdit.this.redraw();
                GradientEdit.this.dispathModifyEvent();
            }
        });
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    GradientEdit.this.setSelection(backup, true);
                }
                shell.dispose();
            }
        });
        shell.pack();
        Point location = this.toDisplay(0, this.getSize().y);
        shell.setSize(this.getSize().x, 35);
        shell.setLocation(location);
        shell.open();
    }

    private void ampSaturation() {
        final Gradient backup = this.getSelection().getCopy();
        final Shell shell = new Shell(this.getShell(), 0);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 5;
        shell.setLayout((Layout)layout);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        final Scale saturationScale = new Scale((Composite)shell, 0);
        saturationScale.setMinimum(0);
        saturationScale.setMaximum(200);
        saturationScale.setSelection(100);
        saturationScale.setPageIncrement(20);
        saturationScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                float amp = (float)saturationScale.getSelection() / 100.0f;
                Gradient current = GradientEdit.this.getSelection();
                int i = 0;
                while (i < current.size()) {
                    current.get((int)i).color.saturation = backup.get((int)i).color.getSaturationScaled((float)amp).saturation;
                    ++i;
                }
                GradientEdit.this.redraw();
                GradientEdit.this.dispathModifyEvent();
            }
        });
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    GradientEdit.this.setSelection(backup, true);
                }
                shell.dispose();
            }
        });
        shell.pack();
        Point location = this.toDisplay(0, this.getSize().y);
        shell.setSize(this.getSize().x, 35);
        shell.setLocation(location);
        shell.open();
    }
}

