/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.LightWeightResource;

public class Gradient
extends LightWeightResource
implements List<ColorStop> {
    ArrayList<ColorStop> data = new ArrayList();

    public Gradient(HSB start, HSB end) {
        this.data.add(new ColorStop(start, 0));
        this.data.add(new ColorStop(end, 100));
    }

    public Gradient() {
    }

    @Override
    public boolean add(ColorStop arg0) {
        return this.data.add(arg0);
    }

    @Override
    public void add(int arg0, ColorStop arg1) {
        this.data.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends ColorStop> arg0) {
        return this.data.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends ColorStop> arg1) {
        return this.data.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.data.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.data.containsAll(arg0);
    }

    public void ensureCapacity(int arg0) {
        this.data.ensureCapacity(arg0);
    }

    @Override
    public boolean equals(Object arg0) {
        return this.data.equals(arg0);
    }

    @Override
    public ColorStop get(int arg0) {
        return this.data.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.data.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<ColorStop> iterator() {
        return this.data.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.data.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<ColorStop> listIterator() {
        return this.data.listIterator();
    }

    @Override
    public ListIterator<ColorStop> listIterator(int arg0) {
        return this.data.listIterator(arg0);
    }

    @Override
    public ColorStop remove(int arg0) {
        return this.data.remove(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.data.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.data.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.data.retainAll(arg0);
    }

    @Override
    public ColorStop set(int arg0, ColorStop arg1) {
        return this.data.set(arg0, arg1);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public List<ColorStop> subList(int arg0, int arg1) {
        return this.data.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.data.toArray(arg0);
    }

    public void trimToSize() {
        this.data.trimToSize();
    }

    public String toSWTCSSString() {
        StringBuffer colorNameBuffer = new StringBuffer();
        StringBuffer percentBuffer = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            ColorStop each = this.get(i);
            if (i == 0) {
                if (each.percent != 0) {
                    colorNameBuffer.append(String.valueOf(each.color.toHTMLCode()) + " " + each.color.toHTMLCode());
                    percentBuffer.append(String.valueOf(Integer.toString(each.percent)) + "%");
                } else {
                    colorNameBuffer.append(each.color.toHTMLCode());
                }
            } else {
                colorNameBuffer.append(each.color.toHTMLCode());
                percentBuffer.append(String.valueOf(Integer.toString(each.percent)) + "%");
            }
            if (i == this.size() - 1 && each.percent != 100) {
                colorNameBuffer.append(" ");
                percentBuffer.append(" ");
                colorNameBuffer.append(each.color.toHTMLCode());
                percentBuffer.append("100%");
            }
            if (i < this.size() - 1) {
                colorNameBuffer.append(" ");
            }
            if (i > 0 && i < this.size() - 1) {
                percentBuffer.append(" ");
            }
            ++i;
        }
        return String.valueOf(colorNameBuffer.toString()) + " " + percentBuffer.toString();
    }

    @Override
    public Gradient getCopy() {
        Gradient result = new Gradient();
        for (ColorStop each : this) {
            result.add(each.getCopy());
        }
        return result;
    }

    public HSB getColorInPosition(int percent) {
        int toIndex;
        percent = Math.min(Math.max(percent, 0), 100);
        if (this.size() == 0) {
            throw new IllegalStateException();
        }
        if (this.size() == 1) {
            return this.get((int)0).color;
        }
        ColorStop from = null;
        ColorStop to = null;
        int i = 0;
        while (i < this.size()) {
            to = this.get(i);
            if (to.percent >= percent) break;
            ++i;
        }
        if (to == null) {
            to = this.get(this.size() - 1);
        }
        ColorStop colorStop = from = (toIndex = this.indexOf(to)) > 0 ? this.get(toIndex - 1) : to;
        if (to.percent < percent) {
            return to.color;
        }
        int delta = to.percent - from.percent;
        if (delta == 0) {
            return to.color;
        }
        float strength = (float)(percent - from.percent) / (float)delta;
        return from.color.getMixedWith(to.color, strength);
    }

    public HSB getAverageColor() {
        return this.getColorInPosition(50);
    }

    public HSB getMiddlePointColor() {
        return this.getColorInPosition(50);
    }
}

