/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import net.jeeeyul.swtend.SWTExtensions;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ColorWell
extends Canvas {
    private static final int NONE = 0;
    private static final int PRESSED = 1;
    private static final int EXIT = 2;
    private HSB selection = new HSB();
    private int state = 0;

    private void setState(int state) {
        if (this.state == state || this.isDisposed()) {
            return;
        }
        this.state = state;
        this.redraw();
    }

    public ColorWell(Composite parent, int style) {
        super(parent, 0x20000000);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ColorWell.this.onPaint(event);
            }
        });
        this.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button == 1) {
                    ColorWell.this.setState(1);
                }
            }
        });
        this.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                if (ColorWell.this.state == 1 || ColorWell.this.state == 2) {
                    Rectangle clientArea = ColorWell.this.getClientArea();
                    if (clientArea.x <= event.x && event.x <= clientArea.x + clientArea.width && clientArea.y <= event.y && event.y <= clientArea.y + clientArea.height) {
                        ColorWell.this.setState(1);
                    } else {
                        ColorWell.this.setState(2);
                    }
                }
            }
        });
        this.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                if (ColorWell.this.state == 1) {
                    ColorWell.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ColorWell.this.isDisposed()) {
                                return;
                            }
                            ColorWell.this.notifyListeners(13, new Event());
                        }
                    });
                }
                if (event.button == 1) {
                    ColorWell.this.setState(0);
                }
            }
        });
    }

    public HSB getSelection() {
        return this.selection;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(30, 20);
    }

    protected void onPaint(Event event) {
        if (this.selection == null) {
            return;
        }
        Color color = new Color((Device)this.getDisplay(), this.selection.toRGB());
        event.gc.setBackground(color);
        Rectangle clientArea = this.getClientArea();
        Rectangle shape = SWTExtensions.INSTANCE.getShrinked(clientArea, 2);
        event.gc.fillRoundRectangle(shape.x, shape.y, shape.width, shape.height, 5, 5);
        color.dispose();
        if (this.state == 1) {
            event.gc.setForeground(this.getDisplay().getSystemColor(26));
            event.gc.setAlpha(100);
            event.gc.setLineWidth(3);
            SWTExtensions.INSTANCE.drawRoundRectangle(event.gc, SWTExtensions.INSTANCE.getResized(shape, -1, -1), 5);
        }
        event.gc.setAlpha(60);
        event.gc.setForeground(this.getDisplay().getSystemColor(2));
        SWTExtensions.INSTANCE.drawRoundRectangle(event.gc, SWTExtensions.INSTANCE.getResized(shape, -1, -1), 5);
    }

    public void setSelection(HSB selection, boolean notify) {
        if (selection == null) {
            throw new IllegalArgumentException();
        }
        if (this.selection == selection || this.selection.equals(selection)) {
            return;
        }
        this.selection = selection;
        this.redraw();
        if (notify) {
            Event event = new Event();
            event.widget = this;
            this.notifyListeners(24, event);
        }
    }

    public void setSelection(HSB selection) {
        this.setSelection(selection, true);
    }
}

