/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.ui;

import java.util.ArrayList;
import java.util.List;
import net.jeeeyul.swtend.internal.CollectionContentProvider;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorWell;
import net.jeeeyul.swtend.ui.HSB;
import net.jeeeyul.swtend.ui.internal.ColorFieldSet;
import net.jeeeyul.swtend.ui.internal.HueCanvas;
import net.jeeeyul.swtend.ui.internal.HueScale;
import net.jeeeyul.swtend.ui.internal.Palette;
import net.jeeeyul.swtend.ui.internal.PipetteTool;
import net.jeeeyul.swtend.ui.internal.SystemColor;
import net.jeeeyul.swtend.ui.internal.SystemColorLabelProvider;
import net.jeeeyul.swtend.ui.internal.UserHomePalette;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ColorPicker
extends Dialog {
    private static final int RECENT_MAX_SIZE = 100;
    private HueCanvas hueCanvas;
    private HueScale hueScale;
    private HSB selection = new HSB(0.0f, 0.0f, 0.0f);
    private boolean lockHue;
    private ColorWell colorWell;
    private Procedure1<HSB> continuosSelectionHandler;
    private ColorFieldSet fieldSet;
    private ToolItem pipette;
    private TabFolder tabFolder;
    private Palette recentPalette;
    private Image pipetteImage;

    public static void main(String[] args) {
        ColorPicker picker = new ColorPicker(null);
        picker.setSelection(new HSB(255, 0, 0));
        picker.open();
    }

    public ColorPicker() {
        this(Display.getDefault().getActiveShell());
    }

    public ColorPicker(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(65632);
    }

    protected Control createButtonBar(Composite parent) {
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        return super.createButtonBar(parent);
    }

    private void createChooseTab() {
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        container.setLayout((Layout)mainLayout);
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText("Choose");
        item.setControl((Control)container);
        Composite left = new Composite(container, 0);
        left.setLayout((Layout)new GridLayout());
        this.hueCanvas = new HueCanvas(left, 0);
        this.hueCanvas.setPadding(6);
        this.hueCanvas.setLayoutData(new GridData(768));
        this.hueCanvas.setLayoutData(new GridData(1808));
        this.hueCanvas.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorPicker.this.handleNewSelection();
            }
        });
        this.fieldSet = new ColorFieldSet(container);
        this.fieldSet.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fieldSet.setSelectionHandler(new Procedure1<HSB>(){

            @Override
            public void apply(HSB hsb) {
                ColorPicker.this.setSelection(hsb);
            }
        });
        new Label(container, 258).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite bottom = new Composite(container, 0);
        bottom.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        GridLayout bottomLayout = new GridLayout(3, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 15;
        bottom.setLayout((Layout)bottomLayout);
        this.colorWell = new ColorWell(bottom, 2048);
        ToolBar toolBar = new ToolBar(bottom, 0x800000);
        this.pipette = new ToolItem(toolBar, 8);
        this.pipette.setImage(this.getPipetteImage());
        this.pipette.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ColorPicker.this.isLockHue()) {
                    ColorPicker.this.openPipetteMode();
                }
            }
        });
        this.hueScale = new HueScale(bottom, 0);
        this.hueScale.setLayoutData(new GridData(768));
        this.hueScale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorPicker.this.hueCanvas.setHue(ColorPicker.this.hueScale.getSelection());
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(container, 0);
        this.createChooseTab();
        this.createRecentTab();
        this.createSystemColorsTab();
        this.getShell().setText("Color Picker");
        this.getShell().setImage(this.getPipetteImage());
        this.update();
        this.hueCanvas.setFocus();
        return container;
    }

    private void createSystemColorsTab() {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        TableViewer viewer = new TableViewer(composite, 2048);
        TabItem tabItem = new TabItem(this.tabFolder, 512);
        tabItem.setText("System");
        tabItem.setControl((Control)composite);
        viewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SystemColorLabelProvider());
        viewer.setInput(SystemColor.getSystemColors());
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 100;
        viewer.getControl().setLayoutData((Object)layoutData);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SystemColor selection = (SystemColor)((IStructuredSelection)event.getSelection()).getFirstElement();
                ColorPicker.this.setSelection(new HSB(selection.key));
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ColorPicker.this.okPressed();
            }
        });
    }

    private void createRecentTab() {
        Composite container = new Composite((Composite)this.tabFolder, 0);
        container.setLayout((Layout)new GridLayout(10, true));
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Recent");
        tabItem.setControl((Control)container);
        Listener wellListener = new Listener(){

            public void handleEvent(Event event) {
                HSB hsb = (HSB)event.widget.getData();
                ColorPicker.this.setSelection(hsb);
                ColorPicker.this.okPressed();
            }
        };
        for (HSB each : this.getRecentPalette().getColors()) {
            ColorWell well = new ColorWell(container, 0);
            well.setSelection(each);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            well.setLayoutData(gridData);
            well.setData(each);
            well.addListener(13, wellListener);
        }
    }

    public Procedure1<HSB> getContinuosSelectionHandler() {
        return this.continuosSelectionHandler;
    }

    private Image getPipetteImage() {
        if (this.pipetteImage == null || this.pipetteImage.isDisposed()) {
            this.pipetteImage = new Image((Device)Display.getDefault(), new ImageData(((Object)((Object)this)).getClass().getResourceAsStream("internal/pipette.png")));
        }
        return this.pipetteImage;
    }

    public boolean close() {
        if (this.pipetteImage != null && !this.pipetteImage.isDisposed()) {
            this.pipetteImage.dispose();
        }
        return super.close();
    }

    private Palette getRecentPalette() {
        if (this.recentPalette == null) {
            this.recentPalette = new UserHomePalette(".swtend-colorpicker-recent");
        }
        return this.recentPalette;
    }

    public HSB getSelection() {
        return this.selection;
    }

    private void handleNewSelection() {
        this.selection = this.hueCanvas.getSelection();
        this.colorWell.setSelection(this.selection);
        this.fieldSet.setSelection(this.selection);
        if (this.continuosSelectionHandler != null) {
            this.continuosSelectionHandler.apply(this.selection);
        }
    }

    public boolean isLockHue() {
        return this.lockHue;
    }

    protected void okPressed() {
        this.saveRecentColors();
        super.okPressed();
    }

    private void openPipetteMode() {
        HSB result = new PipetteTool(this.getShell()).open();
        if (result != null) {
            this.hueScale.setSelection(result.hue);
        }
        this.hueCanvas.setSelection(result.toArray());
    }

    private void saveRecentColors() {
        List<HSB> recentColors = this.getRecentPalette().getColors();
        if (recentColors.contains(this.selection)) {
            recentColors.remove(this.selection);
        }
        recentColors.add(0, this.selection);
        if (recentColors.size() > 100) {
            ArrayList<HSB> aliveList = new ArrayList<HSB>(recentColors.subList(0, 100));
            recentColors.clear();
            recentColors.addAll(aliveList);
        }
        this.getRecentPalette().save();
    }

    public void setContinuosSelectionHandler(Procedure1<HSB> continuosSelectionHandler) {
        this.continuosSelectionHandler = continuosSelectionHandler;
    }

    public void setLockHue(boolean lockHue) {
        this.lockHue = lockHue;
        this.update();
    }

    public void setSelection(HSB selection) {
        this.selection = selection;
        this.update();
    }

    private void update() {
        if (this.getShell() == null) {
            return;
        }
        this.hueCanvas.setSelection(this.selection.toArray());
        this.hueScale.setSelection(this.selection.hue);
        this.hueScale.setEnabled(!this.lockHue);
        this.pipette.setEnabled(!this.lockHue);
        this.fieldSet.setSelection(this.selection);
    }
}

