/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;

public class StringUtil {
    private static String REG_EXP_CHARS = "+*{}()[].$!|\\";

    public static boolean areSame(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null && str2 != null) {
            return str1.equals(str2);
        }
        return false;
    }

    public static boolean areSameIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null && str2 != null) {
            return str1.equalsIgnoreCase(str2);
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null && str2 != null) {
            return str1.toLowerCase().startsWith(str2.toLowerCase());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String eraseTag(String htmlString) {
        if (htmlString == null) {
            return null;
        }
        result = new StringBuffer();
        reader = new StringReader(htmlString);
        c = 0;
lbl6:
        // 2 sources

        try {
            while ((c = reader.read()) != -1) {
                block5: {
                    if (c != 60) break block5;
                    while (c != 62 && c != -1) {
                        c = reader.read();
                    }
                    ** GOTO lbl6
                }
                result.append((char)c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String getFirstLine(String source) {
        Assert.isNotNull((Object)source);
        BufferedReader reader = new BufferedReader(new StringReader(source));
        try {
            String result = reader.readLine();
            reader.close();
            result = StringUtil.nullToEmpty(result);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getCamelCase(String source, boolean forceHandleFirstCharToCamel, boolean handleNumberToCamel) {
        if (source == null || source.trim().isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        if (forceHandleFirstCharToCamel) {
            source = String.valueOf(Character.toUpperCase(source.charAt(0))) + source.substring(1, source.length());
        }
        int index = 0;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (Character.isUpperCase(ch) || handleNumberToCamel && Character.isDigit(ch)) {
                buffer.append(ch);
            }
            ++index;
        }
        return buffer.toString();
    }

    public static boolean isHTMLString(String string) {
        if (string == null) {
            return false;
        }
        return string.trim().toLowerCase().startsWith("<html");
    }

    public static void main(String[] args) {
        String input = "VARCHAR(20)";
        Pattern pattern = Pattern.compile("VARCHAR\\((.*)\\)|VARCHAR");
        Matcher matcher = pattern.matcher(input);
        matcher.matches();
        System.out.println(matcher.end());
    }

    public static String read(InputStream stream, String encoding) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int len = -1;
        while ((len = stream.read(buf)) != -1) {
            buffer.write(buf, 0, len);
        }
        stream.close();
        buffer.close();
        String result = new String(buffer.toByteArray(), encoding);
        return result;
    }

    public static void write(String content, OutputStream stream, String encoding) throws IOException {
        byte[] data = content.getBytes(encoding);
        int block = 512;
        int i = 0;
        while (i < data.length) {
            int size = Math.min(data.length - i, block);
            stream.write(data, i, size);
            i += block;
        }
    }

    public static String removeEmptyLine(String original) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(original));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            boolean isFirstLine = true;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                if (isFirstLine) {
                    buffer.append(line);
                    isFirstLine = false;
                    continue;
                }
                buffer.append("\r\n" + line);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    public static String toRegExpSafeString(String source) {
        StringReader reader = new StringReader(source);
        StringBuffer result = new StringBuffer();
        try {
            int data = -1;
            while ((data = reader.read()) != -1) {
                char c = (char)data;
                if (REG_EXP_CHARS.indexOf(c) != -1) {
                    result.append('\\');
                }
                result.append(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String wildExpToRegExpSafeString(String source) {
        StringReader reader = new StringReader(source);
        StringBuffer result = new StringBuffer();
        try {
            int data = -1;
            while ((data = reader.read()) != -1) {
                char c = (char)data;
                if (c == '?') {
                    result.append(".");
                    continue;
                }
                if (c == '*') {
                    result.append(".*");
                    continue;
                }
                if (REG_EXP_CHARS.indexOf(c) != -1) {
                    result.append('\\');
                    result.append(c);
                    continue;
                }
                result.append(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static String nullToEmpty(Object value) {
        return StringUtil.ifNull(value, "");
    }

    public static String ifNull(Object value, String nullExpression) {
        return value != null ? value.toString() : nullExpression;
    }

    public static boolean isNullOrBlank(String currentLogicalName) {
        return currentLogicalName == null || currentLogicalName.trim().isEmpty();
    }

    public static String emptyToNull(String value) {
        if (value != null && value.isEmpty()) {
            return null;
        }
        return value;
    }

    public static String camelToPlain(String camelString) {
        Assert.isNotNull((Object)camelString);
        StringBuffer buffer = new StringBuffer();
        Character prev = null;
        int i = 0;
        while (i < camelString.length()) {
            char c = camelString.charAt(i);
            if (prev != null && Character.isLowerCase(prev.charValue()) && Character.isUpperCase(c)) {
                buffer.append(" ");
            } else if (prev == null) {
                c = Character.toUpperCase(c);
            }
            buffer.append(c);
            prev = Character.valueOf(c);
            ++i;
        }
        return buffer.toString();
    }
}

