/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.jeeeyul.swtend.internal.Debug;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class AutoDisposeQueue
extends UIJob {
    private HashSet<Resource> queue = new HashSet();
    private Map<RGB, Color> colorMap = new HashMap<RGB, Color>();

    public AutoDisposeQueue() {
        super(Display.getDefault(), "Auto Dispose Queue");
        this.setSystem(true);
        this.setUser(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Resource r) {
        boolean added = false;
        HashSet<Resource> hashSet = this.queue;
        synchronized (hashSet) {
            added = this.queue.add(r);
        }
        if (added) {
            this.schedule(10L);
        }
    }

    public Color getColor(HSB hsb) {
        return this.getColor(hsb.toRGB());
    }

    public Color getColor(RGB rgb) {
        Color color = this.colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getDisplay(), rgb);
            this.colorMap.put(rgb, color);
            this.add((Resource)color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInUIThread(IProgressMonitor monitor) {
        Resource[] array = null;
        HashSet<Resource> hashSet = this.queue;
        synchronized (hashSet) {
            array = this.queue.toArray(new Resource[this.queue.size()]);
            this.queue.clear();
        }
        this.colorMap.clear();
        if (array != null) {
            Resource[] resourceArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Resource each = resourceArray[n2];
                if (each != null && !each.isDisposed()) {
                    each.dispose();
                }
                ++n2;
            }
        }
        Debug.getInstance().println(MessageFormat.format("{0} resources are disposed.", array.length));
        return Status.OK_STATUS;
    }
}

