/*
 * Decompiled with CFR 0.152.
 */
package net.jeeeyul.swtend;

import java.util.Collection;
import java.util.Iterator;
import net.jeeeyul.swtend.internal.AutoDisposeQueue;
import net.jeeeyul.swtend.internal.WidgetIterator;
import net.jeeeyul.swtend.sam.Procedure1;
import net.jeeeyul.swtend.ui.ColorStop;
import net.jeeeyul.swtend.ui.Gradient;
import net.jeeeyul.swtend.ui.HSB;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public class SWTExtensions {
    private static Integer MENU_BAR_HEIGHT = null;
    private static Integer TOOLBAR_HEIGHT = null;
    public static final SWTExtensions INSTANCE = new SWTExtensions();
    private GC sharedGC;
    private String osName;
    private AutoDisposeQueue autoDisposeQueue;
    public final int CORNER_TOP_LEFT = 1;
    public final int CORNER_TOP_RIGHT = 2;
    public final int CORNER_BOTTOM_LEFT = 4;
    public final int CORNER_BOTTOM_RIGHT = 8;
    public final int CORNER_TOP = 3;
    public final int CORNER_BOTTOM = 12;
    public final int CORNER_LEFT = 5;
    public final int CORNER_RIGHT = 10;
    public final int CORNER_ALL = 15;

    public Path addArc(Path path, Rectangle box, int startAngle, int angle) {
        path.addArc((float)box.x, (float)box.y, (float)box.width, (float)box.height, (float)startAngle, (float)angle);
        return path;
    }

    public Path addRectangle(Path path, Rectangle rectangle) {
        path.addRectangle((float)rectangle.x, (float)rectangle.y, (float)rectangle.width, (float)rectangle.height);
        return path;
    }

    public Path addRoundRectangle(Path path, Rectangle rectangle, int radius) {
        Rectangle box = new Rectangle(0, 0, radius * 2, radius * 2);
        this.relocateTopRightWith(box, rectangle);
        this.moveTo(path, this.getTopRight(rectangle));
        this.addArc(path, box, 0, 90);
        this.relocateTopLeftWith(box, rectangle);
        this.lineTo(path, this.getTop(box));
        this.addArc(path, box, 90, 90);
        this.relocateBottomLeftWith(box, rectangle);
        this.lineTo(path, this.getLeft(box));
        this.addArc(path, box, 180, 90);
        this.relocateBottomRightWith(box, rectangle);
        this.lineTo(path, this.getBottom(box));
        this.addArc(path, box, 270, 90);
        this.lineTo(path, this.translate(this.getTopRight(rectangle), 0, radius));
        return path;
    }

    public Path addString(Path me, String text, Point location, Font font) {
        me.addString(text, (float)location.x, (float)location.y, font);
        return me;
    }

    public void asyncExec(final Procedure1<Void> procedure) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                procedure.apply(null);
            }
        });
    }

    public Listener attachTo(Listener listener, int eventType, Widget ... widgets) {
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget w = widgetArray[n2];
            w.addListener(eventType, listener);
            ++n2;
        }
        return listener;
    }

    public <T extends Resource> T autoDispose(T resource) {
        this.getAutoDisposeQueue().add(resource);
        return resource;
    }

    public <T extends Resource> T[] autoDispose(T ... resources) {
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            T r = TArray[n2];
            this.autoDispose(r);
            ++n2;
        }
        return resources;
    }

    public <T extends Resource> T autoRelease(T resource) {
        this.autoDispose(resource);
        return resource;
    }

    public <T extends Resource> T[] autoRelease(T ... resources) {
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            T r = TArray[n2];
            this.autoDispose(r);
            ++n2;
        }
        return resources;
    }

    public <T extends Widget> T chainDispose(T widget, final Resource ... resources) {
        widget.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource each = resourceArray[n2];
                    SWTExtensions.this.safeDispose(each);
                    ++n2;
                }
            }
        });
        return widget;
    }

    public Color COLOR_BLACK() {
        return this.getDisplay().getSystemColor(2);
    }

    public Color COLOR_BLUE() {
        return this.getDisplay().getSystemColor(9);
    }

    public Color COLOR_CYAN() {
        return this.getDisplay().getSystemColor(13);
    }

    public Color COLOR_DARK_BLUE() {
        return this.getDisplay().getSystemColor(10);
    }

    public Color COLOR_DARK_CYAN() {
        return this.getDisplay().getSystemColor(14);
    }

    public Color COLOR_DARK_GRAY() {
        return this.getDisplay().getSystemColor(16);
    }

    public Color COLOR_DARK_GREEN() {
        return this.getDisplay().getSystemColor(6);
    }

    public Color COLOR_DARK_MARGENTA() {
        return this.getDisplay().getSystemColor(12);
    }

    public Color COLOR_DARK_RED() {
        return this.getDisplay().getSystemColor(4);
    }

    public Color COLOR_DARK_YELLOW() {
        return this.getDisplay().getSystemColor(8);
    }

    public Color COLOR_GRAY() {
        return this.getDisplay().getSystemColor(15);
    }

    public Color COLOR_GREEN() {
        return this.getDisplay().getSystemColor(5);
    }

    public Color COLOR_INFO_BACKGROUND() {
        return this.getDisplay().getSystemColor(29);
    }

    public Color COLOR_INFO_FOREGROUND() {
        return this.getDisplay().getSystemColor(28);
    }

    public Color COLOR_LINK_FOREGROUND() {
        return this.getDisplay().getSystemColor(36);
    }

    public Color COLOR_LIST_BACKGROUND() {
        return this.getDisplay().getSystemColor(25);
    }

    public Color COLOR_LIST_FOREGROUND() {
        return this.getDisplay().getSystemColor(24);
    }

    public Color COLOR_MAGENTA() {
        return this.getDisplay().getSystemColor(11);
    }

    public Color COLOR_RED() {
        return this.getDisplay().getSystemColor(3);
    }

    public Color COLOR_TITLE_BACKGROUND() {
        return this.getDisplay().getSystemColor(31);
    }

    public Color COLOR_TITLE_BACKGROUND_GRADIENT() {
        return this.getDisplay().getSystemColor(32);
    }

    public Color COLOR_TITLE_FOREGROUND() {
        return this.getDisplay().getSystemColor(30);
    }

    public Color COLOR_TITLE_INACTIVE_BACKGROUND() {
        return this.getDisplay().getSystemColor(34);
    }

    public Color COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT() {
        return this.getDisplay().getSystemColor(35);
    }

    public Color COLOR_TITLE_INACTIVE_FOREGROUND() {
        return this.getDisplay().getSystemColor(33);
    }

    public Color COLOR_WHITE() {
        return this.getDisplay().getSystemColor(1);
    }

    public Color COLOR_WIDGET_BACKGROUND() {
        return this.getDisplay().getSystemColor(22);
    }

    public Color COLOR_WIDGET_BORDER() {
        return this.getDisplay().getSystemColor(23);
    }

    public Color COLOR_WIDGET_DARK_SHADOW() {
        return this.getDisplay().getSystemColor(17);
    }

    public Color COLOR_WIDGET_FOREGROUND() {
        return this.getDisplay().getSystemColor(21);
    }

    public Color COLOR_WIDGET_HIGHLIGHT_SHADOW() {
        return this.getDisplay().getSystemColor(20);
    }

    public Color COLOR_WIDGET_LIGHT_SHADOW() {
        return this.getDisplay().getSystemColor(19);
    }

    public Color COLOR_WIDGET_NORMAL_SHADOW() {
        return this.getDisplay().getSystemColor(18);
    }

    public Color COLOR_YELLOW() {
        return this.getDisplay().getSystemColor(7);
    }

    public Point computeTextExtent(String text, Font font) {
        GC gc = this.getSharedGC();
        gc.setFont(font);
        return gc.textExtent(text);
    }

    public Point computeTextExtent(String text, Font font, int flags) {
        GC gc = this.getSharedGC();
        gc.setFont(font);
        return gc.textExtent(text, flags);
    }

    public boolean contains(Point size, Point targetSize) {
        return size.x >= targetSize.x && size.y >= targetSize.y;
    }

    public boolean contains(Rectangle rect, int x, int y) {
        return rect.x <= x && rect.y <= y && x < rect.x + rect.width && y < rect.y + rect.height;
    }

    public boolean contains(Rectangle rect, Point point) {
        return this.contains(rect, point.x, point.y);
    }

    public boolean contains(Rectangle me, Rectangle other) {
        return me.x <= other.x && me.y <= other.y && me.x + me.width >= other.x + other.width && me.y + me.height >= other.y + other.height;
    }

    public Color createColor(HSB hsb) {
        return new Color((Device)this.getDisplay(), hsb.toRGB());
    }

    public Color[] createColors(HSB[] hsb) {
        Color[] result = new Color[hsb.length];
        int i = 0;
        while (i < hsb.length) {
            result[i] = this.createColor(hsb[i]);
            ++i;
        }
        return result;
    }

    public Path cubicTo(Path path, Point c1, Point c2, Point destination) {
        path.cubicTo((float)c1.x, (float)c1.y, (float)c2.x, (float)c2.y, (float)destination.x, (float)destination.y);
        return path;
    }

    public GC draw(GC gc, int[] pointArray) {
        gc.drawPolygon(pointArray);
        return gc;
    }

    public GC draw(GC gc, Path path) {
        gc.drawPath(path);
        return gc;
    }

    public GC draw(GC gc, Point ... polygon) {
        int[] array = this.toIntArray(polygon);
        gc.drawPolygon(array);
        return gc;
    }

    public GC draw(GC gc, Rectangle rectangle) {
        gc.drawRectangle(rectangle);
        return gc;
    }

    public GC drawGradientPath(GC gc, Path path, Color[] colors, int[] percents, boolean vertical) {
        Rectangle oldClip = gc.getClipping();
        float[] fBounds = new float[4];
        path.getBounds(fBounds);
        Rectangle bounds = new Rectangle((int)fBounds[0], (int)fBounds[1], (int)fBounds[2], (int)fBounds[3]);
        bounds = this.expand(bounds, this.getOSPathBoundsFix());
        int offset = vertical ? bounds.y : bounds.x;
        int gradientSize = 0;
        int i = 1;
        while (i < colors.length) {
            Pattern pattern;
            Rectangle clip;
            Color from = colors[i - 1];
            Color to = colors[i];
            gradientSize = vertical ? bounds.y + bounds.height * percents[i - 1] / 100 - offset : bounds.x + bounds.width * percents[i - 1] / 100 - offset;
            if (vertical) {
                clip = new Rectangle(bounds.x, offset, bounds.width, gradientSize);
                if (oldClip != null) {
                    clip = clip.intersection(oldClip);
                }
                gc.setClipping(clip);
                pattern = new Pattern((Device)this.getDisplay(), (float)bounds.x, (float)(offset - 1), (float)bounds.x, (float)(offset + gradientSize), from, to);
                gc.setForegroundPattern(pattern);
                gc.drawPath(path);
                gc.setForegroundPattern(null);
                pattern.dispose();
            } else {
                clip = new Rectangle(offset, bounds.y, gradientSize, bounds.height);
                if (oldClip != null) {
                    clip = clip.intersection(oldClip);
                }
                gc.setClipping(clip);
                pattern = new Pattern((Device)this.getDisplay(), (float)(offset - 1), (float)bounds.y, (float)(offset + gradientSize), (float)bounds.y, from, to);
                gc.setForegroundPattern(pattern);
                gc.drawPath(path);
                gc.setForegroundPattern(null);
                pattern.dispose();
            }
            offset += gradientSize;
            ++i;
        }
        gc.setClipping(oldClip);
        return gc;
    }

    public GC drawGradientPath(GC gc, Path path, Gradient gradient, boolean vertical) {
        ColorStop stop;
        int[] percents;
        Color[] colors;
        int colorOffset = 0;
        int percentOffset = 1;
        if (gradient.get((int)0).percent != 0) {
            colors = new Color[gradient.size() + 1];
            colors[0] = this.newColor(gradient.get((int)0).color);
            percents = new int[gradient.size()];
            colorOffset = 1;
            percentOffset = 0;
        } else {
            colors = new Color[gradient.size()];
            percents = new int[gradient.size() - 1];
        }
        int i = 0;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            colors[i + colorOffset] = this.newColor(stop.color);
            ++i;
        }
        i = percentOffset;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            percents[i - percentOffset] = stop.percent;
            ++i;
        }
        this.drawGradientPath(gc, path, colors, percents, vertical);
        this.safeDispose((Resource)colors);
        return gc;
    }

    public GC drawImage(GC gc, Image image, Point location) {
        gc.drawImage(image, location.x, location.y);
        return gc;
    }

    public void drawImage(GC gc, Image image, Rectangle sourceArea, Rectangle targetArea) {
        gc.drawImage(image, sourceArea.x, sourceArea.y, sourceArea.width, sourceArea.height, targetArea.x, targetArea.y, targetArea.width, targetArea.height);
    }

    public GC drawLine(GC gc, Point ... polygon) {
        int[] array = this.toIntArray(polygon);
        gc.drawPolyline(array);
        return gc;
    }

    public GC drawOval(GC gc, Rectangle rectangle) {
        gc.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return gc;
    }

    public GC drawRoundRectangle(GC gc, Rectangle rectangle, int radius) {
        gc.drawRoundRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height, radius, radius);
        return gc;
    }

    public void drawString(GC gc, String string, Point location) {
        gc.drawString(string, location.x, location.y, true);
    }

    public GC drawTestGrid(GC gc, Rectangle bounds, int gridSize, Color gridColor, int gridAlpha) {
        gc.setForeground(gridColor);
        gc.setLineStyle(1);
        gc.setLineWidth(1);
        gc.setAlpha(gridAlpha);
        int x = bounds.x;
        while (x < bounds.x + bounds.width) {
            gc.drawLine(x, bounds.y, x, bounds.y + bounds.height);
            x += gridSize;
        }
        int y = bounds.y;
        while (y < bounds.y + bounds.height) {
            gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
            y += gridSize;
        }
        return gc;
    }

    public GC drawTestSize(GC gc, Rectangle bounds, int horizontalAlign, int verticalAlign, Color textColor, int textAlpha) {
        gc.setForeground(textColor);
        gc.setAlpha(textAlpha);
        String text = String.valueOf(bounds.width) + "x" + bounds.height;
        Rectangle textArea = this.newRectangle(new Point(0, 0), gc.textExtent(text));
        if ((horizontalAlign & 0x4000) != 0) {
            textArea.x = bounds.x;
        } else if ((horizontalAlign & 0x1000000) != 0) {
            textArea.x = bounds.x + (bounds.width - textArea.width) / 2;
        } else if ((horizontalAlign & 0x20000) != 0) {
            textArea.x = bounds.x + bounds.width - textArea.width;
        }
        if ((verticalAlign & 0x80) != 0) {
            textArea.y = bounds.y;
        } else if ((verticalAlign & 0x1000000) != 0) {
            textArea.y = bounds.y + (bounds.height - textArea.height) / 2;
        } else if ((verticalAlign & 0x400) != 0) {
            textArea.y = bounds.y + bounds.height - textArea.height;
        }
        this.drawString(gc, text, this.getTopLeft(textArea));
        return gc;
    }

    public Rectangle expand(Rectangle rectangle, int amount) {
        return this.expand(rectangle, amount, amount, amount, amount);
    }

    public Rectangle expand(Rectangle rectangle, int horizontal, int vertical) {
        return this.expand(rectangle, horizontal, vertical, horizontal, vertical);
    }

    public Rectangle expand(Rectangle rectangle, int left, int top, int right, int bottom) {
        rectangle.x -= left;
        rectangle.y -= top;
        rectangle.width += left + right;
        rectangle.height += top + bottom;
        return rectangle;
    }

    public Rectangle expand(Rectangle rectangle, Point delta) {
        return this.expand(rectangle, delta.x, delta.y);
    }

    public Rectangle expand(Rectangle rectangle, Rectangle inset) {
        return this.expand(rectangle, inset.x, inset.y, inset.width, inset.height);
    }

    public GC fill(GC gc, int[] pointArray) {
        gc.fillPolygon(pointArray);
        return gc;
    }

    public GC fill(GC gc, Path path) {
        gc.fillPath(path);
        return gc;
    }

    public GC fill(GC gc, Point ... polygon) {
        gc.fillPolygon(this.toIntArray(polygon));
        return gc;
    }

    public GC fill(GC gc, Rectangle rectangle) {
        gc.fillRectangle(rectangle);
        return gc;
    }

    public GridData FILL_BOTH() {
        GridData gridData = new GridData(1808);
        return gridData;
    }

    public GridData FILL_BOTH(Procedure1<? super GridData> initializer) {
        GridData gridData = new GridData(1808);
        if (initializer != null) {
            initializer.apply((GridData)gridData);
        }
        return gridData;
    }

    public GridData FILL_HORIZONTAL() {
        GridData gridData = new GridData(768);
        return gridData;
    }

    public GridData FILL_HORIZONTAL(Procedure1<? super GridData> initializer) {
        GridData gridData = new GridData(768);
        if (initializer != null) {
            initializer.apply((GridData)gridData);
        }
        return gridData;
    }

    public GC fillArc(GC gc, Rectangle arcBox, int startAngle, int angle) {
        gc.fillArc(arcBox.x, arcBox.y, arcBox.width, arcBox.height, startAngle, angle);
        return gc;
    }

    public GC fillGradientRectangle(GC gc, Rectangle bounds, Color[] colors, int[] percents, boolean vertical) {
        if (colors == null || percents == null || this.hasDisposed((Resource[])colors)) {
            throw new IllegalArgumentException();
        }
        if (colors.length - 1 != percents.length) {
            throw new IllegalArgumentException();
        }
        int offset = vertical ? bounds.y : bounds.x;
        int max = vertical ? bounds.y + bounds.height : bounds.x + bounds.width;
        int gradientSize = 0;
        int i = 1;
        while (i < colors.length) {
            Color from = colors[i - 1];
            Color to = colors[i];
            gradientSize = vertical ? bounds.height * percents[i - 1] / 100 - (offset - bounds.y) : bounds.width * percents[i - 1] / 100 - (offset - bounds.x);
            gc.setForeground(from);
            gc.setBackground(to);
            if (vertical) {
                gc.fillGradientRectangle(bounds.x, offset, bounds.width, gradientSize, true);
            } else {
                gc.fillGradientRectangle(offset, bounds.y, gradientSize, bounds.height, false);
            }
            offset += gradientSize;
            ++i;
        }
        if (offset < max) {
            gc.setBackground(colors[colors.length - 1]);
            if (vertical) {
                gc.fillRectangle(bounds.x, offset, bounds.width, max - offset);
            } else {
                gc.fillRectangle(offset, bounds.y, max - offset, bounds.height);
            }
        }
        return gc;
    }

    public GC fillGradientRectangle(GC gc, Rectangle bounds, Gradient gradient, boolean vertical) {
        ColorStop stop;
        int[] percents;
        Color[] colors;
        int colorOffset = 0;
        int percentOffset = 1;
        if (gradient.get((int)0).percent != 0) {
            colors = new Color[gradient.size() + 1];
            colors[0] = this.newColor(gradient.get((int)0).color);
            percents = new int[gradient.size()];
            colorOffset = 1;
            percentOffset = 0;
        } else {
            colors = new Color[gradient.size()];
            percents = new int[gradient.size() - 1];
        }
        int i = 0;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            colors[i + colorOffset] = this.newColor(stop.color);
            ++i;
        }
        i = percentOffset;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            percents[i - percentOffset] = stop.percent;
            ++i;
        }
        this.fillGradientRectangle(gc, bounds, colors, percents, vertical);
        this.safeDispose((Resource)colors);
        return gc;
    }

    public GC fillGradientRoundRectangle(GC gc, Rectangle bounds, int radius, Color[] colors, int[] percents, boolean vertical) {
        return this.fillGradientRoundRectangle(gc, bounds, radius, 15, colors, percents, vertical);
    }

    public GC fillGradientRoundRectangle(GC gc, Rectangle bounds, int radius, Gradient gradient, boolean vertical) {
        return this.fillGradientRoundRectangle(gc, bounds, radius, 15, gradient, vertical);
    }

    public GC fillGradientRoundRectangle(GC gc, Rectangle bounds, int radius, int cornerFlags, Color[] colors, int[] percents, boolean vertical) {
        if (colors == null || percents == null || this.hasDisposed((Resource[])colors)) {
            throw new IllegalArgumentException();
        }
        if (colors.length - 1 != percents.length) {
            throw new IllegalArgumentException();
        }
        Rectangle oldClipping = gc.getClipping();
        int offset = vertical ? bounds.y : bounds.x;
        int max = vertical ? bounds.y + bounds.height : bounds.x + bounds.width;
        int gradientSize = 0;
        int i = 1;
        while (i < colors.length) {
            Color from = colors[i - 1];
            Color to = colors[i];
            gradientSize = vertical ? bounds.height * percents[i - 1] / 100 - (offset - bounds.y) : bounds.width * percents[i - 1] / 100 - (offset - bounds.x);
            gc.setForeground(from);
            gc.setBackground(to);
            Pattern pattern = null;
            Rectangle area = null;
            if (vertical) {
                area = new Rectangle(bounds.x, offset, bounds.width, gradientSize);
                pattern = this.newGradient(this.getTop(area), this.getBottom(area), from, to);
            } else {
                area = new Rectangle(offset, bounds.y, gradientSize, bounds.height);
                pattern = this.newGradient(this.getLeft(area), this.getRight(area), from, to);
            }
            if (oldClipping != null) {
                area = area.intersection(oldClipping);
            }
            gc.setClipping(area);
            gc.setBackgroundPattern(pattern);
            this.fillRoundRectangle(gc, bounds.x, bounds.y, bounds.width, bounds.height, radius, cornerFlags);
            offset += gradientSize;
            pattern.dispose();
            ++i;
        }
        if (offset < max) {
            Rectangle area = null;
            area = vertical ? new Rectangle(bounds.x, offset, bounds.width, max - offset) : new Rectangle(offset, bounds.y, max - offset, bounds.height);
            if (oldClipping != null) {
                area = area.intersection(oldClipping);
            }
            gc.setClipping(area);
            gc.setBackground(colors[colors.length - 1]);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, radius, radius);
        }
        gc.setClipping(oldClipping);
        return gc;
    }

    public GC fillGradientRoundRectangle(GC gc, Rectangle bounds, int radius, int cornerFlags, Gradient gradient, boolean vertical) {
        ColorStop stop;
        int[] percents;
        Color[] colors;
        int colorOffset = 0;
        int percentOffset = 1;
        if (gradient.get((int)0).percent != 0) {
            colors = new Color[gradient.size() + 1];
            colors[0] = this.newColor(gradient.get((int)0).color);
            percents = new int[gradient.size()];
            colorOffset = 1;
            percentOffset = 0;
        } else {
            colors = new Color[gradient.size()];
            percents = new int[gradient.size() - 1];
        }
        int i = 0;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            colors[i + colorOffset] = this.newColor(stop.color);
            ++i;
        }
        i = percentOffset;
        while (i < gradient.size()) {
            stop = gradient.get(i);
            percents[i - percentOffset] = stop.percent;
            ++i;
        }
        this.fillGradientRoundRectangle(gc, bounds, radius, cornerFlags, colors, percents, vertical);
        this.safeDispose((Resource)colors);
        return gc;
    }

    public GC fillGradientRoundRectangle(GC gc, Rectangle bounds, int radius, int cornerFlags, HSB[] hsb, int[] percents, boolean vertical) {
        Color[] colors = new Color[hsb.length];
        int i = 0;
        while (i < hsb.length) {
            colors[i] = this.newColor(hsb[i]);
            ++i;
        }
        this.fillGradientRoundRectangle(gc, bounds, radius, cornerFlags, colors, percents, vertical);
        this.safeDispose((Resource)colors);
        return gc;
    }

    public GC fillOval(GC gc, Rectangle rectangle) {
        gc.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return gc;
    }

    public GC fillRoundRectangle(GC gc, int x, int y, int width, int height, int radius, int cornerFlags) {
        return this.fillRoundRectangle(gc, new Rectangle(x, y, width, height), radius, cornerFlags);
    }

    public GC fillRoundRectangle(GC gc, Rectangle rectangle, int radius) {
        this.fillRoundRectangle(gc, rectangle, radius, 15);
        return gc;
    }

    public GC fillRoundRectangle(GC gc, Rectangle rectangle, int radius, int cornerFlags) {
        if (radius == 0) {
            gc.fillRectangle(rectangle);
            return gc;
        }
        Rectangle cornerBox = this.newRectangleWithSize(radius * 2);
        Rectangle topLeft = this.getRelocatedTopLeftWith(cornerBox, rectangle);
        Rectangle topRight = this.getRelocatedTopRightWith(cornerBox, rectangle);
        Rectangle bottomLeft = this.getRelocatedBottomLeftWith(cornerBox, rectangle);
        Rectangle bottomRight = this.getRelocatedBottomRightWith(cornerBox, rectangle);
        if (this.hasFlags(cornerFlags, 1)) {
            this.fillOval(gc, topLeft);
        } else {
            gc.fillRectangle(rectangle.x, rectangle.y, radius, radius);
        }
        if (rectangle.width - radius * 2 > 0) {
            gc.fillRectangle(rectangle.x + radius, rectangle.y, rectangle.width - radius * 2, radius);
        }
        if (this.hasFlags(cornerFlags, 2)) {
            this.fillOval(gc, topRight);
        } else {
            gc.fillRectangle(rectangle.x + rectangle.width - radius, rectangle.y, radius, radius);
        }
        if (rectangle.height - radius * 2 > 0) {
            gc.fillRectangle(rectangle.x, rectangle.y + radius, rectangle.width, rectangle.height - radius * 2);
        }
        if (this.hasFlags(cornerFlags, 4)) {
            this.fillOval(gc, bottomLeft);
        } else {
            gc.fillRectangle(rectangle.x, rectangle.y + rectangle.height - radius, radius, radius);
        }
        if (rectangle.width - radius * 2 > 0) {
            gc.fillRectangle(rectangle.x + radius, rectangle.y + rectangle.height - radius, rectangle.width - radius * 2 + 1, radius);
        }
        if (this.hasFlags(cornerFlags, 8)) {
            this.fillOval(gc, bottomRight);
        } else {
            gc.fillRectangle(rectangle.x + rectangle.width - radius, rectangle.y + rectangle.height - radius, radius, radius);
        }
        return gc;
    }

    public Iterator<? extends Widget> getAllContent(Composite root) {
        return new WidgetIterator((Widget)root, true);
    }

    private AutoDisposeQueue getAutoDisposeQueue() {
        if (this.autoDisposeQueue == null) {
            this.autoDisposeQueue = new AutoDisposeQueue();
        }
        return this.autoDisposeQueue;
    }

    public Point getBottom(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
    }

    public Point getBottomLeft(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y + rectangle.height);
    }

    public Point getBottomRight(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public Rectangle getBounds(Event e) {
        return new Rectangle(e.x, e.y, e.width, e.height);
    }

    public Point getCenter(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public Point getCopy(Point point) {
        return new Point(point.x, point.y);
    }

    public Rectangle getCopy(Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Point getDifference(Point a, Point b) {
        return new Point(b.x - a.x, b.y - a.y);
    }

    public Display getDisplay() {
        Display display = Display.getDefault();
        return display;
    }

    public double getDistanceTo(Point me, Point to) {
        return Math.sqrt(Math.pow(to.x - me.x, 2.0) + Math.pow(to.y - me.y, 2.0));
    }

    public Rectangle getExpanded(Rectangle rectangle, int amount) {
        return this.expand(this.getCopy(rectangle), amount);
    }

    public Rectangle getExpanded(Rectangle rectangle, int horizontal, int vertical) {
        return this.expand(this.getCopy(rectangle), horizontal, vertical);
    }

    public Rectangle getExpanded(Rectangle rectangle, int left, int top, int right, int bottom) {
        return this.expand(this.getCopy(rectangle), left, top, right, bottom);
    }

    public Rectangle getExpanded(Rectangle rectangle, Point delta) {
        return this.expand(this.getCopy(rectangle), delta);
    }

    public Rectangle getExpanded(Rectangle rectangle, Rectangle insets) {
        return this.expand(this.getCopy(rectangle), insets);
    }

    public int getHeight(Point size) {
        return size.y;
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry result = (ImageRegistry)Display.getDefault().getData("imageRegistry");
        if (result == null) {
            result = new ImageRegistry();
            Display.getDefault().setData("imageRegistry", (Object)result);
        }
        return result;
    }

    public Point getLeft(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y + rectangle.height / 2);
    }

    public Point getLocation(Event e) {
        return new Point(e.x, e.y);
    }

    public Point getLocation(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y);
    }

    public int getMenubarHeight() {
        if (MENU_BAR_HEIGHT != null) {
            return MENU_BAR_HEIGHT;
        }
        if (Display.getCurrent() == null) {
            throw new SWTException("Invalid Thread Exception");
        }
        Shell dummy = new Shell();
        Menu menu = new Menu((Decorations)dummy, 2);
        dummy.setMenuBar(menu);
        Rectangle boundsWithMenu = dummy.computeTrim(0, 0, 0, 0);
        dummy.setMenuBar(null);
        Rectangle boundsWithoutMenu = dummy.computeTrim(0, 0, 0, 0);
        dummy.dispose();
        MENU_BAR_HEIGHT = boundsWithMenu.height - boundsWithoutMenu.height;
        return MENU_BAR_HEIGHT;
    }

    public int getMinimumToolBarHeight() {
        if (TOOLBAR_HEIGHT != null) {
            return TOOLBAR_HEIGHT;
        }
        if (Display.getCurrent() == null) {
            throw new SWTException("Invalid Thread Exception");
        }
        Shell dummy = new Shell();
        dummy.setLayout((Layout)new GridLayout());
        ToolBar toolBar = new ToolBar((Composite)dummy, 0x820000);
        ToolItem anItem = new ToolItem(toolBar, 0);
        anItem.setText("test");
        Image anImage = new Image((Device)this.getDisplay(), 16, 16);
        anItem.setImage(anImage);
        dummy.pack();
        TOOLBAR_HEIGHT = toolBar.computeSize((int)-1, (int)-1).y;
        dummy.dispose();
        anImage.dispose();
        return TOOLBAR_HEIGHT;
    }

    public Point getNegated(Point me) {
        return this.negate(this.getCopy(me));
    }

    private String getOS() {
        if (this.osName == null) {
            this.osName = System.getProperty("os.name");
        }
        return this.osName;
    }

    private Rectangle getOSPathBoundsFix() {
        String osName = this.getOS();
        if (osName.startsWith("Windows")) {
            return this.newInsets(0, 0, 3, 2);
        }
        return this.newInsets(0, 0, 1, 1);
    }

    public Rectangle getRelocatedBottomLeftWith(Rectangle me, Point BottomLeft) {
        return this.relocateBottomLeftWith(this.getCopy(me), BottomLeft);
    }

    public Rectangle getRelocatedBottomLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomLeftWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedBottomRightWith(Rectangle me, Point BottomRight) {
        return this.relocateBottomRightWith(this.getCopy(me), BottomRight);
    }

    public Rectangle getRelocatedBottomRightWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomRightWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedBottomTo(Rectangle me, Rectangle offset) {
        return this.relocateBottomWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedBottomWith(Rectangle me, Point Bottom) {
        return this.relocateBottomWith(this.getCopy(me), Bottom);
    }

    public Rectangle getRelocatedBottomWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedCenterWith(Rectangle me, Point Center) {
        return this.relocateCenterWith(this.getCopy(me), Center);
    }

    public Rectangle getRelocatedCenterWith(Rectangle me, Rectangle offset) {
        return this.relocateCenterWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedCetnerWith(Rectangle me, Rectangle offset) {
        return this.relocateCenterWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedLeftWith(Rectangle me, Point Left) {
        return this.relocateLeftWith(this.getCopy(me), Left);
    }

    public Rectangle getRelocatedLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateLeftWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedRightWith(Rectangle me, Point right) {
        return this.relocateRightWith(this.getCopy(me), right);
    }

    public Rectangle getRelocatedRightWith(Rectangle me, Rectangle offset) {
        return this.relocateRightWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedTopLeftWith(Rectangle me, Point topLeft) {
        return this.relocateTopLeftWith(this.getCopy(me), topLeft);
    }

    public Rectangle getRelocatedTopLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateTopLeftWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedTopRightWith(Rectangle me, Point topRight) {
        return this.relocateTopRightWith(this.getCopy(me), topRight);
    }

    public Rectangle getRelocatedTopRightWith(Rectangle me, Rectangle offset) {
        return this.relocateTopRightWith(this.getCopy(me), offset);
    }

    public Rectangle getRelocatedTopWith(Rectangle me, Point topLeft) {
        return this.relocateTopWith(this.getCopy(me), topLeft);
    }

    public Rectangle getRelocatedTopWith(Rectangle me, Rectangle offset) {
        return this.relocateTopWith(this.getCopy(me), offset);
    }

    public Rectangle getResized(Rectangle rectangle, int widthDelta, int heightDelta) {
        return this.resize(this.getCopy(rectangle), widthDelta, heightDelta);
    }

    public Rectangle getResized(Rectangle rectangle, Point sizeDelta) {
        return this.getResized(rectangle, sizeDelta.x, sizeDelta.y);
    }

    public Point getRight(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
    }

    public Point getScaled(Point p, double scale) {
        return this.scale(this.getCopy(p), scale);
    }

    public Rectangle getScaled(Rectangle r, double scale) {
        return this.scale(this.getCopy(r), scale);
    }

    public GC getSharedGC() {
        if (this.sharedGC == null || this.sharedGC.isDisposed()) {
            this.sharedGC = new GC((Drawable)this.getDisplay());
        }
        return this.sharedGC;
    }

    public Rectangle getShrinked(Rectangle rectangle, int amount) {
        return this.shrink(this.getCopy(rectangle), amount);
    }

    public Rectangle getShrinked(Rectangle rectangle, int horizontal, int vertical) {
        return this.shrink(this.getCopy(rectangle), horizontal, vertical);
    }

    public Rectangle getShrinked(Rectangle rectangle, int left, int top, int right, int bottom) {
        return this.shrink(this.getCopy(rectangle), left, top, right, bottom);
    }

    public Rectangle getShrinked(Rectangle rectangle, Point delta) {
        return this.shrink(this.getCopy(rectangle), delta);
    }

    public Rectangle getShrinked(Rectangle rectangle, Rectangle insets) {
        return this.shrink(this.getCopy(rectangle), insets);
    }

    public Point getSize(Event e) {
        return new Point(e.width, e.height);
    }

    public Point getSize(ImageData imageData) {
        return new Point(imageData.width, imageData.height);
    }

    public Point getSize(Rectangle rect) {
        return new Point(rect.width, rect.height);
    }

    public Point getTop(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y);
    }

    public Point getTopLeft(Rectangle rectangle) {
        return new Point(rectangle.x, rectangle.y);
    }

    public Point getTopRight(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width, rectangle.y);
    }

    public Point getTranslated(Point point, int dx, int dy) {
        return this.translate(this.getCopy(point), dx, dy);
    }

    public Point getTranslated(Point point, Point delta) {
        return this.getTranslated(point, delta.x, delta.y);
    }

    public Rectangle getTranslated(Rectangle source, int dx, int dy) {
        return this.translate(this.getCopy(source), dx, dy);
    }

    public Rectangle getTranslated(Rectangle source, Point delta) {
        return this.translate(this.getCopy(source), delta);
    }

    public Point getTransposed(Point me) {
        return new Point(me.y, me.x);
    }

    public Rectangle getTransposed(Rectangle me) {
        return new Rectangle(me.y, me.x, me.height, me.width);
    }

    public Rectangle getUnionized(Rectangle me, int x, int y) {
        return this.union(this.getCopy(me), x, y);
    }

    public Rectangle getUnionized(Rectangle me, int x, int y, int w, int h) {
        return this.union(this.getCopy(me), x, y, w, h);
    }

    public Rectangle getUnionized(Rectangle me, Point point) {
        return this.union(this.getCopy(me), point);
    }

    public Rectangle getUnionized(Rectangle me, Rectangle other) {
        return this.union(this.getCopy(me), other);
    }

    public int getWidth(Point size) {
        return size.x;
    }

    public boolean hasDisposed(Resource ... resources) {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r == null) {
                throw new IllegalArgumentException();
            }
            if (r.isDisposed()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasFlags(int flags, int ... mask) {
        int[] nArray = mask;
        int n = mask.length;
        int n2 = 0;
        while (n2 < n) {
            int each = nArray[n2];
            if ((flags & each) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Image ICON_CANCEL() {
        return this.getDisplay().getSystemImage(256);
    }

    public Image ICON_ERROR() {
        return this.getDisplay().getSystemImage(1);
    }

    public Image ICON_INFORMATION() {
        return this.getDisplay().getSystemImage(2);
    }

    public Image ICON_QUESTION() {
        return this.getDisplay().getSystemImage(4);
    }

    public Image ICON_SEARCH() {
        return this.getDisplay().getSystemImage(512);
    }

    public Image ICON_WARNING() {
        return this.getDisplay().getSystemImage(8);
    }

    public Image ICON_WORKING() {
        return this.getDisplay().getSystemImage(16);
    }

    public <T> T init(T widget, Procedure1<T> initializer) {
        if (initializer != null) {
            initializer.apply(widget);
        }
        return widget;
    }

    public boolean isAlive(Resource r) {
        return r != null && !r.isDisposed();
    }

    public boolean isAlive(Widget w) {
        return w != null && !w.isDisposed();
    }

    public boolean isEmpty(Point point) {
        return point.x == 0 && point.y == 0;
    }

    public Path lineTo(Path path, Point location) {
        path.lineTo((float)location.x, (float)location.y);
        return path;
    }

    public Path moveTo(Path path, Point location) {
        path.moveTo((float)location.x, (float)location.y);
        return path;
    }

    public Point negate(Point point) {
        return new Point(-point.x, -point.y);
    }

    public Button newButton(Composite parent, int style, Procedure1<? super Button> initializer) {
        Button button = new Button(parent, style);
        if (initializer != null) {
            initializer.apply((Button)button);
        }
        return button;
    }

    public Canvas newCanvas(Composite parent, Procedure1<Canvas> initializer) {
        Canvas canvas = new Canvas(parent, 0x20000000);
        if (initializer != null) {
            initializer.apply(canvas);
        }
        return canvas;
    }

    public Button newCheckbox(Composite parent, Procedure1<? super Button> initializer) {
        Button button = new Button(parent, 32);
        if (initializer != null) {
            initializer.apply((Button)button);
        }
        return button;
    }

    public CLabel newCLabel(Composite parent, Procedure1<? super CLabel> initializer) {
        CLabel label = new CLabel(parent, 0);
        if (initializer != null) {
            initializer.apply((CLabel)label);
        }
        return label;
    }

    public Color newColor(HSB hsb) {
        return new Color((Device)this.getDisplay(), hsb.toRGB());
    }

    public Color newColor(RGB rgb) {
        return new Color((Device)this.getDisplay(), rgb);
    }

    public Combo newCombo(Composite parent, int style, Procedure1<? super Combo> initializer) {
        Combo combo = new Combo(parent, style);
        if (initializer != null) {
            initializer.apply((Combo)combo);
        }
        return combo;
    }

    public Composite newComposite(Composite parent, int style, Procedure1<? super Composite> initializer) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Composite)composite);
        }
        return composite;
    }

    public Composite newComposite(Composite parent, Procedure1<? super Composite> initializer) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Composite)composite);
        }
        return composite;
    }

    public Composite newComposite(CTabItem ctabItem, Procedure1<? super Composite> initializer) {
        Composite composite = new Composite((Composite)ctabItem.getParent(), 0);
        composite.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Composite)composite);
        }
        ctabItem.setControl((Control)composite);
        return composite;
    }

    public Composite newComposite(TabItem tabItem, Procedure1<? super Composite> initializer) {
        Composite composite = new Composite((Composite)tabItem.getParent(), 0);
        composite.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Composite)composite);
        }
        tabItem.setControl((Control)composite);
        return composite;
    }

    public CTabFolder newCTabFolder(Composite parent, int style, Procedure1<? super CTabFolder> initializer) {
        CTabFolder tabFolder = new CTabFolder(parent, style);
        if (initializer != null) {
            initializer.apply((CTabFolder)tabFolder);
        }
        return tabFolder;
    }

    public CTabFolder newCTabFolder(Composite parent, Procedure1<? super CTabFolder> initializer) {
        CTabFolder tabFolder = new CTabFolder(parent, 0);
        if (initializer != null) {
            initializer.apply((CTabFolder)tabFolder);
        }
        return tabFolder;
    }

    public CTabItem newCTabItem(CTabFolder tabFolder, Procedure1<? super CTabItem> initializer) {
        CTabItem item = new CTabItem(tabFolder, 0);
        if (initializer != null) {
            initializer.apply((CTabItem)item);
        }
        return item;
    }

    public UIJob newDeferredJob(String name, final Procedure1<Display> procedure) {
        return new UIJob(this.getDisplay(), name){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                procedure.apply(this.getDisplay());
                return Status.OK_STATUS;
            }
        };
    }

    public FillLayout newFillLayout() {
        return new FillLayout();
    }

    public FillLayout newFillLayout(Procedure1<FillLayout> initializer) {
        FillLayout FillLayout2 = new FillLayout();
        if (initializer != null) {
            initializer.apply(FillLayout2);
        }
        return FillLayout2;
    }

    public Font newFont(String fontName, int height) {
        return this.newFont(fontName, height, 0);
    }

    public Font newFont(String fontName, int height, int style) {
        Font font = new Font((Device)this.getDisplay(), fontName, height, style);
        return font;
    }

    public Pattern newGradient(Point from, Point to, Color fromColor, Color toColor) {
        return new Pattern((Device)this.getDisplay(), (float)from.x, (float)from.y, (float)to.x, (float)to.y, fromColor, toColor);
    }

    public Pattern newGradient(Point from, Point to, Color fromColor, int fromAlpha, Color toColor, int toAlpha) {
        return new Pattern((Device)this.getDisplay(), (float)from.x, (float)from.y, (float)to.x, (float)to.y, fromColor, fromAlpha, toColor, toAlpha);
    }

    public GridData newGridData(Procedure1<? super GridData> initializer) {
        GridData gridData = new GridData();
        if (initializer != null) {
            initializer.apply((GridData)gridData);
        }
        return gridData;
    }

    public GridLayout newGridLayout() {
        return new GridLayout();
    }

    public GridLayout newGridLayout(Procedure1<GridLayout> initializer) {
        GridLayout gridLayout = new GridLayout();
        if (initializer != null) {
            initializer.apply(gridLayout);
        }
        return gridLayout;
    }

    public Group newGroup(Composite parent, Procedure1<? super Group> initializer) {
        Group group = new Group(parent, 0);
        if (initializer != null) {
            initializer.apply((Group)group);
        }
        return group;
    }

    public Label newHorizontalSeparator(Composite parent, Procedure1<? super Label> initializer) {
        Layout layout;
        Label separator = new Label(parent, 258);
        if (initializer != null) {
            initializer.apply((Label)separator);
        }
        if ((layout = parent.getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            separator.setLayoutData((Object)new GridData(4, 4, true, false, gridLayout.numColumns, 1));
        }
        return separator;
    }

    public Label newHorizontalSeperator(Composite parent, Procedure1<? super Label> initializer) {
        Label separator = new Label(parent, 258);
        if (initializer != null) {
            initializer.apply((Label)separator);
        }
        return separator;
    }

    public Image newImage(int width, int height) {
        Image image = new Image((Device)this.getDisplay(), width, height);
        return image;
    }

    public Rectangle newInsets(int insets) {
        return new Rectangle(insets, insets, insets, insets);
    }

    public Rectangle newInsets(int left, int top, int right, int bottom) {
        return new Rectangle(left, top, right, bottom);
    }

    public Label newLabel(Composite parent, int style, Procedure1<? super Label> initializer) {
        Label label = new Label(parent, style);
        if (initializer != null) {
            initializer.apply((Label)label);
        }
        return label;
    }

    public Label newLabel(Composite parent, Procedure1<? super Label> initializer) {
        return this.newLabel(parent, 0, initializer);
    }

    public Link newLink(Composite parent, int style, Procedure1<? super Link> initializer) {
        Link link = new Link(parent, style);
        if (initializer != null) {
            initializer.apply((Link)link);
        }
        return link;
    }

    public Link newLink(Composite parent, Procedure1<? super Link> initializer) {
        return this.newLink(parent, 0, initializer);
    }

    public PageBook newPageBook(Composite parent, int style, Procedure1<? super PageBook> initializer) {
        PageBook pageBook = new PageBook(parent, style);
        if (initializer != null) {
            initializer.apply((PageBook)pageBook);
        }
        return pageBook;
    }

    public PageBook newPageBook(Composite parent, Procedure1<? super PageBook> initializer) {
        return this.newPageBook(parent, 0, initializer);
    }

    public Text newPasswordField(Composite parent, Procedure1<? super Text> initializer) {
        Text _text;
        Text label = _text = new Text(parent, 0x400800);
        if (initializer != null) {
            initializer.apply((Text)label);
        }
        return label;
    }

    public Path newPath(Procedure1<Path> initializer) {
        Path path = new Path((Device)this.getDisplay());
        if (initializer != null) {
            initializer.apply(path);
        }
        return path;
    }

    public Button newPushButton(Composite parent, Procedure1<? super Button> initializer) {
        Button button = new Button(parent, 8);
        if (initializer != null) {
            initializer.apply((Button)button);
        }
        return button;
    }

    public Button newRadioButton(Composite parent, Procedure1<? super Button> initializer) {
        Button button = new Button(parent, 16);
        if (initializer != null) {
            initializer.apply((Button)button);
        }
        return button;
    }

    public Text newReadOnlyTextField(Composite parent, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, 2056);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Rectangle newRectangle() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Rectangle newRectangle(Event e) {
        return new Rectangle(e.x, e.y, e.width, e.height);
    }

    public Rectangle newRectangle(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public Rectangle newRectangle(Point location, Point size) {
        return new Rectangle(location.x, location.y, size.x, size.y);
    }

    public Rectangle newRectangleWithSize(int size) {
        return new Rectangle(0, 0, size, size);
    }

    public Rectangle newRectangleWithSize(Point size) {
        return new Rectangle(0, 0, size.x, size.y);
    }

    public TreeItem newRootItem(Tree tree, Procedure1<TreeItem> initializer) {
        TreeItem item = new TreeItem(tree, 0);
        if (initializer != null) {
            initializer.apply(item);
        }
        return item;
    }

    public Scale newScale(Composite parent, int style, Procedure1<? super Scale> initializer) {
        Scale scale = new Scale(parent, style);
        if (initializer != null) {
            initializer.apply((Scale)scale);
        }
        return scale;
    }

    public Scale newScale(Composite parent, Procedure1<? super Scale> initializer) {
        return this.newScale(parent, 0, initializer);
    }

    public Text newSearchField(Composite parent, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, 2176);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Label newSeparator(Composite parent, Procedure1<? super Label> initializer) {
        Layout layout;
        Label separator = new Label(parent, 258);
        if (initializer != null) {
            initializer.apply((Label)separator);
        }
        if ((layout = parent.getLayout()) instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            separator.setLayoutData((Object)new GridData(4, 4, true, false, gridLayout.numColumns, 1));
        }
        return separator;
    }

    public Shell newShell(int style, Procedure1<? super Shell> initializer) {
        Shell shell = new Shell(this.getDisplay(), style);
        shell.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Shell)shell);
        }
        return shell;
    }

    public Shell newShell(Procedure1<? super Shell> initializer) {
        Shell shell = new Shell(this.getDisplay());
        shell.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Shell)shell);
        }
        return shell;
    }

    public Shell newShell(Shell parentShell, int style, Procedure1<? super Shell> initializer) {
        Shell shell = new Shell(parentShell, style);
        shell.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Shell)shell);
        }
        return shell;
    }

    public Shell newShell(Shell parentShell, Procedure1<? super Shell> initializer) {
        Shell shell = new Shell(parentShell);
        shell.setLayout((Layout)new FillLayout());
        if (initializer != null) {
            initializer.apply((Shell)shell);
        }
        return shell;
    }

    public Point newSize(int width, int height) {
        return new Point(width, height);
    }

    public Spinner newSpinner(Composite parent, int style, Procedure1<Spinner> initializer) {
        Spinner spinner = new Spinner(parent, style);
        if (initializer != null) {
            initializer.apply(spinner);
        }
        return spinner;
    }

    public Spinner newSpinner(Composite parent, Procedure1<Spinner> initializer) {
        return this.newSpinner(parent, 2048, initializer);
    }

    public TreeItem newSubItem(TreeItem parent, Procedure1<TreeItem> initializer) {
        TreeItem item = new TreeItem(parent, 0);
        if (initializer != null) {
            initializer.apply(item);
        }
        return item;
    }

    public TabFolder newTabFolder(Composite parent, int style, Procedure1<? super TabFolder> initializer) {
        TabFolder tabFolder = new TabFolder(parent, style);
        if (initializer != null) {
            initializer.apply((TabFolder)tabFolder);
        }
        return tabFolder;
    }

    public TabFolder newTabFolder(Composite parent, Procedure1<? super TabFolder> initializer) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        if (initializer != null) {
            initializer.apply((TabFolder)tabFolder);
        }
        return tabFolder;
    }

    public TabItem newTabItem(TabFolder tabFolder, Procedure1<? super TabItem> initializer) {
        TabItem item = new TabItem(tabFolder, 0);
        if (initializer != null) {
            initializer.apply((TabItem)item);
        }
        return item;
    }

    public Table newTable(Composite parent, Procedure1<Table> initializer) {
        Table table = new Table(parent, 2048);
        if (initializer != null) {
            initializer.apply(table);
        }
        return table;
    }

    public TableItem newTableItem(Table parent, int style, Procedure1<TableItem> initializer) {
        TableItem tableItem = new TableItem(parent, style);
        if (initializer != null) {
            initializer.apply(tableItem);
        }
        return tableItem;
    }

    public TableItem newTableItem(Table parent, Procedure1<TableItem> initializer) {
        return this.newTableItem(parent, 0, initializer);
    }

    public Color newTemporaryColor(HSB hsb) {
        return this.getAutoDisposeQueue().getColor(hsb);
    }

    public Color newTemporaryColor(RGB rgb) {
        return this.getAutoDisposeQueue().getColor(rgb);
    }

    public Font newTemporaryFont(String fontName, int height) {
        return this.autoDispose((Resource)this.newFont(fontName, height));
    }

    public Font newTemporaryFont(String fontName, int height, int style) {
        return this.autoDispose((Resource)this.newFont(fontName, height, style));
    }

    public Pattern newTemporaryGradient(Point from, Point to, Color fromColor, Color toColor) {
        return this.autoDispose((Resource)this.newGradient(from, to, fromColor, toColor));
    }

    public Pattern newTemporaryGradient(Point from, Point to, Color fromColor, int fromAlpha, Color toColor, int toAlpha) {
        return this.autoDispose((Resource)this.newGradient(from, to, fromColor, fromAlpha, toColor, toAlpha));
    }

    public Path newTemporaryPath(Procedure1<Path> initializer) {
        Path result = this.newPath(initializer);
        this.autoDispose((Resource)result);
        return result;
    }

    public Text newText(Composite parent, int style, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, style);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Text newTextArea(Composite parent, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, 2818);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Text newTextField(Composite parent, int style, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, style);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Text newTextField(Composite parent, Procedure1<? super Text> initializer) {
        Text text = new Text(parent, 2048);
        if (initializer != null) {
            initializer.apply((Text)text);
        }
        return text;
    }

    public Thread newThread(final Procedure1<Thread> runnable) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                runnable.apply(Thread.currentThread());
            }
        });
    }

    public ToolBar newToolBar(Composite parent, int style, Procedure1<? super ToolBar> initializer) {
        ToolBar toolBar = new ToolBar(parent, style);
        if (initializer != null) {
            initializer.apply((ToolBar)toolBar);
        }
        return toolBar;
    }

    public ToolBar newToolBar(Composite parent, Procedure1<? super ToolBar> initializer) {
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        if (initializer != null) {
            initializer.apply((ToolBar)toolBar);
        }
        return toolBar;
    }

    public ToolItem newToolItem(ToolBar parent, int style, Procedure1<? super ToolItem> initializer) {
        ToolItem item = new ToolItem(parent, style);
        if (initializer != null) {
            initializer.apply((ToolItem)item);
        }
        return item;
    }

    public ToolItem newToolItem(ToolBar parent, Procedure1<? super ToolItem> initializer) {
        ToolItem item = new ToolItem(parent, 0x800000);
        if (initializer != null) {
            initializer.apply((ToolItem)item);
        }
        return item;
    }

    public Transform newTransform(Procedure1<Transform> initializer) {
        Transform transform = new Transform((Device)this.getDisplay());
        if (initializer != null) {
            initializer.apply(transform);
        }
        return transform;
    }

    public Tree newTree(Composite parent, int style, Procedure1<Tree> initializer) {
        Tree tree = new Tree(parent, style);
        if (initializer != null) {
            initializer.apply(tree);
        }
        return tree;
    }

    public Tree newTree(Composite parent, Procedure1<Tree> initializer) {
        Tree tree = new Tree(parent, 2048);
        if (initializer != null) {
            initializer.apply(tree);
        }
        return tree;
    }

    public TreeColumn newTreeColumn(Tree tree, Procedure1<TreeColumn> initializer) {
        TreeColumn column = new TreeColumn(tree, -1);
        if (initializer != null) {
            initializer.apply(column);
        }
        return column;
    }

    public TreeItem newTreeItem(Tree tree, Procedure1<TreeItem> initializer) {
        TreeItem item = new TreeItem(tree, -1);
        if (initializer != null) {
            initializer.apply(item);
        }
        return item;
    }

    public TreeItem newTreeItem(TreeItem parent, Procedure1<TreeItem> initializer) {
        TreeItem item = new TreeItem(parent, -1);
        if (initializer != null) {
            initializer.apply(item);
        }
        return item;
    }

    public UIJob newUIJob(Procedure1<Void> work) {
        return this.newUIJob("Noname", true, false, work);
    }

    public UIJob newUIJob(String name, boolean system, boolean user, final Procedure1<Void> work) {
        UIJob uiJob = new UIJob(this.getDisplay(), "Unnamed Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                work.apply(null);
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(system);
        uiJob.setUser(user);
        uiJob.setName(name);
        return uiJob;
    }

    public Label newVerticalSeperator(Composite parent, Procedure1<? super Label> initializer) {
        Label label = new Label(parent, 514);
        if (initializer != null) {
            initializer.apply((Label)label);
        }
        return label;
    }

    public <T extends Widget> void onEvent(T widget, int eventType, Listener handler) {
        widget.addListener(eventType, handler);
    }

    public void openAndRunLoop(Shell s) {
        if (s.isDisposed()) {
            return;
        }
        s.open();
        while (!s.isDisposed()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
    }

    public int operator_and(int e1, int e2) {
        return e1 & e2;
    }

    public int operator_or(int e1, int e2) {
        return e1 | e2;
    }

    public Point pointAt(Rectangle bounds, double xRatio, double yRatio) {
        return new Point((int)((double)bounds.x + (double)bounds.width * xRatio), (int)((double)bounds.y + (double)bounds.height * yRatio));
    }

    public Path quadTo(Path path, Point c, Point destination) {
        path.quadTo((float)c.x, (float)c.y, (float)destination.x, (float)destination.y);
        return path;
    }

    public Rectangle relocateBottomLeftWith(Rectangle me, Point bottomLeft) {
        me.x = bottomLeft.x;
        me.y = bottomLeft.y - me.height;
        return me;
    }

    public Rectangle relocateBottomLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomLeftWith(me, this.getBottomLeft(offset));
    }

    public Rectangle relocateBottomRightWith(Rectangle me, Point bottomRight) {
        me.x = bottomRight.x - me.width;
        me.y = bottomRight.y - me.height;
        return me;
    }

    public Rectangle relocateBottomRightWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomRightWith(me, this.getBottomRight(offset));
    }

    public Rectangle relocateBottomWith(Rectangle me, Point bottom) {
        me.x = bottom.x - me.width / 2;
        me.y = bottom.y - me.height;
        return me;
    }

    public Rectangle relocateBottomWith(Rectangle me, Rectangle offset) {
        return this.relocateBottomWith(me, this.getBottom(offset));
    }

    public Rectangle relocateCenterWith(Rectangle me, Point center) {
        me.x = center.x - me.width / 2;
        me.y = center.y - me.height / 2;
        return me;
    }

    public Rectangle relocateCenterWith(Rectangle me, Rectangle other) {
        return this.relocateCenterWith(me, this.getCenter(other));
    }

    public Rectangle relocateLeftWith(Rectangle me, Point left) {
        me.x = left.x;
        me.y = left.y - me.height / 2;
        return me;
    }

    public Rectangle relocateLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateLeftWith(me, this.getLeft(offset));
    }

    public Rectangle relocateRightWith(Rectangle me, Point right) {
        me.x = right.x - me.width;
        me.y = right.y - me.height / 2;
        return me;
    }

    public Rectangle relocateRightWith(Rectangle me, Rectangle offset) {
        return this.relocateRightWith(me, this.getRight(offset));
    }

    public Rectangle relocateTopLeftWith(Rectangle me, Point topLeft) {
        me.x = topLeft.x;
        me.y = topLeft.y;
        return me;
    }

    public Rectangle relocateTopLeftWith(Rectangle me, Rectangle offset) {
        return this.relocateTopLeftWith(me, this.getTopLeft(offset));
    }

    public Rectangle relocateTopRightWith(Rectangle me, Point topRight) {
        me.x = topRight.x - me.width;
        me.y = topRight.y;
        return me;
    }

    public Rectangle relocateTopRightWith(Rectangle me, Rectangle offset) {
        return this.relocateTopRightWith(me, this.getTopRight(offset));
    }

    public Rectangle relocateTopWith(Rectangle me, Point top) {
        me.x = top.x - me.width / 2;
        me.y = top.y;
        return me;
    }

    public Rectangle relocateTopWith(Rectangle me, Rectangle offset) {
        return this.relocateTopWith(me, this.getTop(offset));
    }

    public Rectangle resize(Rectangle rectangle, int width, int height) {
        rectangle.width += width;
        rectangle.height += height;
        return rectangle;
    }

    public Rectangle resize(Rectangle rectangle, Point delta) {
        return this.resize(rectangle, delta.x, delta.y);
    }

    /*
     * Unable to fully structure code
     */
    public void runLoop(Shell s) {
        if (!s.isDisposed()) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
lbl6:
            // 3 sources

            ** while (!s.isDisposed())
        }
lbl7:
        // 1 sources

    }

    public <T extends Resource> void safeDispose(Collection<T> resource) {
        for (Resource r : resource) {
            this.safeDispose(r);
        }
    }

    public <T extends Resource> void safeDispose(T ... resource) {
        T[] TArray = resource;
        int n = resource.length;
        int n2 = 0;
        while (n2 < n) {
            T r = TArray[n2];
            this.safeDispose(r);
            ++n2;
        }
    }

    public <W extends Widget> void safeDispose(W ... widgets) {
        W[] WArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            W w = WArray[n2];
            this.safeDispose((Resource)w);
            ++n2;
        }
    }

    public <W extends Widget> void safeDispose(W widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public <T extends Resource> void safeDispose(T r) {
        if (r != null && !r.isDisposed()) {
            r.dispose();
        }
    }

    public Point scale(Point p, double scale) {
        p.x = (int)((double)p.x * scale);
        p.y = (int)((double)p.y * scale);
        return p;
    }

    public Rectangle scale(Rectangle p, double scale) {
        p.x = (int)((double)p.x * scale);
        p.y = (int)((double)p.y * scale);
        p.width = (int)((double)p.width * scale);
        p.height = (int)((double)p.height * scale);
        return p;
    }

    public Transform scale(Transform me, float scale) {
        me.scale(scale, scale);
        return me;
    }

    public void schedule(final Procedure1<Display> p) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                p.apply(Display.getDefault());
            }
        });
    }

    public Rectangle setBottom(Rectangle me, int bottom) {
        me.height = bottom - me.y;
        return me;
    }

    public Rectangle setBottomLeft(Rectangle me, int x, int y) {
        this.setLeft(me, x);
        this.setBottom(me, y);
        return me;
    }

    public Rectangle setBottomLeft(Rectangle me, Point bottomLeft) {
        return this.setBottomLeft(me, bottomLeft.x, bottomLeft.y);
    }

    public Rectangle setBottomRight(Rectangle me, int x, int y) {
        this.setRight(me, x);
        this.setBottom(me, y);
        return me;
    }

    public Rectangle setBottomRight(Rectangle me, Point bottomRight) {
        return this.setBottomRight(me, bottomRight.x, bottomRight.y);
    }

    public int setHeight(Point size, int height) {
        size.y = height;
        return height;
    }

    public Rectangle setLeft(Rectangle me, int left) {
        int right = me.x + me.width;
        me.x = left;
        me.width = right - me.x;
        return me;
    }

    public Rectangle setLocation(Rectangle rectangle, int x, int y) {
        rectangle.x = x;
        rectangle.y = y;
        return rectangle;
    }

    public Rectangle setLocation(Rectangle rectangle, Point location) {
        rectangle.x = location.x;
        rectangle.y = location.y;
        return rectangle;
    }

    public <T extends Shell> void setOnActivate(T control, Listener handler) {
        control.addListener(26, handler);
    }

    public <T extends MenuItem> void setOnArm(T control, Listener handler) {
        control.addListener(30, handler);
    }

    public void setOnClick(Control button, Listener listener) {
        button.addListener(13, listener);
    }

    public void setOnClose(Shell control, Listener listener) {
        control.addListener(21, listener);
    }

    public void setOnCollapse(Tree control, Listener listener) {
        control.addListener(18, listener);
    }

    public void setOnDeactivate(Shell shell, Listener handler) {
        shell.addListener(27, handler);
    }

    public void setOnDefaultSelection(Control control, Listener listener) {
        control.addListener(14, listener);
    }

    public void setOnDeiconify(Shell control, Listener listener) {
        control.addListener(20, listener);
    }

    public void setOnDispose(Control control, Listener listener) {
        control.addListener(12, listener);
    }

    public <T extends Control> void setOnDragDetect(T control, Listener handler) {
        control.addListener(29, handler);
    }

    public <T extends Control> void setOnEraseItem(T control, Listener handler) {
        control.addListener(40, handler);
    }

    public <T extends Widget> void setOnEvent(T widget, int eventType, Listener handler) {
        widget.addListener(eventType, handler);
    }

    public void setOnExpand(Tree control, Listener listener) {
        control.addListener(17, listener);
    }

    public void setOnFocus(Control control, Listener handler) {
        control.addListener(15, handler);
    }

    public void setOnFocusIn(Control control, Listener listener) {
        control.addListener(15, listener);
    }

    public void setOnFocusOut(Control control, Listener handler) {
        control.addListener(16, handler);
    }

    public <T extends Control> void setOnHelp(T control, Listener handler) {
        control.addListener(28, handler);
    }

    public void setOnHide(Shell control, Listener listener) {
        control.addListener(23, listener);
    }

    public void setOnIconify(Shell control, Listener listener) {
        control.addListener(19, listener);
    }

    public void setOnKeyDown(Control button, Listener listener) {
        button.addListener(1, listener);
    }

    public void setOnKeyUp(Control button, Listener listener) {
        button.addListener(2, listener);
    }

    public <T extends Control> void setOnMeasureItem(T control, Listener handler) {
        control.addListener(41, handler);
    }

    public <T extends Control> void setOnModified(T control, Listener handler) {
        control.addListener(24, handler);
    }

    public <T extends Control> void setOnModify(T control, Listener handler) {
        control.addListener(24, handler);
    }

    public void setOnMouseDoubleClick(Control button, Listener listener) {
        button.addListener(8, listener);
    }

    public void setOnMouseDown(Control button, Listener listener) {
        button.addListener(3, listener);
    }

    public void setOnMouseEnter(Control button, Listener listener) {
        button.addListener(6, listener);
    }

    public void setOnMouseExit(Control button, Listener listener) {
        button.addListener(7, listener);
    }

    public <T extends Control> void setOnMouseHorizontalWheel(T control, Listener handler) {
        control.addListener(38, handler);
    }

    public <T extends Control> void setOnMouseHover(T control, Listener handler) {
        control.addListener(32, handler);
    }

    public void setOnMouseMove(Control button, Listener listener) {
        button.addListener(5, listener);
    }

    public void setOnMouseUp(Control button, Listener listener) {
        button.addListener(4, listener);
    }

    public <T extends Control> void setOnMouseVerticalWheel(T control, Listener handler) {
        control.addListener(37, handler);
    }

    public <T extends Control> void setOnMouseWheel(T control, Listener handler) {
        control.addListener(37, handler);
    }

    public void setOnMove(Control control, Listener listener) {
        control.addListener(10, listener);
    }

    public void setOnPaint(Control control, Listener renderer) {
        control.addListener(9, renderer);
    }

    public <T extends Control> void setOnPaintItem(T control, Listener handler) {
        control.addListener(42, handler);
    }

    public void setOnResize(Control control, Listener listener) {
        control.addListener(11, listener);
    }

    public <T extends Widget> void setOnSelection(T w, Listener handler) {
        w.addListener(13, handler);
    }

    public void setOnShow(Shell shell, Listener listener) {
        shell.addListener(22, listener);
    }

    public <T extends Control> void setOnTraverse(T control, Listener handler) {
        control.addListener(31, handler);
    }

    public <T extends Control> void setOnVerify(T control, Listener handler) {
        control.addListener(25, handler);
    }

    public Rectangle setRight(Rectangle me, int right) {
        me.width = right - me.x;
        return me;
    }

    public Rectangle setSize(Rectangle rectangle, int width, int height) {
        rectangle.width = width;
        rectangle.height = height;
        return rectangle;
    }

    public Rectangle setSize(Rectangle rectangle, Point size) {
        rectangle.width = size.x;
        rectangle.height = size.y;
        return rectangle;
    }

    public Rectangle setTop(Rectangle me, int top) {
        int bottom = me.y + me.height;
        me.y = top;
        me.height = bottom - top;
        return me;
    }

    public Rectangle setTopLeft(Rectangle me, int x, int y) {
        this.setLeft(me, x);
        this.setTop(me, y);
        return me;
    }

    public Rectangle setTopLeft(Rectangle me, Point topLeft) {
        return this.setTopLeft(me, topLeft.x, topLeft.y);
    }

    public Rectangle setTopRight(Rectangle me, int x, int y) {
        this.setRight(me, x);
        this.setTop(me, y);
        return me;
    }

    public Rectangle setTopRight(Rectangle me, Point topRight) {
        return this.setTopRight(me, topRight.x, topRight.y);
    }

    public int setWidth(Point size, int width) {
        size.x = width;
        return width;
    }

    public Shell Shell(Procedure1<? super Shell> initializer) {
        Shell _shell;
        Shell s = _shell = new Shell();
        if (initializer != null) {
            initializer.apply((Shell)s);
        }
        return s;
    }

    public String shortenText(GC gc, String text, int width, String ellipses) {
        return this.shortenText(gc, text, width, ellipses, 9);
    }

    public String shortenText(GC gc, String text, int width, String ellipses, int flags) {
        if (gc.textExtent((String)text, (int)flags).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipses, (int)flags).x;
        int length = text.length();
        TextLayout layout = new TextLayout((Device)this.getDisplay());
        layout.setText(text);
        int end = layout.getPreviousOffset(length, 2);
        while (end > 0) {
            text = text.substring(0, end);
            int l = gc.textExtent((String)text, (int)flags).x;
            if (l + ellipseWidth <= width) break;
            end = layout.getPreviousOffset(end, 2);
        }
        layout.dispose();
        return end == 0 ? text.substring(0, 1) : String.valueOf(text) + ellipses;
    }

    public <T extends Resource> T shouldDisposeWith(final T resource, Widget widget) {
        widget.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTExtensions.this.safeDispose(resource);
            }
        });
        return resource;
    }

    public <T extends Control> T showTestGrid(T control) {
        return this.showTestGrid(control, 10, this.COLOR_RED(), 100);
    }

    public <T extends Control> T showTestGrid(final T control, final int gridSize, final Color color, final int alpha) {
        control.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle relativeBounds = SWTExtensions.this.relocateTopLeftWith(control.getBounds(), new Point(0, 0));
                SWTExtensions.this.drawTestGrid(event.gc, relativeBounds, gridSize, color, alpha);
            }
        });
        return control;
    }

    public <T extends Control> T showTestSize(T control) {
        return this.showTestSize(control, 0x1000000, 0x1000000, this.COLOR_RED(), 255);
    }

    public <T extends Control> T showTestSize(T control, Color color, int alpha) {
        return this.showTestSize(control, 0x1000000, 0x1000000, color, alpha);
    }

    public <T extends Control> T showTestSize(final T control, final int horizontal, final int vertical, final Color color, final int alpha) {
        control.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle relativeBounds = SWTExtensions.this.relocateTopLeftWith(control.getBounds(), new Point(0, 0));
                SWTExtensions.this.drawTestSize(event.gc, relativeBounds, horizontal, vertical, color, alpha);
            }
        });
        return control;
    }

    public Rectangle shrink(Rectangle rectangle, int amount) {
        return this.expand(rectangle, -amount);
    }

    public Rectangle shrink(Rectangle rectangle, int horizontal, int vertical) {
        return this.expand(rectangle, -horizontal, -vertical);
    }

    public Rectangle shrink(Rectangle rectangle, int left, int top, int right, int bottom) {
        return this.expand(rectangle, -left, -top, -right, -bottom);
    }

    public Rectangle shrink(Rectangle rectangle, Point delta) {
        return this.expand(rectangle, -delta.x, -delta.y);
    }

    public Rectangle shrink(Rectangle rectangle, Rectangle inset) {
        return this.expand(rectangle, -inset.x, -inset.y, -inset.width, -inset.height);
    }

    public void syncExec(final Procedure1<Void> procedure) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                procedure.apply(null);
            }
        });
    }

    public Color toAutoDisposeColor(HSB hsb) {
        return this.newTemporaryColor(hsb.toRGB());
    }

    public Color[] toAutoDisposeColors(HSB[] hsb) {
        Color[] result = new Color[hsb.length];
        int i = 0;
        while (i < hsb.length) {
            result[i] = this.newTemporaryColor(hsb[i]);
            ++i;
        }
        return result;
    }

    public Color toAutoReleaseColor(HSB hsb) {
        return this.toAutoDisposeColor(hsb);
    }

    public Color[] toAutoReleaseColor(HSB[] hsb) {
        return this.toAutoDisposeColors(hsb);
    }

    public HSB toHSB(Color color) {
        return new HSB(color.getRGB());
    }

    public HSB toHSB(RGB rgb) {
        return new HSB(rgb);
    }

    public HSB[] toHSBArray(Color[] colors) {
        HSB[] result = new HSB[colors.length];
        int i = 0;
        while (i < colors.length) {
            result[i] = new HSB(colors[i].getRGB());
            ++i;
        }
        return result;
    }

    public String toHTMLCode(RGB rgb) {
        return String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
    }

    private int[] toIntArray(Point ... polygon) {
        int[] array = new int[polygon.length * 2];
        int index = 0;
        Point[] pointArray = polygon;
        int n = polygon.length;
        int n2 = 0;
        while (n2 < n) {
            Point each = pointArray[n2];
            array[index++] = each.x;
            array[index++] = each.y;
            ++n2;
        }
        return array;
    }

    public Rectangle toRectangle(Point point) {
        return new Rectangle(point.x, point.y, 0, 0);
    }

    public Color toTemporaryColor(HSB hsb) {
        Color color = (Color)hsb.getData("-swt-extension-color-instance");
        if (color == null || color.isDisposed()) {
            color = this.autoDispose((Resource)new Color((Device)this.getDisplay(), hsb.toRGB()));
            hsb.setData("-swt-extension-color-instance", color);
        }
        return color;
    }

    public Color[] toTemporaryColors(HSB[] hsb) {
        Color[] result = new Color[hsb.length];
        int i = 0;
        while (i < hsb.length) {
            result[i] = this.toAutoDisposeColor(hsb[i]);
            ++i;
        }
        return result;
    }

    public Point translate(Point point, int dx, int dy) {
        point.x += dx;
        point.y += dy;
        return point;
    }

    public Point translate(Point point, Point delta) {
        return this.translate(point, delta.x, delta.y);
    }

    public Rectangle translate(Rectangle rectangle, int dx, int dy) {
        rectangle.x += dx;
        rectangle.y += dy;
        return rectangle;
    }

    public Rectangle translate(Rectangle rectangle, Point delta) {
        return this.translate(rectangle, delta.x, delta.y);
    }

    public Transform translate(Transform me, Point location) {
        me.translate((float)location.x, (float)location.y);
        return me;
    }

    public Point transpose(Point me) {
        Point copy = this.getCopy(me);
        me.x = copy.y;
        me.y = copy.x;
        return me;
    }

    public Rectangle transpose(Rectangle me) {
        Rectangle copy = this.getCopy(me);
        me.x = copy.y;
        me.y = copy.x;
        me.width = copy.height;
        me.height = copy.width;
        return me;
    }

    public Rectangle union(Rectangle rectangle, int x, int y) {
        if (x < rectangle.x) {
            rectangle.width += rectangle.x - x;
            rectangle.x = x;
        } else {
            int right = rectangle.x + rectangle.width;
            if (x >= right) {
                right = x + 1;
                rectangle.width = right - rectangle.x;
            }
        }
        if (y < rectangle.y) {
            rectangle.height += rectangle.y - y;
            rectangle.y = y;
        } else {
            int bottom = rectangle.y + rectangle.height;
            if (y >= bottom) {
                bottom = y + 1;
                rectangle.height = bottom - rectangle.y;
            }
        }
        return rectangle;
    }

    public Rectangle union(Rectangle me, int x, int y, int w, int h) {
        int right = Math.max(me.x + me.width, x + w);
        int bottom = Math.max(me.y + me.height, y + h);
        me.x = Math.min(me.x, x);
        me.y = Math.min(me.y, y);
        me.width = right - me.x;
        me.height = bottom - me.y;
        return me;
    }

    public Rectangle union(Rectangle me, Point point) {
        return this.union(me, point.x, point.y);
    }

    public Rectangle union(Rectangle me, Rectangle other) {
        return this.union(me, other.x, other.y, other.width, other.height);
    }

    public GC withClip(GC gc, Path clip, Procedure1<GC> block) {
        Rectangle oldClip = gc.getClipping();
        if (block != null) {
            gc.setClipping(clip);
            block.apply(gc);
        }
        gc.setClipping(oldClip);
        return gc;
    }

    public GC withClip(GC gc, Rectangle clip, Procedure1<GC> block) {
        Rectangle oldClip = gc.getClipping();
        if (block != null) {
            gc.setClipping(clip);
            block.apply(gc);
        }
        gc.setClipping(oldClip);
        return gc;
    }

    public boolean intersects(Rectangle rectangle, int x, int y) {
        if (x == rectangle.x || x == rectangle.x + rectangle.width) {
            return rectangle.y <= y && y <= rectangle.y + rectangle.height;
        }
        if (y == rectangle.y || y == rectangle.y + rectangle.height) {
            return rectangle.x <= x && x <= rectangle.x + rectangle.width;
        }
        return false;
    }

    public boolean intersects(Rectangle rectangle, Point point) {
        return this.intersects(rectangle, point.x, point.y);
    }
}

