/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.servo.util.VisibleForTesting;

public class StepCounter
extends AbstractMonitor<Number>
implements Counter,
SpectatorMonitor {
    private final StepLong count;
    private final com.netflix.spectator.api.Counter spectatorCounter;

    public StepCounter(MonitorConfig config) {
        this(config, ClockWithOffset.INSTANCE);
    }

    @VisibleForTesting
    public StepCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.NORMALIZED));
        this.count = new StepLong(0L, clock);
        this.spectatorCounter = SpectatorContext.counter(config);
    }

    @Override
    public void increment() {
        this.spectatorCounter.increment();
        this.count.addAndGet(1L);
    }

    @Override
    public void increment(long amount) {
        this.spectatorCounter.increment(amount);
        if (amount > 0L) {
            this.count.addAndGet(amount);
        }
    }

    @Override
    public Number getValue(int pollerIndex) {
        long n = this.count.poll(pollerIndex);
        double stepSeconds = (double)Pollers.POLLING_INTERVALS[pollerIndex] / 1000.0;
        return (double)n / stepSeconds;
    }

    public long getCount(int pollerIndex) {
        return this.count.poll(pollerIndex);
    }

    @VisibleForTesting
    public long getCurrentCount(int pollerIndex) {
        return this.count.getCurrent(pollerIndex).get();
    }

    public String toString() {
        return "StepCounter{config=" + this.config + ", count=" + this.count + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepCounter that = (StepCounter)o;
        return this.config.equals(that.config) && this.getCount(0) == that.getCount(0);
    }

    public int hashCode() {
        return this.config.hashCode();
    }
}

