/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.SpectatorMonitor;
import java.util.concurrent.atomic.AtomicLong;

public class LongGauge
extends AbstractMonitor<Long>
implements Gauge<Long>,
SpectatorMonitor {
    private final AtomicLong number = new AtomicLong(0L);
    private final com.netflix.spectator.api.Gauge spectatorGauge;

    public LongGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.spectatorGauge = SpectatorContext.gauge(config);
    }

    public void set(Long n) {
        this.spectatorGauge.set((double)n.longValue());
        AtomicLong number = this.getNumber();
        number.set(n);
    }

    public AtomicLong getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongGauge that = (LongGauge)o;
        return this.getConfig().equals(that.getConfig()) && this.getValue(0).equals(that.getValue(0));
    }

    public int hashCode() {
        int result = this.getConfig().hashCode();
        result = 31 * result + this.getValue(0).hashCode();
        return result;
    }

    @Override
    public Long getValue(int pollerIdx) {
        return this.number.get();
    }

    public String toString() {
        return "LongGauge{config=" + this.config + ", number=" + this.number + '}';
    }
}

