/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.Gauge;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.SpectatorMonitor;

public class DoubleGauge
extends AbstractMonitor<Double>
implements Gauge<Double>,
SpectatorMonitor {
    private final AtomicDouble number = new AtomicDouble(0.0);
    private final com.netflix.spectator.api.Gauge spectatorGauge;

    public DoubleGauge(MonitorConfig config) {
        super(config.withAdditionalTag(DataSourceType.GAUGE));
        this.spectatorGauge = SpectatorContext.gauge(config);
    }

    public void set(Double n) {
        this.spectatorGauge.set(n.doubleValue());
        this.number.set(n.doubleValue());
    }

    public AtomicDouble getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleGauge that = (DoubleGauge)o;
        return this.getConfig().equals(that.getConfig()) && ((Double)this.getValue()).equals(that.getValue());
    }

    public int hashCode() {
        int result = this.config.hashCode();
        int n = Double.valueOf(this.number.get()).hashCode();
        result = 31 * result + n;
        return result;
    }

    @Override
    public Double getValue(int pollerIdx) {
        return this.number.get();
    }

    public String toString() {
        return "DoubleGauge{config=" + this.config + ", number=" + this.number + '}';
    }
}

