/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReplaceJarsInBundle {
    private static final String JAR = ".jar";
    private static final String EXTENSION = ".txt";
    private static final String PROVIDED = "__PROVIDED__";

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            throw new IllegalArgumentException("Should pass the baseDirectory as an argument");
        }
        File repositoryDirectory = new File(args[0]);
        File bundleDirectory = new File(args[1]);
        File baseBundleDirectory = new File(bundleDirectory, args[2]);
        System.out.println("Replacing jars in " + String.valueOf(repositoryDirectory) + " with the ones already present in " + String.valueOf(bundleDirectory));
        HashMap<String, String> index = new HashMap<String, String>();
        ReplaceJarsInBundle.index(bundleDirectory, baseBundleDirectory, index);
        ReplaceJarsInBundle.replaceFiles(repositoryDirectory, index);
        System.out.println("Done");
    }

    private static void replaceFiles(File repositoryDirectory, HashMap<String, String> index) throws IOException {
        File[] listFiles;
        File[] fileArray = listFiles = repositoryDirectory.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                String fileName = file.getName();
                String pathInSource = index.get(fileName);
                if (pathInSource != null) {
                    String replacementFileName = PROVIDED + fileName + "__PROVIDED__.txt";
                    File replacementFile = new File(file.getParentFile(), replacementFileName);
                    Throwable throwable = null;
                    Object var12_13 = null;
                    try (FileWriter fileWriter = new FileWriter(replacementFile);){
                        fileWriter.write(pathInSource);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    file.delete();
                    System.out.println("Marked " + file.getAbsolutePath() + " for replacement with " + pathInSource);
                }
            } else {
                ReplaceJarsInBundle.replaceFiles(file, index);
            }
            ++n2;
        }
    }

    private static void index(File rootDirectory, File directory, Map<String, String> index) {
        File[] listFiles;
        File[] fileArray = listFiles = directory.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                if (file.getName().endsWith(JAR)) {
                    String relativePath = file.getAbsolutePath().substring(rootDirectory.getAbsolutePath().length());
                    index.put(file.getName(), relativePath);
                }
            } else {
                ReplaceJarsInBundle.index(rootDirectory, file, index);
            }
            ++n2;
        }
    }
}

