/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.metadata;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.AgentMetadataService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.ToolingService;
import java.util.List;
import java.util.function.Function;
import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.deployment.model.api.DeployableArtifact;

@Named(value="mule.agent.metadata.service")
@Singleton
public class MuleAgentMetadataService
extends ConfigurableAgentService
implements AgentMetadataService {
    @Inject
    private ToolingService toolingService;

    public MetadataResult<MetadataKeysContainer> getMetadataKeysApplication(String applicationId, Location location) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getMetadataKeys(location));
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeysDomain(String domainId, Location location) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedDomain(domainId)), manager -> manager.getMetadataKeys(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId, Location location) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getOperationMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId, Location location, MetadataKey key) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getOperationMetadata(location, key));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId, Location location) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getSourceMetadata(location));
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId, Location location, MetadataKey key) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getSourceMetadata(location, key));
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys(String applicationId, Location location) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getEntityKeys(location));
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(String applicationId, Location location, MetadataKey key) {
        return this.withMetadataService(this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)), manager -> manager.getEntityMetadata(location, key));
    }

    public void disposeCacheApplication(String applicationId, String configName) {
        this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedApplication(applicationId)).disposeCache(configName);
    }

    public void disposeCacheDomain(String domainId, String configName) {
        this.getMetadataService((DeployableArtifact)this.toolingService.getDeployedDomain(domainId)).disposeCache(configName);
    }

    private MetadataResult withMetadataService(MetadataService metadataService, Function<MetadataService, MetadataResult> closure) {
        return closure.apply(metadataService);
    }

    private MetadataService getMetadataService(DeployableArtifact artifact) {
        return artifact.getMetadataService();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }
}

