/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.mule.runtime.module.license.internal.ProviderLicense;
import com.mulesoft.mule.runtime.module.license.internal.SecurityUtils;
import com.mulesoft.mule.runtime.module.license.internal.ZippedBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.internal.util.version.VersionRange;
import org.mule.runtime.module.license.api.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerLicense {
    public static final String FEATURE_KEY = "feature.name";
    public static final String VERSIONS_KEY = "valid.versions";
    public static final String CREATION_DATE_KEY = "creation.date";
    public static final String EXPIRATION_DATE_KEY = "expiration.date";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerLicense.class);
    private final String licFileName;
    private final String infoFile;
    private final String signatureFile;
    private final Properties data;

    public CustomerLicense(String licName, ClassLoader artifactClassLoader, ProviderLicense providerLicense) throws InvalidKeyException {
        if (StringUtils.isBlank((CharSequence)licName)) {
            throw new IllegalArgumentException("Provider and ID and license name cannot be blank");
        }
        String licenseNameWithoutExtension = licName.replace(".lic", "");
        this.licFileName = licName;
        this.signatureFile = licenseNameWithoutExtension.concat(".sig");
        this.infoFile = licenseNameWithoutExtension.concat(".info");
        try {
            ZippedBundle licBundle = this.loadLicBundle(artifactClassLoader, this.licFileName);
            if (!this.signatureIsValid(licBundle, providerLicense.getKey())) {
                throw new InvalidLicenseException("[" + this.signatureFile + "] signature is not valid for license " + this.infoFile);
            }
            this.data = this.loadMetaData(licBundle);
        }
        catch (InvalidLicenseException e) {
            throw new InvalidLicenseException(String.format("Required License %s was not found or is not a valid license. Please contact your license provider %s at %s. %s", this.licFileName, providerLicense.getProviderName(), providerLicense.getEmail(), providerLicense.getContactMessage()), (Exception)((Object)e));
        }
    }

    public boolean isValid(String pluginVersion, String requiredEntitlement) {
        return this.hasValidEntitlement(requiredEntitlement) && this.hasValidDate() && this.hasValidVersion(pluginVersion);
    }

    public boolean hasValidVersion(String version) {
        String validVersions = this.data.getProperty(VERSIONS_KEY);
        if (!StringUtils.isBlank((CharSequence)validVersions)) {
            try {
                return new VersionRange(validVersions).contains(version);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidLicenseException(String.format("License [%s] has an invalid value for its `versions` property: [%s]", this.infoFile, validVersions));
            }
        }
        return true;
    }

    public boolean hasValidEntitlement(String requiredEntitlement) {
        return StringUtils.equals((CharSequence)this.data.getProperty(FEATURE_KEY), (CharSequence)requiredEntitlement);
    }

    public boolean hasValidDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        Date today = new Date();
        String creation = this.data.getProperty(CREATION_DATE_KEY);
        String expiration = this.data.getProperty(EXPIRATION_DATE_KEY);
        if (StringUtils.isBlank((CharSequence)creation)) {
            throw new InvalidLicenseException("Invalid data found inside license info. Missing creation Date");
        }
        try {
            return !today.before(dateFormat.parse(creation)) && (StringUtils.isBlank((CharSequence)expiration) || !today.after(dateFormat.parse(expiration)));
        }
        catch (ParseException e) {
            throw new InvalidLicenseException("Invalid date found inside license info. Failed to parse creation or expiration date", (Exception)e);
        }
    }

    private boolean signatureIsValid(ZippedBundle lic, PublicKey vendorKey) {
        Optional<byte[]> signature = lic.get(this.signatureFile);
        if (!signature.isPresent()) {
            LOGGER.error("No signature named {} found in bundle {}", (Object)this.signatureFile, (Object)this.licFileName);
            throw new InvalidLicenseException("Failed to verify signature " + this.signatureFile + ". No signature named " + this.signatureFile + " found in bundle " + this.licFileName);
        }
        Optional<byte[]> metadata = lic.get(this.infoFile);
        if (!metadata.isPresent()) {
            LOGGER.error("No info file named {} found in bundle {}", (Object)this.infoFile, (Object)this.licFileName);
            throw new InvalidLicenseException("Failed to verify license metadata. No info file named " + this.infoFile + " found in bundle " + this.licFileName);
        }
        try {
            return SecurityUtils.verify(signature.get(), metadata.get(), vendorKey);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new InvalidLicenseException("An error occurred wile trying to verify signature [" + this.signatureFile + "] for file " + this.infoFile);
        }
    }

    private Properties loadMetaData(ZippedBundle licBundle) {
        Optional<byte[]> info = licBundle.get(this.infoFile);
        if (!info.isPresent()) {
            LOGGER.error("No metadata file named {} found in bundle {}", (Object)this.infoFile, (Object)this.licFileName);
            throw new InvalidLicenseException("Failed to verify license metadata. No info file named " + this.infoFile + " found in bundle " + this.licFileName);
        }
        try {
            Properties metadata = new Properties();
            metadata.load(new ByteArrayInputStream(info.get()));
            return metadata;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new InvalidLicenseException("Failed to load license properties from " + this.infoFile + " found in license " + String.valueOf(licBundle));
        }
    }

    private ZippedBundle loadLicBundle(ClassLoader artifactClassLoader, String licFile) {
        InputStream bundleIS = artifactClassLoader.getResourceAsStream(licFile);
        if (bundleIS == null) {
            LOGGER.error("License file with name [{}] not found as resource", (Object)licFile);
            throw new InvalidLicenseException("License with name [" + licFile + "] not found as resource. License was not provided or its name is not the expected");
        }
        return new ZippedBundle(bundleIS);
    }

    public String getLicFileName() {
        return this.licFileName;
    }

    public String getExpirationDate() {
        return this.data.getProperty(EXPIRATION_DATE_KEY);
    }
}

