/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.project;

import java.util.ArrayList;
import java.util.Arrays;

public enum MuleProjectDescriptorVersion {
    NO_VERSION(0, ""),
    v3_5_0_0(1, "3.5.0.0"),
    v5_3_0_0(2, "5.3.0.0"),
    UNKNOWN(Integer.MAX_VALUE, "");

    private int intvalue;
    private String label;

    public static MuleProjectDescriptorVersion getLatest() {
        MuleProjectDescriptorVersion latest = NO_VERSION;
        ArrayList<MuleProjectDescriptorVersion> values = new ArrayList<MuleProjectDescriptorVersion>(Arrays.asList(MuleProjectDescriptorVersion.values()));
        values.remove((Object)UNKNOWN);
        values.remove((Object)NO_VERSION);
        for (MuleProjectDescriptorVersion value : values) {
            if (!value.isEqualOrHigherThan(latest)) continue;
            latest = value;
        }
        return latest;
    }

    private MuleProjectDescriptorVersion(int intvalue, String label) {
        this.intvalue = intvalue;
        this.label = label;
    }

    public static MuleProjectDescriptorVersion from(String schemaVersion) {
        if (schemaVersion == null) {
            return NO_VERSION;
        }
        String versionEnumName = "v" + schemaVersion.replaceAll("\\.", "_");
        try {
            return MuleProjectDescriptorVersion.valueOf(MuleProjectDescriptorVersion.class, versionEnumName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNKNOWN;
        }
    }

    public boolean isEqualOrHigherThan(MuleProjectDescriptorVersion otherVersion) {
        return this.intvalue >= otherVersion.intvalue;
    }

    public boolean isLowerThan(MuleProjectDescriptorVersion otherVersion) {
        return this.intvalue < otherVersion.intvalue;
    }

    public String getLabel() {
        return this.label;
    }
}

