/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module.filter;

import java.util.List;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.CualitativeFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;

public class TypeFilter
extends CualitativeFilter {
    private String typeMatcher;

    public TypeFilter(String typeMatcher) {
        this.typeMatcher = typeMatcher;
    }

    @Override
    public boolean accepts(NodeDefinition definition, INodeDefinitionResolver parentResolver) {
        return this.matchesFollowingExtends(definition, parentResolver);
    }

    private boolean matchesFollowingExtends(NodeDefinition definition, INodeDefinitionResolver parentResolver) {
        if (definition == null) {
            return false;
        }
        if (definition.getId().matches(this.typeMatcher)) {
            return true;
        }
        NodeDefinition nodeDefinition = parentResolver.getNodeDefinition(this.typeMatcher);
        if (nodeDefinition != null && nodeDefinition instanceof ContainerDefinition) {
            ContainerDefinition containerDefinition = (ContainerDefinition)nodeDefinition;
            List<NestedContainerDefinition> nestedContainerDefinitions = containerDefinition.getNestedContainerDefinitions();
            for (NestedContainerDefinition nestedContainerDefinition : nestedContainerDefinitions) {
                if (!definition.getId().equals(nestedContainerDefinition.getId())) continue;
                return true;
            }
        }
        return this.matchesFollowingExtends(parentResolver.getParentNodeDefinition(definition), parentResolver);
    }

    public String getTypeMatcher() {
        return this.typeMatcher;
    }

    public String toString() {
        return this.typeMatcher;
    }
}

