/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module.filter;

import java.util.List;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;

public class StereotypeFilter
implements INodeDefinitionFilter {
    private List<Stereotype> allowedStereotypes;

    public StereotypeFilter(List<Stereotype> allowedStereotypes) {
        this.allowedStereotypes = allowedStereotypes;
    }

    @Override
    public boolean accepts(NodeDefinition definition, INodeDefinitionResolver parentResolver) {
        return this.stereotypeMachesAllowed(definition);
    }

    @Override
    public boolean accepts(IMessageFlowNode host, NodeDefinition definition, INodeDefinitionResolver parentResolver) {
        return this.stereotypeMachesAllowed(definition);
    }

    private boolean stereotypeMachesAllowed(NodeDefinition definition) {
        Stereotype stereotype = definition.getStereotype();
        return this.isAnyParentAllowed(stereotype);
    }

    private boolean isAnyParentAllowed(Stereotype stereotype) {
        if (stereotype == null) {
            return false;
        }
        return this.allowedStereotypes.contains(stereotype) || this.isAnyParentAllowed(stereotype.getParent());
    }
}

