/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module.filter;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.filter.AndFilter;
import org.mule.tooling.model.module.filter.CategoryFilter;
import org.mule.tooling.model.module.filter.CualitativeFilter;
import org.mule.tooling.model.module.filter.DefaultFilter;
import org.mule.tooling.model.module.filter.DefinedRepetitionsFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.NotFilter;
import org.mule.tooling.model.module.filter.OrFilter;
import org.mule.tooling.model.module.filter.PropertyFilter;
import org.mule.tooling.model.module.filter.StereotypeFilter;
import org.mule.tooling.model.module.filter.TypeFilter;

public class NodeDefinitionFilterFactory {
    private static final String NUMBER = "[0-9]+";
    private static final String WHITESPACE = "\\s*";
    private static final String NON_WHITESPACE = "[^\\s]+";
    private static final String OR = "\\|\\||OR";
    private static final String AND = "&&|AND";
    private static final String NOT = "!";
    private static final String OPENING_PARENTHESIS = "\\(";
    private static final String CLOSING_PARENTHESIS = "\\)";
    private static final String SINGLE_OR_PARENTHESES_EXPRESSION = "([^\\s]+?|\\(.+\\)?)";
    private static final String PARENTHESES_EXPRESSION = "\\((.+)\\)";
    private static final Pattern REGEX_CATEGORY_PREFIX = Pattern.compile("category:(.+)");
    private static final Pattern REGEX_PARENTHESES_EXPRESSION = Pattern.compile("\\((.+)\\)");
    private static final Pattern REGEX_NEGATED_EXPRESSION = Pattern.compile("!(\\S+|" + String.valueOf(REGEX_PARENTHESES_EXPRESSION) + ")");
    private static final Pattern REGEX_LOGICAL_OPERATORS = Pattern.compile("([^\\s]+?)\\s*(&&|AND|\\|\\||OR)\\s*(.*)");
    private static final Pattern REGEX_REPLACEMENT_TOKEN = Pattern.compile("@[0-9]+");
    private static final Pattern REGEX_CARDINALITY_EXPRESSION = Pattern.compile("([^\\s]+?|\\(.+\\)?)\\{([0-9]+)\\}");
    private static final Pattern REGEX_PROPERTY_EXPRESSION = Pattern.compile("property:([^\\s]+)=([^\\s]+)");

    public static INodeDefinitionFilter createFilter(String expression) {
        INodeDefinitionFilter categoryFilter;
        String trimmedExpression;
        String string = trimmedExpression = expression != null ? expression.trim() : "";
        if (!StringUtils.isEmpty((String)trimmedExpression)) {
            NodeDefinitionFilterFactory.checkBalancedParentheses(trimmedExpression);
            trimmedExpression = NodeDefinitionFilterFactory.removeRepitedSpaces(trimmedExpression);
            categoryFilter = NodeDefinitionFilterFactory.parseExpression(trimmedExpression);
        } else {
            categoryFilter = DefaultFilter.getInstance();
        }
        return categoryFilter;
    }

    private static INodeDefinitionFilter parseExpression(String expression) {
        Matcher parenthesisMatcher = NodeDefinitionFilterFactory.getParenthesisMatcher(expression);
        INodeDefinitionFilter filter = parenthesisMatcher.matches() ? NodeDefinitionFilterFactory.parseExpression(parenthesisMatcher.group(1)) : NodeDefinitionFilterFactory.innerParseExpression(expression);
        return filter;
    }

    private static INodeDefinitionFilter innerParseExpression(String expression) {
        INodeDefinitionFilter filter;
        HashMap<String, String> parenthesesReplacementsMap;
        String trimmedExpression = expression.trim();
        String expressionWithReplacements = NodeDefinitionFilterFactory.performParenthesesReplacements(trimmedExpression, parenthesesReplacementsMap = new HashMap<String, String>());
        Matcher binaryOperatorsMatcher = NodeDefinitionFilterFactory.getBinaryOperatorsMatcher(expressionWithReplacements);
        if (binaryOperatorsMatcher.matches()) {
            String leftOperand = NodeDefinitionFilterFactory.retrieveReplacement(binaryOperatorsMatcher.group(1), parenthesesReplacementsMap);
            String rightOperand = NodeDefinitionFilterFactory.retrieveReplacement(binaryOperatorsMatcher.group(3), parenthesesReplacementsMap);
            filter = NodeDefinitionFilterFactory.parseOperationExpression(binaryOperatorsMatcher.group(2), leftOperand, rightOperand);
        } else {
            filter = NodeDefinitionFilterFactory.parseUnaryExpression(trimmedExpression);
        }
        return filter;
    }

    private static INodeDefinitionFilter parseOperationExpression(String operation, String leftOperand, String rightOperand) {
        if (operation.matches(AND)) {
            return new AndFilter(NodeDefinitionFilterFactory.parseExpression(leftOperand), NodeDefinitionFilterFactory.parseExpression(rightOperand));
        }
        if (operation.matches(OR)) {
            return new OrFilter(NodeDefinitionFilterFactory.parseExpression(leftOperand), NodeDefinitionFilterFactory.parseExpression(rightOperand));
        }
        throw new IllegalArgumentException("Unrecognized operator: " + operation);
    }

    private static INodeDefinitionFilter parseUnaryExpression(String expression) {
        INodeDefinitionFilter filter;
        Matcher cardinalityMatcher = NodeDefinitionFilterFactory.getCardinalityMatcher(expression);
        if (cardinalityMatcher.matches()) {
            String repetitions = cardinalityMatcher.group(2);
            filter = new DefinedRepetitionsFilter(Integer.valueOf(repetitions), NodeDefinitionFilterFactory.parseExpression(cardinalityMatcher.group(1)));
        } else {
            filter = NodeDefinitionFilterFactory.parseNegationExpression(expression);
        }
        return filter;
    }

    private static INodeDefinitionFilter parseNegationExpression(String expression) {
        Matcher negationMatcher = NodeDefinitionFilterFactory.getNegationMatcher(expression);
        INodeDefinitionFilter filter = negationMatcher.matches() ? new NotFilter(NodeDefinitionFilterFactory.parseExpression(negationMatcher.group(1))) : NodeDefinitionFilterFactory.parseFilterStatement(expression);
        return filter;
    }

    private static INodeDefinitionFilter parseFilterStatement(String expression) {
        Matcher categoryPrefixMatcher = NodeDefinitionFilterFactory.getCategoryPrefixMatcher(expression);
        Matcher propertyPrefixMatcher = NodeDefinitionFilterFactory.getPropertyMatcher(expression);
        CualitativeFilter filter = categoryPrefixMatcher.matches() ? new CategoryFilter(categoryPrefixMatcher.group(1)) : (propertyPrefixMatcher.matches() ? new PropertyFilter(propertyPrefixMatcher.group(1), propertyPrefixMatcher.group(2)) : new TypeFilter(expression));
        return filter;
    }

    private static String retrieveReplacement(String expression, HashMap<String, String> parenthesesReplacementsMap) {
        String key = expression.trim();
        if (parenthesesReplacementsMap.containsKey(key)) {
            String replacement = parenthesesReplacementsMap.get(key);
            Matcher replacementsMatcher = NodeDefinitionFilterFactory.getReplacementsMatcher(replacement);
            if (replacementsMatcher.find()) {
                return replacementsMatcher.replaceFirst("(" + NodeDefinitionFilterFactory.retrieveReplacement(replacementsMatcher.group(), parenthesesReplacementsMap) + ")");
            }
            return replacement;
        }
        return expression;
    }

    private static String performParenthesesReplacements(String expression, HashMap<String, String> parenthesesReplacementsMap) {
        String localExpression = expression;
        Matcher parenthesisMatcher = NodeDefinitionFilterFactory.getParenthesisMatcher(localExpression);
        int keyIndex = 1;
        while (parenthesisMatcher.find()) {
            String parenthesisExpression = parenthesisMatcher.group(1);
            String key = "@" + keyIndex++;
            localExpression = parenthesisMatcher.replaceFirst(key);
            parenthesisMatcher = NodeDefinitionFilterFactory.getParenthesisMatcher(localExpression);
            parenthesesReplacementsMap.put(key, parenthesisExpression);
        }
        Matcher negationMatcher = NodeDefinitionFilterFactory.getNegationMatcher(localExpression);
        while (negationMatcher.find()) {
            String negationExpression = negationMatcher.group();
            String key = "@" + keyIndex++;
            localExpression = negationMatcher.replaceFirst(key);
            negationMatcher = NodeDefinitionFilterFactory.getNegationMatcher(localExpression);
            parenthesesReplacementsMap.put(key, negationExpression);
        }
        return localExpression;
    }

    private static Matcher getCardinalityMatcher(String expression) {
        return REGEX_CARDINALITY_EXPRESSION.matcher(expression);
    }

    private static Matcher getPropertyMatcher(String expression) {
        return REGEX_PROPERTY_EXPRESSION.matcher(expression);
    }

    private static Matcher getParenthesisMatcher(String expression) {
        return REGEX_PARENTHESES_EXPRESSION.matcher(expression);
    }

    private static Matcher getReplacementsMatcher(String expression) {
        return REGEX_REPLACEMENT_TOKEN.matcher(expression);
    }

    private static Matcher getBinaryOperatorsMatcher(String expression) {
        return REGEX_LOGICAL_OPERATORS.matcher(expression);
    }

    private static Matcher getNegationMatcher(String expression) {
        return REGEX_NEGATED_EXPRESSION.matcher(expression);
    }

    private static Matcher getCategoryPrefixMatcher(String expression) {
        return REGEX_CATEGORY_PREFIX.matcher(expression);
    }

    private static void checkBalancedParentheses(String expression) {
        int closingParentheses;
        int openingParentheses = StringUtils.countMatches((String)expression, (String)"(");
        if (openingParentheses != (closingParentheses = StringUtils.countMatches((String)expression, (String)")"))) {
            throw new IllegalArgumentException("Expression has unbalanced parentheses: " + expression);
        }
        NodeDefinitionFilterFactory.checkParenthesesAreClosed(expression);
    }

    private static void checkParenthesesAreClosed(String expression) {
        int openParentheses = 0;
        int i = 0;
        while (i < expression.length()) {
            switch (expression.charAt(i)) {
                case '(': {
                    ++openParentheses;
                    break;
                }
                case ')': {
                    --openParentheses;
                    break;
                }
            }
            if (openParentheses < 0) {
                throw new IllegalArgumentException("Expression has an orphan closing parenthesis at index " + i + ". Expression: " + expression);
            }
            ++i;
        }
    }

    private static String removeRepitedSpaces(String str) {
        StringBuilder ourString = new StringBuilder();
        ourString.append(str.charAt(0));
        int i = 1;
        while (i < str.length()) {
            if (str.charAt(i) != ' ' || str.charAt(i - 1) != str.charAt(i)) {
                ourString.append(str.charAt(i));
            }
            ++i;
        }
        return ourString.toString();
    }

    public static INodeDefinitionFilter createFilter(List<Stereotype> allowedStereotypes) {
        return new StereotypeFilter(allowedStereotypes);
    }
}

