/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module.filter;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.filter.CardinalityFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;

public class DefinedRepetitionsFilter
extends CardinalityFilter {
    private final int repetitions;
    private final INodeDefinitionFilter innerFilter;

    public DefinedRepetitionsFilter(int repetitions, INodeDefinitionFilter innerFilter) {
        this.repetitions = repetitions;
        this.innerFilter = innerFilter;
    }

    @Override
    public boolean accepts(IMessageFlowNode host, NodeDefinition guest, INodeDefinitionResolver parentResolver) {
        ChildrenEntityCollectorVisitor visitor = new ChildrenEntityCollectorVisitor();
        host.accept(visitor);
        List<IMessageFlowEntity> children = visitor.getEntities();
        int matchingChildren = 0;
        for (IMessageFlowEntity child : children) {
            MessageFlowNode childNode;
            NodeDefinition childNodeDefinition;
            if (!(child instanceof MessageFlowNode) || (matchingChildren += this.innerFilter.accepts(host, childNodeDefinition = (childNode = (MessageFlowNode)child).getDefinition(), parentResolver) ? 1 : 0) != this.repetitions) continue;
            return false;
        }
        return this.innerFilter.accepts(host, guest, parentResolver);
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public INodeDefinitionFilter getInnerFilter() {
        return this.innerFilter;
    }

    public String toString() {
        return String.valueOf(this.innerFilter) + "{" + this.repetitions + "}";
    }

    private final class ChildrenEntityCollectorVisitor
    implements MessageFlowEntityVisitor {
        private List<IMessageFlowEntity> entities;

        private ChildrenEntityCollectorVisitor() {
        }

        public List<IMessageFlowEntity> getEntities() {
            return this.entities;
        }

        @Override
        public void visitSplitterNode(SplitterNode splitterNode) {
            CompartmentDecorator compartmentDecorator = new CompartmentDecorator(splitterNode.getCompartment(), false);
            this.entities = compartmentDecorator.getCompartmentLanesEntries();
        }

        @Override
        public void visitNestedContainer(NestedContainer nestedContainer) {
            this.add(nestedContainer.getCompartmentLaneEntries());
        }

        private void add(List<IMessageFlowEntity> compartmentLaneEntries) {
            this.entities = new ArrayList<IMessageFlowEntity>(compartmentLaneEntries.size());
            for (IMessageFlowEntity compartmentLaneEntry : compartmentLaneEntries) {
                this.entities.add(compartmentLaneEntry);
            }
        }

        @Override
        public void visitCompartmentLane(CompartmentLane lane) {
            this.add(lane.getCompartmentLaneEntries());
        }

        @Override
        public void visitRoute(Route route) {
            this.visitCompartmentLane(route);
        }

        @Override
        public void visitCompartment(Compartment compartment) {
            CompartmentDecorator compartmentDecorator = new CompartmentDecorator(compartment, false);
            this.entities = compartmentDecorator.getCompartmentLanesEntries();
        }

        @Override
        public void visitUnknownNode(UnknownNode unknownNode) {
        }

        @Override
        public void visitCommentNode(CommentContainer commentNode) {
        }

        @Override
        public void visitPatternNode(PatternNode patternNode) {
        }

        @Override
        public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
        }

        @Override
        public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
        }

        @Override
        public void visitGlobalElement(GlobalElement globalElement) {
        }

        @Override
        public void visitEndpointNode(EndpointNode endpointNode) {
        }

        @Override
        public void visitContainer(Container container) {
            CompartmentDecorator compartmentDecorator = new CompartmentDecorator(container, false);
            this.entities = compartmentDecorator.getCompartmentLanesEntries();
        }
    }
}

