/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.model.messageflow.IPathExpression;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;

public class SplitterDefinition
extends NodeDefinition
implements IPathExpression {
    private List<QName> muleElements = new ArrayList<QName>();
    private boolean contributesToPath;
    private String pathExpression;
    private List<RouteDefinition> routeDefinitions;
    private List<RouteDefinition> completedDefinitions = new ArrayList<RouteDefinition>();

    public List<QName> getMuleElements() {
        return this.muleElements;
    }

    public void setMuleElements(List<QName> muleElements) {
        this.muleElements = muleElements;
    }

    @Override
    public boolean matches(QName name) {
        for (QName n : this.muleElements) {
            if (!n.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(NodeDefinitionVisitor visitor) {
        visitor.visitSplitterDefinition(this);
    }

    public void setContributesToPath(boolean contributesToPath) {
        this.contributesToPath = contributesToPath;
    }

    public void setPathExpression(String pathExpression) {
        this.pathExpression = pathExpression;
    }

    public boolean getContributesToPath() {
        return this.contributesToPath;
    }

    @Override
    public String getPathExpression() {
        return this.pathExpression;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        if (this.completedDefinitions.size() != this.routeDefinitions.size()) {
            IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
            this.routeDefinitions.forEach(route -> {
                String ref = route.getRouteRef();
                RouteDefinition routeDefinition = (RouteDefinition)moduleManager.getNestedDefinition(ref);
                if (routeDefinition != null) {
                    this.completedDefinitions.add(this.completeRoute((RouteDefinition)route, routeDefinition));
                }
            });
        }
        return this.completedDefinitions;
    }

    private RouteDefinition completeRoute(RouteDefinition routeDef1, RouteDefinition routeDef2) {
        routeDef2.setCollapsable(routeDef1.isCollapsable());
        routeDef2.setLayoutFactoryId(routeDef1.getLayoutFactoryId());
        routeDef2.setChildrenCreatorId(routeDef1.getChildrenCreatorId());
        routeDef2.setEditPolicyFactoryId(routeDef1.getEditPolicyFactoryId());
        routeDef2.setRequired(routeDef1.isRequired());
        routeDef2.setMinOccurrence(routeDef1.getMinOccurrence());
        routeDef2.setMaxOccurrence(routeDef1.getMaxOccurrence());
        routeDef2.setXmlOrder(routeDef1.getXmlOrder());
        routeDef2.setPathExpression(routeDef1.getPathExpression());
        routeDef2.setRowNumber(routeDef1.getRowNumber());
        routeDef2.setCaption(routeDef1.getCaption());
        routeDef2.setVisibleInPalette(false);
        return routeDef2;
    }

    public void setRouteDefintions(List<RouteDefinition> routeDefinitions) {
        this.routeDefinitions = routeDefinitions;
    }

    public Optional<RouteDefinition> getRouteDefinition(QName qname) {
        return this.getRouteDefinitions().stream().filter(def -> def.matches(qname)).findFirst();
    }
}

