/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.module.AbstractRequirement;
import org.mule.tooling.model.module.RequirementVisitor;

public class RequiredNativeLibrary
extends AbstractRequirement {
    private final String emptyLocationLabel;

    public RequiredNativeLibrary(String name, String emptyLocationLabel, boolean required) {
        super(name, required, false);
        this.emptyLocationLabel = StringUtils.isEmpty((String)emptyLocationLabel) ? "Please add required library" : emptyLocationLabel;
    }

    @Override
    public String getTypeId() {
        return "nativeLib";
    }

    public String toString() {
        return "RequiredNativeLibrary [name=" + this.getName() + "]";
    }

    @Override
    public void accept(RequirementVisitor visitor) {
        visitor.visitRequiredNativeLib(this);
    }

    @Override
    public String getErrorMesssage() {
        StringBuilder builder = new StringBuilder("Required library ");
        builder.append(this.getName());
        builder.append(" is missing.");
        return builder.toString();
    }

    @Override
    public Collection<String> getAllowedFileExtensions() {
        return ImmutableList.of((Object)"*.dll;*.jnilib;*.dylib;*.so");
    }

    @Override
    public String getEmptyLocationLabel() {
        return this.emptyLocationLabel;
    }

    @Override
    public String getAddButtonText() {
        return "Add Library...";
    }
}

