/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.module.AbstractRequirement;
import org.mule.tooling.model.module.RequirementVisitor;

public class RequiredJar
extends AbstractRequirement {
    public static final String TYPE_ID = "jar";
    public static final String ANY_JAR = "(.*)\\.jar";
    private final String className;
    private final String fileName;
    private final String emptyLocationLabel;
    private final Optional<String> suggestedCoordinates;

    public RequiredJar(String displayName, String className, String fileName, String emptyLocationLabel, String suggestedCoordinates, boolean required) {
        super(displayName, required, RequiredJar.isAmbiguous(fileName, className));
        this.className = className;
        this.fileName = fileName;
        this.emptyLocationLabel = StringUtils.isEmpty((String)emptyLocationLabel) ? "Please add required library" : emptyLocationLabel;
        this.suggestedCoordinates = StringUtils.isEmpty((String)suggestedCoordinates) ? Optional.empty() : Optional.of(suggestedCoordinates);
    }

    private static boolean isAmbiguous(String fileName, String className) {
        return StringUtils.isNotEmpty((String)fileName) && ANY_JAR.equals(fileName) || StringUtils.isEmpty((String)fileName) && StringUtils.isEmpty((String)className);
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    public String toString() {
        return "RequiredJar [name=" + this.getName() + "]";
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void accept(RequirementVisitor visitor) {
        visitor.visitRequiredJar(this);
    }

    @Override
    public String getErrorMesssage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append(" is missing.");
        return builder.toString();
    }

    @Override
    public Collection<String> getAllowedFileExtensions() {
        return ImmutableList.of((Object)"*.jar", (Object)"*.zip");
    }

    @Override
    public String getAddButtonText() {
        return "Add JAR...";
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean fileNameMatches(String fileName) {
        return fileName != null && fileName.matches(this.getFileName());
    }

    @Override
    public String getEmptyLocationLabel() {
        return this.emptyLocationLabel;
    }

    public Optional<String> getSuggestedCoordinates() {
        return this.suggestedCoordinates;
    }
}

