/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.model.module;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.mule.tooling.model.module.AbstractRequirement;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RequirementVisitor;

public class RequiredAlternatives
extends AbstractRequirement {
    public static final String TYPE_ID = "or";
    private final List<? extends Requirement> requirements;
    private final String emptyLocationLabel;

    public RequiredAlternatives(String displayName, List<? extends Requirement> requirements, boolean required) {
        super(displayName, required, false);
        this.requirements = requirements;
        this.emptyLocationLabel = requirements.get(0).getEmptyLocationLabel();
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    public String getChildrenType() {
        return this.getFirstChild().getTypeId();
    }

    @Override
    public String getAddButtonText() {
        return this.requirements.get(0).getAddButtonText();
    }

    private Requirement getFirstChild() {
        return this.requirements.get(0);
    }

    @Override
    public void accept(RequirementVisitor visitor) {
        visitor.visitRequiredAlternatives(this);
    }

    @Override
    public String getErrorMesssage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append(" is missing.");
        return builder.toString();
    }

    @Override
    public Collection<String> getAllowedFileExtensions() {
        HashSet extensions = Sets.newHashSet();
        for (Requirement requirement : this.requirements) {
            extensions.addAll(requirement.getAllowedFileExtensions());
        }
        return extensions;
    }

    public String toString() {
        return "RequiredAlternatives [displayName=" + this.getName() + ", requirements=" + String.valueOf(this.requirements) + "]";
    }

    public List<? extends Requirement> getAlternatives() {
        return this.requirements;
    }

    @Override
    public String getEmptyLocationLabel() {
        return this.emptyLocationLabel;
    }
}

